@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin

import com.pulumi.azurenative.aad.DomainServiceArgs.builder
import com.pulumi.azurenative.aad.kotlin.enums.FilteredSync
import com.pulumi.azurenative.aad.kotlin.enums.SyncScope
import com.pulumi.azurenative.aad.kotlin.inputs.ConfigDiagnosticsArgs
import com.pulumi.azurenative.aad.kotlin.inputs.ConfigDiagnosticsArgsBuilder
import com.pulumi.azurenative.aad.kotlin.inputs.DomainSecuritySettingsArgs
import com.pulumi.azurenative.aad.kotlin.inputs.DomainSecuritySettingsArgsBuilder
import com.pulumi.azurenative.aad.kotlin.inputs.LdapsSettingsArgs
import com.pulumi.azurenative.aad.kotlin.inputs.LdapsSettingsArgsBuilder
import com.pulumi.azurenative.aad.kotlin.inputs.NotificationSettingsArgs
import com.pulumi.azurenative.aad.kotlin.inputs.NotificationSettingsArgsBuilder
import com.pulumi.azurenative.aad.kotlin.inputs.ReplicaSetArgs
import com.pulumi.azurenative.aad.kotlin.inputs.ReplicaSetArgsBuilder
import com.pulumi.azurenative.aad.kotlin.inputs.ResourceForestSettingsArgs
import com.pulumi.azurenative.aad.kotlin.inputs.ResourceForestSettingsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Domain service.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2017-06-01.
 * ## Example Usage
 * ### Create Domain Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domainService = new AzureNative.Aad.DomainService("domainService", new()
 *     {
 *         DomainName = "TestDomainService.com",
 *         DomainSecuritySettings = new AzureNative.Aad.Inputs.DomainSecuritySettingsArgs
 *         {
 *             NtlmV1 = AzureNative.Aad.NtlmV1.Enabled,
 *             SyncNtlmPasswords = AzureNative.Aad.SyncNtlmPasswords.Enabled,
 *             TlsV1 = AzureNative.Aad.TlsV1.Disabled,
 *         },
 *         DomainServiceName = "TestDomainService.com",
 *         FilteredSync = AzureNative.Aad.FilteredSync.Enabled,
 *         LdapsSettings = new AzureNative.Aad.Inputs.LdapsSettingsArgs
 *         {
 *             ExternalAccess = AzureNative.Aad.ExternalAccess.Enabled,
 *             Ldaps = AzureNative.Aad.Ldaps.Enabled,
 *             PfxCertificate = "MIIDPDCCAiSgAwIBAgIQQUI9P6tq2p9OFIJa7DLNvTANBgkqhkiG9w0BAQsFADAgMR4w...",
 *             PfxCertificatePassword = "<pfxCertificatePassword>",
 *         },
 *         NotificationSettings = new AzureNative.Aad.Inputs.NotificationSettingsArgs
 *         {
 *             AdditionalRecipients = new[]
 *             {
 *                 "jicha@microsoft.com",
 *                 "caalmont@microsoft.com",
 *             },
 *             NotifyDcAdmins = AzureNative.Aad.NotifyDcAdmins.Enabled,
 *             NotifyGlobalAdmins = AzureNative.Aad.NotifyGlobalAdmins.Enabled,
 *         },
 *         ReplicaSets = new[]
 *         {
 *             new AzureNative.Aad.Inputs.ReplicaSetArgs
 *             {
 *                 Location = "West US",
 *                 SubnetId = "/subscriptions/1639790a-76a2-4ac4-98d9-8562f5dfcb4d/resourceGroups/TestNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/TestVnetWUS/subnets/TestSubnetWUS",
 *             },
 *         },
 *         ResourceGroupName = "TestResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aad/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aad.NewDomainService(ctx, "domainService", &aad.DomainServiceArgs{
 * 			DomainName: pulumi.String("TestDomainService.com"),
 * 			DomainSecuritySettings: &aad.DomainSecuritySettingsArgs{
 * 				NtlmV1:            pulumi.String(aad.NtlmV1Enabled),
 * 				SyncNtlmPasswords: pulumi.String(aad.SyncNtlmPasswordsEnabled),
 * 				TlsV1:             pulumi.String(aad.TlsV1Disabled),
 * 			},
 * 			DomainServiceName: pulumi.String("TestDomainService.com"),
 * 			FilteredSync:      pulumi.String(aad.FilteredSyncEnabled),
 * 			LdapsSettings: &aad.LdapsSettingsArgs{
 * 				ExternalAccess:         pulumi.String(aad.ExternalAccessEnabled),
 * 				Ldaps:                  pulumi.String(aad.LdapsEnabled),
 * 				PfxCertificate:         pulumi.String("MIIDPDCCAiSgAwIBAgIQQUI9P6tq2p9OFIJa7DLNvTANBgkqhkiG9w0BAQsFADAgMR4w..."),
 * 				PfxCertificatePassword: pulumi.String("<pfxCertificatePassword>"),
 * 			},
 * 			NotificationSettings: &aad.NotificationSettingsArgs{
 * 				AdditionalRecipients: pulumi.StringArray{
 * 					pulumi.String("jicha@microsoft.com"),
 * 					pulumi.String("caalmont@microsoft.com"),
 * 				},
 * 				NotifyDcAdmins:     pulumi.String(aad.NotifyDcAdminsEnabled),
 * 				NotifyGlobalAdmins: pulumi.String(aad.NotifyGlobalAdminsEnabled),
 * 			},
 * 			ReplicaSets: aad.ReplicaSetArray{
 * 				&aad.ReplicaSetArgs{
 * 					Location: pulumi.String("West US"),
 * 					SubnetId: pulumi.String("/subscriptions/1639790a-76a2-4ac4-98d9-8562f5dfcb4d/resourceGroups/TestNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/TestVnetWUS/subnets/TestSubnetWUS"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aad.DomainService;
 * import com.pulumi.azurenative.aad.DomainServiceArgs;
 * import com.pulumi.azurenative.aad.inputs.DomainSecuritySettingsArgs;
 * import com.pulumi.azurenative.aad.inputs.LdapsSettingsArgs;
 * import com.pulumi.azurenative.aad.inputs.NotificationSettingsArgs;
 * import com.pulumi.azurenative.aad.inputs.ReplicaSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainService = new DomainService("domainService", DomainServiceArgs.builder()
 *             .domainName("TestDomainService.com")
 *             .domainSecuritySettings(DomainSecuritySettingsArgs.builder()
 *                 .ntlmV1("Enabled")
 *                 .syncNtlmPasswords("Enabled")
 *                 .tlsV1("Disabled")
 *                 .build())
 *             .domainServiceName("TestDomainService.com")
 *             .filteredSync("Enabled")
 *             .ldapsSettings(LdapsSettingsArgs.builder()
 *                 .externalAccess("Enabled")
 *                 .ldaps("Enabled")
 *                 .pfxCertificate("MIIDPDCCAiSgAwIBAgIQQUI9P6tq2p9OFIJa7DLNvTANBgkqhkiG9w0BAQsFADAgMR4w...")
 *                 .pfxCertificatePassword("<pfxCertificatePassword>")
 *                 .build())
 *             .notificationSettings(NotificationSettingsArgs.builder()
 *                 .additionalRecipients(
 *                     "jicha@microsoft.com",
 *                     "caalmont@microsoft.com")
 *                 .notifyDcAdmins("Enabled")
 *                 .notifyGlobalAdmins("Enabled")
 *                 .build())
 *             .replicaSets(ReplicaSetArgs.builder()
 *                 .location("West US")
 *                 .subnetId("/subscriptions/1639790a-76a2-4ac4-98d9-8562f5dfcb4d/resourceGroups/TestNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/TestVnetWUS/subnets/TestSubnetWUS")
 *                 .build())
 *             .resourceGroupName("TestResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aad:DomainService TestDomainService.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AAD/domainServices/{domainServiceName}
 * ```
 * @property configDiagnostics Configuration diagnostics data containing latest execution from client.
 * @property domainConfigurationType Domain Configuration Type
 * @property domainName The name of the Azure domain that the user would like to deploy Domain Services to.
 * @property domainSecuritySettings DomainSecurity Settings
 * @property domainServiceName The name of the domain service.
 * @property filteredSync Enabled or Disabled flag to turn on Group-based filtered sync
 * @property ldapsSettings Secure LDAP Settings
 * @property location Resource location
 * @property notificationSettings Notification Settings
 * @property replicaSets List of ReplicaSets
 * @property resourceForestSettings Resource Forest Settings
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property sku Sku Type
 * @property syncScope All or CloudOnly, All users in AAD are synced to AAD DS domain or only users actively syncing in the cloud
 * @property tags Resource tags
 */
public data class DomainServiceArgs(
    public val configDiagnostics: Output<ConfigDiagnosticsArgs>? = null,
    public val domainConfigurationType: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val domainSecuritySettings: Output<DomainSecuritySettingsArgs>? = null,
    public val domainServiceName: Output<String>? = null,
    public val filteredSync: Output<Either<String, FilteredSync>>? = null,
    public val ldapsSettings: Output<LdapsSettingsArgs>? = null,
    public val location: Output<String>? = null,
    public val notificationSettings: Output<NotificationSettingsArgs>? = null,
    public val replicaSets: Output<List<ReplicaSetArgs>>? = null,
    public val resourceForestSettings: Output<ResourceForestSettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val syncScope: Output<Either<String, SyncScope>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.DomainServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.DomainServiceArgs =
        com.pulumi.azurenative.aad.DomainServiceArgs.builder()
            .configDiagnostics(configDiagnostics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainConfigurationType(domainConfigurationType?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainSecuritySettings(
                domainSecuritySettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .domainServiceName(domainServiceName?.applyValue({ args0 -> args0 }))
            .filteredSync(
                filteredSync?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ldapsSettings(ldapsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .notificationSettings(
                notificationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .replicaSets(
                replicaSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceForestSettings(
                resourceForestSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .syncScope(
                syncScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DomainServiceArgs].
 */
@PulumiTagMarker
public class DomainServiceArgsBuilder internal constructor() {
    private var configDiagnostics: Output<ConfigDiagnosticsArgs>? = null

    private var domainConfigurationType: Output<String>? = null

    private var domainName: Output<String>? = null

    private var domainSecuritySettings: Output<DomainSecuritySettingsArgs>? = null

    private var domainServiceName: Output<String>? = null

    private var filteredSync: Output<Either<String, FilteredSync>>? = null

    private var ldapsSettings: Output<LdapsSettingsArgs>? = null

    private var location: Output<String>? = null

    private var notificationSettings: Output<NotificationSettingsArgs>? = null

    private var replicaSets: Output<List<ReplicaSetArgs>>? = null

    private var resourceForestSettings: Output<ResourceForestSettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<String>? = null

    private var syncScope: Output<Either<String, SyncScope>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration diagnostics data containing latest execution from client.
     */
    @JvmName("fedtkkffyylourke")
    public suspend fun configDiagnostics(`value`: Output<ConfigDiagnosticsArgs>) {
        this.configDiagnostics = value
    }

    /**
     * @param value Domain Configuration Type
     */
    @JvmName("fycuijoqqmvjlvhc")
    public suspend fun domainConfigurationType(`value`: Output<String>) {
        this.domainConfigurationType = value
    }

    /**
     * @param value The name of the Azure domain that the user would like to deploy Domain Services to.
     */
    @JvmName("nnesgjpglekjgdfn")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value DomainSecurity Settings
     */
    @JvmName("sbsgglbelaawfmog")
    public suspend fun domainSecuritySettings(`value`: Output<DomainSecuritySettingsArgs>) {
        this.domainSecuritySettings = value
    }

    /**
     * @param value The name of the domain service.
     */
    @JvmName("xpgjcgpuuajbqtte")
    public suspend fun domainServiceName(`value`: Output<String>) {
        this.domainServiceName = value
    }

    /**
     * @param value Enabled or Disabled flag to turn on Group-based filtered sync
     */
    @JvmName("hrfbaptyntnrsjph")
    public suspend fun filteredSync(`value`: Output<Either<String, FilteredSync>>) {
        this.filteredSync = value
    }

    /**
     * @param value Secure LDAP Settings
     */
    @JvmName("mdpkxbtlstwgflba")
    public suspend fun ldapsSettings(`value`: Output<LdapsSettingsArgs>) {
        this.ldapsSettings = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("dlademqxonbuftuf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Notification Settings
     */
    @JvmName("yodoubmainmnbckv")
    public suspend fun notificationSettings(`value`: Output<NotificationSettingsArgs>) {
        this.notificationSettings = value
    }

    /**
     * @param value List of ReplicaSets
     */
    @JvmName("fjaujmvhxegftsaf")
    public suspend fun replicaSets(`value`: Output<List<ReplicaSetArgs>>) {
        this.replicaSets = value
    }

    @JvmName("cjmoywbbrscfxndd")
    public suspend fun replicaSets(vararg values: Output<ReplicaSetArgs>) {
        this.replicaSets = Output.all(values.asList())
    }

    /**
     * @param values List of ReplicaSets
     */
    @JvmName("dspvmhiedmuetavs")
    public suspend fun replicaSets(values: List<Output<ReplicaSetArgs>>) {
        this.replicaSets = Output.all(values)
    }

    /**
     * @param value Resource Forest Settings
     */
    @JvmName("ffqrxuixbpxumgiv")
    public suspend fun resourceForestSettings(`value`: Output<ResourceForestSettingsArgs>) {
        this.resourceForestSettings = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("wpekqfjjtbosiccx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sku Type
     */
    @JvmName("sxnfrmgceisygsqy")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value All or CloudOnly, All users in AAD are synced to AAD DS domain or only users actively syncing in the cloud
     */
    @JvmName("qhypwcuefrsoqetc")
    public suspend fun syncScope(`value`: Output<Either<String, SyncScope>>) {
        this.syncScope = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("oriuhgphmgmcvstp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration diagnostics data containing latest execution from client.
     */
    @JvmName("pjcyetxchfpkggni")
    public suspend fun configDiagnostics(`value`: ConfigDiagnosticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configDiagnostics = mapped
    }

    /**
     * @param argument Configuration diagnostics data containing latest execution from client.
     */
    @JvmName("mxrgnqvujaakewjw")
    public suspend fun configDiagnostics(argument: suspend ConfigDiagnosticsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigDiagnosticsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configDiagnostics = mapped
    }

    /**
     * @param value Domain Configuration Type
     */
    @JvmName("ddahukaocvxxqhsd")
    public suspend fun domainConfigurationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainConfigurationType = mapped
    }

    /**
     * @param value The name of the Azure domain that the user would like to deploy Domain Services to.
     */
    @JvmName("gublpqbpexuarxnp")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value DomainSecurity Settings
     */
    @JvmName("pnjtuyhsdsyokvxd")
    public suspend fun domainSecuritySettings(`value`: DomainSecuritySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainSecuritySettings = mapped
    }

    /**
     * @param argument DomainSecurity Settings
     */
    @JvmName("ofylgrviulguwiix")
    public suspend
    fun domainSecuritySettings(argument: suspend DomainSecuritySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainSecuritySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainSecuritySettings = mapped
    }

    /**
     * @param value The name of the domain service.
     */
    @JvmName("nbjhvoxdmiqfpldx")
    public suspend fun domainServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainServiceName = mapped
    }

    /**
     * @param value Enabled or Disabled flag to turn on Group-based filtered sync
     */
    @JvmName("wxluyxevkksnvjyk")
    public suspend fun filteredSync(`value`: Either<String, FilteredSync>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filteredSync = mapped
    }

    /**
     * @param value Enabled or Disabled flag to turn on Group-based filtered sync
     */
    @JvmName("bvpjvijtfotcrqli")
    public fun filteredSync(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FilteredSync>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filteredSync = mapped
    }

    /**
     * @param value Enabled or Disabled flag to turn on Group-based filtered sync
     */
    @JvmName("kdulweewvxhfnnat")
    public fun filteredSync(`value`: FilteredSync) {
        val toBeMapped = Either.ofRight<String, FilteredSync>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filteredSync = mapped
    }

    /**
     * @param value Secure LDAP Settings
     */
    @JvmName("wmsrljkwmvswjcby")
    public suspend fun ldapsSettings(`value`: LdapsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapsSettings = mapped
    }

    /**
     * @param argument Secure LDAP Settings
     */
    @JvmName("vjbgcdrbowccdgvi")
    public suspend fun ldapsSettings(argument: suspend LdapsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LdapsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ldapsSettings = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("fxlffhplaylxtlcg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Notification Settings
     */
    @JvmName("chlntpkfxuhlnlgt")
    public suspend fun notificationSettings(`value`: NotificationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationSettings = mapped
    }

    /**
     * @param argument Notification Settings
     */
    @JvmName("ouobmsgcvqxpelps")
    public suspend
    fun notificationSettings(argument: suspend NotificationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notificationSettings = mapped
    }

    /**
     * @param value List of ReplicaSets
     */
    @JvmName("wkmrxoiixfqorwrb")
    public suspend fun replicaSets(`value`: List<ReplicaSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaSets = mapped
    }

    /**
     * @param argument List of ReplicaSets
     */
    @JvmName("ustpitlpgkswnlil")
    public suspend fun replicaSets(argument: List<suspend ReplicaSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ReplicaSetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.replicaSets = mapped
    }

    /**
     * @param argument List of ReplicaSets
     */
    @JvmName("oxxvhvprfrkugxdd")
    public suspend fun replicaSets(vararg argument: suspend ReplicaSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ReplicaSetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.replicaSets = mapped
    }

    /**
     * @param argument List of ReplicaSets
     */
    @JvmName("seqmiygrlwijtcel")
    public suspend fun replicaSets(argument: suspend ReplicaSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReplicaSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.replicaSets = mapped
    }

    /**
     * @param values List of ReplicaSets
     */
    @JvmName("hivlcfxlksvbyxli")
    public suspend fun replicaSets(vararg values: ReplicaSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicaSets = mapped
    }

    /**
     * @param value Resource Forest Settings
     */
    @JvmName("nfbllbvjinoypwft")
    public suspend fun resourceForestSettings(`value`: ResourceForestSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceForestSettings = mapped
    }

    /**
     * @param argument Resource Forest Settings
     */
    @JvmName("ndvjjgqvsqluyjnp")
    public suspend
    fun resourceForestSettings(argument: suspend ResourceForestSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceForestSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceForestSettings = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("qepqcxiywxiwhequ")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sku Type
     */
    @JvmName("wabwoyvlmralsfup")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value All or CloudOnly, All users in AAD are synced to AAD DS domain or only users actively syncing in the cloud
     */
    @JvmName("rueexrdcemabwfqi")
    public suspend fun syncScope(`value`: Either<String, SyncScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncScope = mapped
    }

    /**
     * @param value All or CloudOnly, All users in AAD are synced to AAD DS domain or only users actively syncing in the cloud
     */
    @JvmName("decgjgjxnoblvfbw")
    public fun syncScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SyncScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncScope = mapped
    }

    /**
     * @param value All or CloudOnly, All users in AAD are synced to AAD DS domain or only users actively syncing in the cloud
     */
    @JvmName("fxrwfkgvwgvhrrrr")
    public fun syncScope(`value`: SyncScope) {
        val toBeMapped = Either.ofRight<String, SyncScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncScope = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ceiokomogxmfyrvt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("koindhpxibmwttna")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DomainServiceArgs = DomainServiceArgs(
        configDiagnostics = configDiagnostics,
        domainConfigurationType = domainConfigurationType,
        domainName = domainName,
        domainSecuritySettings = domainSecuritySettings,
        domainServiceName = domainServiceName,
        filteredSync = filteredSync,
        ldapsSettings = ldapsSettings,
        location = location,
        notificationSettings = notificationSettings,
        replicaSets = replicaSets,
        resourceForestSettings = resourceForestSettings,
        resourceGroupName = resourceGroupName,
        sku = sku,
        syncScope = syncScope,
        tags = tags,
    )
}
