@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A flag to determine whether or not Secure LDAP is enabled or disabled.
 */
public enum class Ldaps(
    public val javaValue: com.pulumi.azurenative.aad.enums.Ldaps,
) : ConvertibleToJava<com.pulumi.azurenative.aad.enums.Ldaps> {
    Enabled(com.pulumi.azurenative.aad.enums.Ldaps.Enabled),
    Disabled(com.pulumi.azurenative.aad.enums.Ldaps.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.aad.enums.Ldaps = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.enums.Ldaps): Ldaps =
            Ldaps.values().first { it.javaValue == javaType }
    }
}
