@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Status for individual validator after running diagnostics.
 */
public enum class Status(
    public val javaValue: com.pulumi.azurenative.aad.enums.Status,
) : ConvertibleToJava<com.pulumi.azurenative.aad.enums.Status> {
    None(com.pulumi.azurenative.aad.enums.Status.None),
    Running(com.pulumi.azurenative.aad.enums.Status.Running),
    OK(com.pulumi.azurenative.aad.enums.Status.OK),
    Failure(com.pulumi.azurenative.aad.enums.Status.Failure),
    Warning(com.pulumi.azurenative.aad.enums.Status.Warning),
    Skipped(com.pulumi.azurenative.aad.enums.Status.Skipped),
    ;

    override fun toJava(): com.pulumi.azurenative.aad.enums.Status = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.enums.Status): Status =
            Status.values().first { it.javaValue == javaType }
    }
}
