@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.ReplicaSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Replica Set Definition
 * @property location Virtual network location
 * @property subnetId The name of the virtual network that Domain Services will be deployed on. The id of the subnet that Domain Services will be deployed on. /virtualNetwork/vnetName/subnets/subnetName.
 */
public data class ReplicaSetArgs(
    public val location: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.ReplicaSetArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.ReplicaSetArgs =
        com.pulumi.azurenative.aad.inputs.ReplicaSetArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicaSetArgs].
 */
@PulumiTagMarker
public class ReplicaSetArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value Virtual network location
     */
    @JvmName("xhljgpcrkofaoiks")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the virtual network that Domain Services will be deployed on. The id of the subnet that Domain Services will be deployed on. /virtualNetwork/vnetName/subnets/subnetName.
     */
    @JvmName("caetntjtwxtutexr")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Virtual network location
     */
    @JvmName("fdfhhnxhyobdloxp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the virtual network that Domain Services will be deployed on. The id of the subnet that Domain Services will be deployed on. /virtualNetwork/vnetName/subnets/subnetName.
     */
    @JvmName("ebodwtkvccsicwoy")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): ReplicaSetArgs = ReplicaSetArgs(
        location = location,
        subnetId = subnetId,
    )
}
