@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container Account Description
 * @property accountName The account name
 * @property password The account password
 * @property spn The account spn
 */
public data class ContainerAccountResponse(
    public val accountName: String? = null,
    public val password: String? = null,
    public val spn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.ContainerAccountResponse):
            ContainerAccountResponse = ContainerAccountResponse(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            spn = javaType.spn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
