@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * PrivateLink Policy configuration object.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * ## Example Usage
 * ### privateLinkPolicyCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkForAzureAd = new AzureNative.AadIam.PrivateLinkForAzureAd("privateLinkForAzureAd", new()
 *     {
 *         AllTenants = false,
 *         Name = "myOrgPrivateLinkPolicy",
 *         OwnerTenantId = "950f8bca-bf4d-4a41-ad10-034e792a243d",
 *         PolicyName = "ddb1",
 *         ResourceGroup = "myOrgVnetRG",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "myOrgVnetPrivateLink",
 *         SubscriptionId = "57849194-ea1f-470b-abda-d195b25634c1",
 *         Tenants = new[]
 *         {
 *             "3616657d-1c80-41ae-9d83-2a2776f2c9be",
 *             "727b6ef1-18ab-4627-ac95-3f9cd945ed87",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewPrivateLinkForAzureAd(ctx, "privateLinkForAzureAd", &aadiam.PrivateLinkForAzureAdArgs{
 * 			AllTenants:        pulumi.Bool(false),
 * 			Name:              pulumi.String("myOrgPrivateLinkPolicy"),
 * 			OwnerTenantId:     pulumi.String("950f8bca-bf4d-4a41-ad10-034e792a243d"),
 * 			PolicyName:        pulumi.String("ddb1"),
 * 			ResourceGroup:     pulumi.String("myOrgVnetRG"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("myOrgVnetPrivateLink"),
 * 			SubscriptionId:    pulumi.String("57849194-ea1f-470b-abda-d195b25634c1"),
 * 			Tenants: pulumi.StringArray{
 * 				pulumi.String("3616657d-1c80-41ae-9d83-2a2776f2c9be"),
 * 				pulumi.String("727b6ef1-18ab-4627-ac95-3f9cd945ed87"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAd;
 * import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkForAzureAd = new PrivateLinkForAzureAd("privateLinkForAzureAd", PrivateLinkForAzureAdArgs.builder()
 *             .allTenants(false)
 *             .name("myOrgPrivateLinkPolicy")
 *             .ownerTenantId("950f8bca-bf4d-4a41-ad10-034e792a243d")
 *             .policyName("ddb1")
 *             .resourceGroup("myOrgVnetRG")
 *             .resourceGroupName("rg1")
 *             .resourceName("myOrgVnetPrivateLink")
 *             .subscriptionId("57849194-ea1f-470b-abda-d195b25634c1")
 *             .tenants(
 *                 "3616657d-1c80-41ae-9d83-2a2776f2c9be",
 *                 "727b6ef1-18ab-4627-ac95-3f9cd945ed87")
 *             .build());
 *     }
 * }
 * ```
 * ### privateLinkPolicyMinCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkForAzureAd = new AzureNative.AadIam.PrivateLinkForAzureAd("privateLinkForAzureAd", new()
 *     {
 *         AllTenants = false,
 *         Name = "myOrgPrivateLinkPolicy",
 *         OwnerTenantId = "950f8bca-bf4d-4a41-ad10-034e792a243d",
 *         PolicyName = "ddb1",
 *         ResourceGroup = "myOrgVnetRG",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "myOrgVnetPrivateLink",
 *         SubscriptionId = "57849194-ea1f-470b-abda-d195b25634c1",
 *         Tenants = new[]
 *         {
 *             "3616657d-1c80-41ae-9d83-2a2776f2c9be",
 *             "727b6ef1-18ab-4627-ac95-3f9cd945ed87",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewPrivateLinkForAzureAd(ctx, "privateLinkForAzureAd", &aadiam.PrivateLinkForAzureAdArgs{
 * 			AllTenants:        pulumi.Bool(false),
 * 			Name:              pulumi.String("myOrgPrivateLinkPolicy"),
 * 			OwnerTenantId:     pulumi.String("950f8bca-bf4d-4a41-ad10-034e792a243d"),
 * 			PolicyName:        pulumi.String("ddb1"),
 * 			ResourceGroup:     pulumi.String("myOrgVnetRG"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("myOrgVnetPrivateLink"),
 * 			SubscriptionId:    pulumi.String("57849194-ea1f-470b-abda-d195b25634c1"),
 * 			Tenants: pulumi.StringArray{
 * 				pulumi.String("3616657d-1c80-41ae-9d83-2a2776f2c9be"),
 * 				pulumi.String("727b6ef1-18ab-4627-ac95-3f9cd945ed87"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAd;
 * import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkForAzureAd = new PrivateLinkForAzureAd("privateLinkForAzureAd", PrivateLinkForAzureAdArgs.builder()
 *             .allTenants(false)
 *             .name("myOrgPrivateLinkPolicy")
 *             .ownerTenantId("950f8bca-bf4d-4a41-ad10-034e792a243d")
 *             .policyName("ddb1")
 *             .resourceGroup("myOrgVnetRG")
 *             .resourceGroupName("rg1")
 *             .resourceName("myOrgVnetPrivateLink")
 *             .subscriptionId("57849194-ea1f-470b-abda-d195b25634c1")
 *             .tenants(
 *                 "3616657d-1c80-41ae-9d83-2a2776f2c9be",
 *                 "727b6ef1-18ab-4627-ac95-3f9cd945ed87")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aadiam:PrivateLinkForAzureAd myOrgPrivateLinkPolicy /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.aadiam/privateLinkForAzureAd/{policyName}
 * ```
 * @property allTenants Flag indicating whether all tenants are allowed
 * @property name Name of this resource.
 * @property ownerTenantId Guid of the owner tenant
 * @property policyName The name of the private link policy in Azure AD.
 * @property resourceGroup Name of the resource group
 * @property resourceGroupName Name of an Azure resource group.
 * @property resourceName Name of the private link policy resource
 * @property subscriptionId Subscription Identifier
 * @property tags Resource tags.
 * @property tenants The list of tenantIds.
 */
public data class PrivateLinkForAzureAdArgs(
    public val allTenants: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val ownerTenantId: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenants: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.PrivateLinkForAzureAdArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.PrivateLinkForAzureAdArgs =
        com.pulumi.azurenative.aadiam.PrivateLinkForAzureAdArgs.builder()
            .allTenants(allTenants?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownerTenantId(ownerTenantId?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenants(tenants?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PrivateLinkForAzureAdArgs].
 */
@PulumiTagMarker
public class PrivateLinkForAzureAdArgsBuilder internal constructor() {
    private var allTenants: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var ownerTenantId: Output<String>? = null

    private var policyName: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenants: Output<List<String>>? = null

    /**
     * @param value Flag indicating whether all tenants are allowed
     */
    @JvmName("wsatckgfdvryhmju")
    public suspend fun allTenants(`value`: Output<Boolean>) {
        this.allTenants = value
    }

    /**
     * @param value Name of this resource.
     */
    @JvmName("mroiejkjbjoylhtk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Guid of the owner tenant
     */
    @JvmName("djlehwvhsxuixnbw")
    public suspend fun ownerTenantId(`value`: Output<String>) {
        this.ownerTenantId = value
    }

    /**
     * @param value The name of the private link policy in Azure AD.
     */
    @JvmName("scvyibccuwsqtino")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("kmpxyihpywqoiiwk")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("hvlumomtuigqajha")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the private link policy resource
     */
    @JvmName("gsphdjfvxtdmtpnn")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Subscription Identifier
     */
    @JvmName("sdxbkkddfdbelhfc")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tuwqmgpqogmsobbn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The list of tenantIds.
     */
    @JvmName("dijylkwrcecfrpll")
    public suspend fun tenants(`value`: Output<List<String>>) {
        this.tenants = value
    }

    @JvmName("tyguleaodcqslkad")
    public suspend fun tenants(vararg values: Output<String>) {
        this.tenants = Output.all(values.asList())
    }

    /**
     * @param values The list of tenantIds.
     */
    @JvmName("fqgvhglxggyxsfmt")
    public suspend fun tenants(values: List<Output<String>>) {
        this.tenants = Output.all(values)
    }

    /**
     * @param value Flag indicating whether all tenants are allowed
     */
    @JvmName("fhrkywoyjubfdiiq")
    public suspend fun allTenants(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allTenants = mapped
    }

    /**
     * @param value Name of this resource.
     */
    @JvmName("olaoglssmwmlxgef")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Guid of the owner tenant
     */
    @JvmName("hjubpeychdvwtneg")
    public suspend fun ownerTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerTenantId = mapped
    }

    /**
     * @param value The name of the private link policy in Azure AD.
     */
    @JvmName("gtgabpawsbxhjjbv")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("nkcpqmptqedkafse")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("cqpuhctopdqfusgq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the private link policy resource
     */
    @JvmName("tppasbirepyxtklw")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Subscription Identifier
     */
    @JvmName("nrdfcahpgqlsrsit")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mqjdhbtdykgmxuxx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cyfrakjiufrujwmh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The list of tenantIds.
     */
    @JvmName("ktcjekvjkjlqqgiq")
    public suspend fun tenants(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenants = mapped
    }

    /**
     * @param values The list of tenantIds.
     */
    @JvmName("pjdsfcxtthjnwvlt")
    public suspend fun tenants(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenants = mapped
    }

    internal fun build(): PrivateLinkForAzureAdArgs = PrivateLinkForAzureAdArgs(
        allTenants = allTenants,
        name = name,
        ownerTenantId = ownerTenantId,
        policyName = policyName,
        resourceGroup = resourceGroup,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        subscriptionId = subscriptionId,
        tags = tags,
        tenants = tenants,
    )
}
