@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.addons.kotlin

import com.pulumi.azurenative.addons.AddonsFunctions.getSupportPlanTypePlain
import com.pulumi.azurenative.addons.kotlin.inputs.GetSupportPlanTypePlainArgs
import com.pulumi.azurenative.addons.kotlin.inputs.GetSupportPlanTypePlainArgsBuilder
import com.pulumi.azurenative.addons.kotlin.outputs.GetSupportPlanTypeResult
import com.pulumi.azurenative.addons.kotlin.outputs.GetSupportPlanTypeResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object AddonsFunctions {
    /**
     * Returns whether or not the canonical support plan of type {type} is enabled for the subscription.
     * Azure REST API version: 2018-03-01.
     * @param argument null
     * @return The status of the Canonical support plan.
     */
    public suspend fun getSupportPlanType(argument: GetSupportPlanTypePlainArgs):
        GetSupportPlanTypeResult = toKotlin(getSupportPlanTypePlain(argument.toJava()).await())

    /**
     * @see [getSupportPlanType].
     * @param planTypeName The Canonical support plan type.
     * @param providerName The support plan type. For now the only valid type is "canonical".
     * @return The status of the Canonical support plan.
     */
    public suspend fun getSupportPlanType(planTypeName: String, providerName: String):
        GetSupportPlanTypeResult {
        val argument = GetSupportPlanTypePlainArgs(
            planTypeName = planTypeName,
            providerName = providerName,
        )
        return toKotlin(getSupportPlanTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getSupportPlanType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;addons&#46;kotlin&#46;inputs&#46;GetSupportPlanTypePlainArgs].
     * @return The status of the Canonical support plan.
     */
    public suspend
    fun getSupportPlanType(argument: suspend GetSupportPlanTypePlainArgsBuilder.() -> Unit):
        GetSupportPlanTypeResult {
        val builder = GetSupportPlanTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getSupportPlanTypePlain(builtArgument.toJava()).await())
    }
}
