@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.addons.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SupportPlanType].
 */
@PulumiTagMarker
public class SupportPlanTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SupportPlanTypeArgs = SupportPlanTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SupportPlanTypeArgsBuilder.() -> Unit) {
        val builder = SupportPlanTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SupportPlanType {
        val builtJavaResource = com.pulumi.azurenative.addons.SupportPlanType(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SupportPlanType(builtJavaResource)
    }
}

/**
 * The status of the Canonical support plan.
 * Azure REST API version: 2018-03-01. Prior API version in Azure Native 1.x: 2018-03-01.
 * ## Example Usage
 * ### SupportPlanTypes_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var supportPlanType = new AzureNative.Addons.SupportPlanType("supportPlanType", new()
 *     {
 *         PlanTypeName = "Standard",
 *         ProviderName = "Canonical",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/addons/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := addons.NewSupportPlanType(ctx, "supportPlanType", &addons.SupportPlanTypeArgs{
 * 			PlanTypeName: pulumi.String("Standard"),
 * 			ProviderName: pulumi.String("Canonical"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.addons.SupportPlanType;
 * import com.pulumi.azurenative.addons.SupportPlanTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var supportPlanType = new SupportPlanType("supportPlanType", SupportPlanTypeArgs.builder()
 *             .planTypeName("Standard")
 *             .providerName("Canonical")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:addons:SupportPlanType Standard /subscriptions/{subscriptionId}/providers/Microsoft.Addons/supportProviders/{providerName}/supportPlanTypes/{planTypeName}
 * ```
 */
public class SupportPlanType internal constructor(
    override val javaResource: com.pulumi.azurenative.addons.SupportPlanType,
) : KotlinCustomResource(javaResource, SupportPlanTypeMapper) {
    /**
     * The name of the Canonical support plan, i.e. "essential", "standard" or "advanced".
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Microsoft.Addons/supportProvider
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SupportPlanTypeMapper : ResourceMapper<SupportPlanType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.addons.SupportPlanType::class == javaResource::class

    override fun map(javaResource: Resource): SupportPlanType = SupportPlanType(
        javaResource as
            com.pulumi.azurenative.addons.SupportPlanType,
    )
}

/**
 * @see [SupportPlanType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SupportPlanType].
 */
public suspend fun supportPlanType(
    name: String,
    block: suspend SupportPlanTypeResourceBuilder.() -> Unit,
): SupportPlanType {
    val builder = SupportPlanTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SupportPlanType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun supportPlanType(name: String): SupportPlanType {
    val builder = SupportPlanTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
