@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.addons.kotlin

import com.pulumi.azurenative.addons.SupportPlanTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The status of the Canonical support plan.
 * Azure REST API version: 2018-03-01. Prior API version in Azure Native 1.x: 2018-03-01.
 * ## Example Usage
 * ### SupportPlanTypes_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var supportPlanType = new AzureNative.Addons.SupportPlanType("supportPlanType", new()
 *     {
 *         PlanTypeName = "Standard",
 *         ProviderName = "Canonical",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/addons/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := addons.NewSupportPlanType(ctx, "supportPlanType", &addons.SupportPlanTypeArgs{
 * 			PlanTypeName: pulumi.String("Standard"),
 * 			ProviderName: pulumi.String("Canonical"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.addons.SupportPlanType;
 * import com.pulumi.azurenative.addons.SupportPlanTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var supportPlanType = new SupportPlanType("supportPlanType", SupportPlanTypeArgs.builder()
 *             .planTypeName("Standard")
 *             .providerName("Canonical")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:addons:SupportPlanType Standard /subscriptions/{subscriptionId}/providers/Microsoft.Addons/supportProviders/{providerName}/supportPlanTypes/{planTypeName}
 * ```
 * @property planTypeName The Canonical support plan type.
 * @property providerName The support plan type. For now the only valid type is "canonical".
 */
public data class SupportPlanTypeArgs(
    public val planTypeName: Output<String>? = null,
    public val providerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.addons.SupportPlanTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.addons.SupportPlanTypeArgs =
        com.pulumi.azurenative.addons.SupportPlanTypeArgs.builder()
            .planTypeName(planTypeName?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SupportPlanTypeArgs].
 */
@PulumiTagMarker
public class SupportPlanTypeArgsBuilder internal constructor() {
    private var planTypeName: Output<String>? = null

    private var providerName: Output<String>? = null

    /**
     * @param value The Canonical support plan type.
     */
    @JvmName("cjrcsjpmtbwpnoip")
    public suspend fun planTypeName(`value`: Output<String>) {
        this.planTypeName = value
    }

    /**
     * @param value The support plan type. For now the only valid type is "canonical".
     */
    @JvmName("gejoygrdjisluygv")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The Canonical support plan type.
     */
    @JvmName("bsnndmhnqqniebjo")
    public suspend fun planTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planTypeName = mapped
    }

    /**
     * @param value The support plan type. For now the only valid type is "canonical".
     */
    @JvmName("hmrcxqdkoyitskcx")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    internal fun build(): SupportPlanTypeArgs = SupportPlanTypeArgs(
        planTypeName = planTypeName,
        providerName = providerName,
    )
}
