@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.SolutionArgs.builder
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.SolutionPropertiesArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.SolutionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Solution resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2021-09-01-preview.
 * ## Example Usage
 * ### Solutions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solution = new AzureNative.AgFoodPlatform.Solution("solution", new()
 *     {
 *         DataManagerForAgricultureResourceName = "examples-farmbeatsResourceName",
 *         ResourceGroupName = "examples-rg",
 *         SolutionId = "abc.partner",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/agfoodplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := agfoodplatform.NewSolution(ctx, "solution", &agfoodplatform.SolutionArgs{
 * 			DataManagerForAgricultureResourceName: pulumi.String("examples-farmbeatsResourceName"),
 * 			ResourceGroupName:                     pulumi.String("examples-rg"),
 * 			SolutionId:                            pulumi.String("abc.partner"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.agfoodplatform.Solution;
 * import com.pulumi.azurenative.agfoodplatform.SolutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solution = new Solution("solution", SolutionArgs.builder()
 *             .dataManagerForAgricultureResourceName("examples-farmbeatsResourceName")
 *             .resourceGroupName("examples-rg")
 *             .solutionId("abc.partner")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:agfoodplatform:Solution string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{dataManagerForAgricultureResourceName}/solutions/{solutionId}
 * ```
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property properties Solution resource properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property solutionId SolutionId for Data Manager For Agriculture Resource.
 */
public data class SolutionArgs(
    public val dataManagerForAgricultureResourceName: Output<String>? = null,
    public val properties: Output<SolutionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val solutionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.SolutionArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.SolutionArgs =
        com.pulumi.azurenative.agfoodplatform.SolutionArgs.builder()
            .dataManagerForAgricultureResourceName(
                dataManagerForAgricultureResourceName?.applyValue({ args0 ->
                    args0
                }),
            )
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .solutionId(solutionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionArgs].
 */
@PulumiTagMarker
public class SolutionArgsBuilder internal constructor() {
    private var dataManagerForAgricultureResourceName: Output<String>? = null

    private var properties: Output<SolutionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var solutionId: Output<String>? = null

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("pnaacgqabfandhhh")
    public suspend fun dataManagerForAgricultureResourceName(`value`: Output<String>) {
        this.dataManagerForAgricultureResourceName = value
    }

    /**
     * @param value Solution resource properties.
     */
    @JvmName("idcjfdipysbsfbyt")
    public suspend fun properties(`value`: Output<SolutionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("unsosmpogrnkkorv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SolutionId for Data Manager For Agriculture Resource.
     */
    @JvmName("vuusjlfyryddnmrg")
    public suspend fun solutionId(`value`: Output<String>) {
        this.solutionId = value
    }

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("imrxdpjcmebyswlp")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value Solution resource properties.
     */
    @JvmName("yanhdrkevjdndgbd")
    public suspend fun properties(`value`: SolutionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Solution resource properties.
     */
    @JvmName("cxgxrungkdcfoqck")
    public suspend fun properties(argument: suspend SolutionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SolutionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("epnhdwiksidpqxnn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SolutionId for Data Manager For Agriculture Resource.
     */
    @JvmName("nvrxfugajtwyspje")
    public suspend fun solutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solutionId = mapped
    }

    internal fun build(): SolutionArgs = SolutionArgs(
        dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        solutionId = solutionId,
    )
}
