@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.GetSolutionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property solutionId SolutionId for Data Manager For Agriculture Resource.
 */
public data class GetSolutionPlainArgs(
    public val dataManagerForAgricultureResourceName: String,
    public val resourceGroupName: String,
    public val solutionId: String,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.GetSolutionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.GetSolutionPlainArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.GetSolutionPlainArgs.builder()
            .dataManagerForAgricultureResourceName(
                dataManagerForAgricultureResourceName.let({ args0 ->
                    args0
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .solutionId(solutionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSolutionPlainArgs].
 */
@PulumiTagMarker
public class GetSolutionPlainArgsBuilder internal constructor() {
    private var dataManagerForAgricultureResourceName: String? = null

    private var resourceGroupName: String? = null

    private var solutionId: String? = null

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("gnunvvnwyiwnhyuk")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ssupmovrvxsbjnkg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SolutionId for Data Manager For Agriculture Resource.
     */
    @JvmName("xkctuyypbieajsyr")
    public suspend fun solutionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.solutionId = mapped
    }

    internal fun build(): GetSolutionPlainArgs = GetSolutionPlainArgs(
        dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName ?: throw
            PulumiNullFieldException("dataManagerForAgricultureResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        solutionId = solutionId ?: throw PulumiNullFieldException("solutionId"),
    )
}
