@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.OAuthClientCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * OAuthClientCredentials for clientId clientSecret auth.
 * @property clientId ClientId associated with the provider.
 * @property clientSecret Properties of the key vault.
 * @property kind Enum for different types of AuthCredentials supported.
 * Expected value is 'OAuthClientCredentials'.
 */
public data class OAuthClientCredentialsArgs(
    public val clientId: Output<String>,
    public val clientSecret: Output<KeyVaultPropertiesArgs>,
    public val kind: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.OAuthClientCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.OAuthClientCredentialsArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.OAuthClientCredentialsArgs.builder()
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OAuthClientCredentialsArgs].
 */
@PulumiTagMarker
public class OAuthClientCredentialsArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<KeyVaultPropertiesArgs>? = null

    private var kind: Output<String>? = null

    /**
     * @param value ClientId associated with the provider.
     */
    @JvmName("neshrfohmkmcgudd")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Properties of the key vault.
     */
    @JvmName("kqtveuwlijotxldv")
    public suspend fun clientSecret(`value`: Output<KeyVaultPropertiesArgs>) {
        this.clientSecret = value
    }

    /**
     * @param value Enum for different types of AuthCredentials supported.
     * Expected value is 'OAuthClientCredentials'.
     */
    @JvmName("lcfpnmdepnccifhy")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value ClientId associated with the provider.
     */
    @JvmName("fhudlpxxwcbqtdfr")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Properties of the key vault.
     */
    @JvmName("uccbrhrseqnkciys")
    public suspend fun clientSecret(`value`: KeyVaultPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param argument Properties of the key vault.
     */
    @JvmName("srfgouxpyojakmju")
    public suspend fun clientSecret(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientSecret = mapped
    }

    /**
     * @param value Enum for different types of AuthCredentials supported.
     * Expected value is 'OAuthClientCredentials'.
     */
    @JvmName("tlnlgcydlsbrphhv")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): OAuthClientCredentialsArgs = OAuthClientCredentialsArgs(
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
        kind = kind ?: throw PulumiNullFieldException("kind"),
    )
}
