@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin

import com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRuleArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.AlertRuleState
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.Severity
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.ActionGroupsInformationArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.ActionGroupsInformationArgsBuilder
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.DetectorArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.DetectorArgsBuilder
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.ThrottlingInformationArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.ThrottlingInformationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The alert rule information
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * ## Example Usage
 * ### Create or update a Smart Detector alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var smartDetectorAlertRule = new AzureNative.AlertsManagement.SmartDetectorAlertRule("smartDetectorAlertRule", new()
 *     {
 *         ActionGroups = new AzureNative.AlertsManagement.Inputs.ActionGroupsInformationArgs
 *         {
 *             CustomEmailSubject = "My custom email subject",
 *             CustomWebhookPayload = "{\"AlertRuleName\":\"#alertrulename\"}",
 *             GroupIds = new[]
 *             {
 *                 "/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourcegroups/actionGroups/providers/microsoft.insights/actiongroups/MyActionGroup",
 *             },
 *         },
 *         AlertRuleName = "MyAlertRule",
 *         Description = "Sample smart detector alert rule description",
 *         Detector = new AzureNative.AlertsManagement.Inputs.DetectorArgs
 *         {
 *             Id = "VMMemoryLeak",
 *         },
 *         Frequency = "PT5M",
 *         ResourceGroupName = "MyAlertRules",
 *         Scope = new[]
 *         {
 *             "/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourceGroups/MyVms/providers/Microsoft.Compute/virtualMachines/vm1",
 *         },
 *         Severity = AzureNative.AlertsManagement.Severity.Sev3,
 *         State = AzureNative.AlertsManagement.AlertRuleState.Enabled,
 *         Throttling = new AzureNative.AlertsManagement.Inputs.ThrottlingInformationArgs
 *         {
 *             Duration = "PT20M",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewSmartDetectorAlertRule(ctx, "smartDetectorAlertRule", &alertsmanagement.SmartDetectorAlertRuleArgs{
 * 			ActionGroups: &alertsmanagement.ActionGroupsInformationArgs{
 * 				CustomEmailSubject:   pulumi.String("My custom email subject"),
 * 				CustomWebhookPayload: pulumi.String("{\"AlertRuleName\":\"#alertrulename\"}"),
 * 				GroupIds: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourcegroups/actionGroups/providers/microsoft.insights/actiongroups/MyActionGroup"),
 * 				},
 * 			},
 * 			AlertRuleName: pulumi.String("MyAlertRule"),
 * 			Description:   pulumi.String("Sample smart detector alert rule description"),
 * 			Detector: &alertsmanagement.DetectorArgs{
 * 				Id: pulumi.String("VMMemoryLeak"),
 * 			},
 * 			Frequency:         pulumi.String("PT5M"),
 * 			ResourceGroupName: pulumi.String("MyAlertRules"),
 * 			Scope: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourceGroups/MyVms/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 			},
 * 			Severity: pulumi.String(alertsmanagement.SeveritySev3),
 * 			State:    pulumi.String(alertsmanagement.AlertRuleStateEnabled),
 * 			Throttling: &alertsmanagement.ThrottlingInformationArgs{
 * 				Duration: pulumi.String("PT20M"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRule;
 * import com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRuleArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupsInformationArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.DetectorArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.ThrottlingInformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var smartDetectorAlertRule = new SmartDetectorAlertRule("smartDetectorAlertRule", SmartDetectorAlertRuleArgs.builder()
 *             .actionGroups(ActionGroupsInformationArgs.builder()
 *                 .customEmailSubject("My custom email subject")
 *                 .customWebhookPayload("{\"AlertRuleName\":\"#alertrulename\"}")
 *                 .groupIds("/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourcegroups/actionGroups/providers/microsoft.insights/actiongroups/MyActionGroup")
 *                 .build())
 *             .alertRuleName("MyAlertRule")
 *             .description("Sample smart detector alert rule description")
 *             .detector(DetectorArgs.builder()
 *                 .id("VMMemoryLeak")
 *                 .build())
 *             .frequency("PT5M")
 *             .resourceGroupName("MyAlertRules")
 *             .scope("/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourceGroups/MyVms/providers/Microsoft.Compute/virtualMachines/vm1")
 *             .severity("Sev3")
 *             .state("Enabled")
 *             .throttling(ThrottlingInformationArgs.builder()
 *                 .duration("PT20M")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:alertsmanagement:SmartDetectorAlertRule MyAlertRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.alertsManagement/smartDetectorAlertRules/{alertRuleName}
 * ```
 * @property actionGroups The alert rule actions.
 * @property alertRuleName The name of the alert rule.
 * @property description The alert rule description.
 * @property detector The alert rule's detector.
 * @property frequency The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 1 minute, depending on the detector.
 * @property location The resource location.
 * @property resourceGroupName The name of the resource group.
 * @property scope The alert rule resources scope.
 * @property severity The alert rule severity.
 * @property state The alert rule state.
 * @property tags The resource tags.
 * @property throttling The alert rule throttling information.
 */
public data class SmartDetectorAlertRuleArgs(
    public val actionGroups: Output<ActionGroupsInformationArgs>? = null,
    public val alertRuleName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val detector: Output<DetectorArgs>? = null,
    public val frequency: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<List<String>>? = null,
    public val severity: Output<Either<String, Severity>>? = null,
    public val state: Output<Either<String, AlertRuleState>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throttling: Output<ThrottlingInformationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRuleArgs =
        com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRuleArgs.builder()
            .actionGroups(actionGroups?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .alertRuleName(alertRuleName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .detector(detector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .frequency(frequency?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .severity(
                severity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throttling(throttling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SmartDetectorAlertRuleArgs].
 */
@PulumiTagMarker
public class SmartDetectorAlertRuleArgsBuilder internal constructor() {
    private var actionGroups: Output<ActionGroupsInformationArgs>? = null

    private var alertRuleName: Output<String>? = null

    private var description: Output<String>? = null

    private var detector: Output<DetectorArgs>? = null

    private var frequency: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<List<String>>? = null

    private var severity: Output<Either<String, Severity>>? = null

    private var state: Output<Either<String, AlertRuleState>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throttling: Output<ThrottlingInformationArgs>? = null

    /**
     * @param value The alert rule actions.
     */
    @JvmName("ntedugycpdcynhsi")
    public suspend fun actionGroups(`value`: Output<ActionGroupsInformationArgs>) {
        this.actionGroups = value
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("uubadevrsokgamxt")
    public suspend fun alertRuleName(`value`: Output<String>) {
        this.alertRuleName = value
    }

    /**
     * @param value The alert rule description.
     */
    @JvmName("onyctdqusoxhinvk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The alert rule's detector.
     */
    @JvmName("hasyfdjmqjalebts")
    public suspend fun detector(`value`: Output<DetectorArgs>) {
        this.detector = value
    }

    /**
     * @param value The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 1 minute, depending on the detector.
     */
    @JvmName("jydqojnjcanaobov")
    public suspend fun frequency(`value`: Output<String>) {
        this.frequency = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("dpchvrybygdhyray")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("noxwfnwyhooahrqd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The alert rule resources scope.
     */
    @JvmName("inwqmykswuscikss")
    public suspend fun scope(`value`: Output<List<String>>) {
        this.scope = value
    }

    @JvmName("jcbhwvcdmsaythdb")
    public suspend fun scope(vararg values: Output<String>) {
        this.scope = Output.all(values.asList())
    }

    /**
     * @param values The alert rule resources scope.
     */
    @JvmName("ktrhtbqikbptohrg")
    public suspend fun scope(values: List<Output<String>>) {
        this.scope = Output.all(values)
    }

    /**
     * @param value The alert rule severity.
     */
    @JvmName("lwbsaeqhpqdqsptm")
    public suspend fun severity(`value`: Output<Either<String, Severity>>) {
        this.severity = value
    }

    /**
     * @param value The alert rule state.
     */
    @JvmName("ykeeexatsisxrfrd")
    public suspend fun state(`value`: Output<Either<String, AlertRuleState>>) {
        this.state = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("daokenjybhstsnii")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The alert rule throttling information.
     */
    @JvmName("wbyyotiwbndpbiiq")
    public suspend fun throttling(`value`: Output<ThrottlingInformationArgs>) {
        this.throttling = value
    }

    /**
     * @param value The alert rule actions.
     */
    @JvmName("fssmipujusjdgpcq")
    public suspend fun actionGroups(`value`: ActionGroupsInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionGroups = mapped
    }

    /**
     * @param argument The alert rule actions.
     */
    @JvmName("njuccewncfqykais")
    public suspend fun actionGroups(argument: suspend ActionGroupsInformationArgsBuilder.() -> Unit) {
        val toBeMapped = ActionGroupsInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actionGroups = mapped
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("uucptqchyjhhwjqb")
    public suspend fun alertRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertRuleName = mapped
    }

    /**
     * @param value The alert rule description.
     */
    @JvmName("fqmfbffrhdvsbsmv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The alert rule's detector.
     */
    @JvmName("hbftrwehxdrtehin")
    public suspend fun detector(`value`: DetectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detector = mapped
    }

    /**
     * @param argument The alert rule's detector.
     */
    @JvmName("jqrlnpbussbajnel")
    public suspend fun detector(argument: suspend DetectorArgsBuilder.() -> Unit) {
        val toBeMapped = DetectorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.detector = mapped
    }

    /**
     * @param value The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 1 minute, depending on the detector.
     */
    @JvmName("gachhcavhdwnbkvd")
    public suspend fun frequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("kdgmydboixjnyluq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ujfxebqtnxlatdjq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The alert rule resources scope.
     */
    @JvmName("trtulxgelcwbfxgv")
    public suspend fun scope(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param values The alert rule resources scope.
     */
    @JvmName("piftijbobwgvfqqv")
    public suspend fun scope(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The alert rule severity.
     */
    @JvmName("fchytfdetwkbymen")
    public suspend fun severity(`value`: Either<String, Severity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The alert rule severity.
     */
    @JvmName("etesqoopsandwesi")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Severity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The alert rule severity.
     */
    @JvmName("wtdjgdqwkilqbbdu")
    public fun severity(`value`: Severity) {
        val toBeMapped = Either.ofRight<String, Severity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The alert rule state.
     */
    @JvmName("naruixvatuichsuo")
    public suspend fun state(`value`: Either<String, AlertRuleState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The alert rule state.
     */
    @JvmName("ncjkuwlbrgkgcwbb")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AlertRuleState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The alert rule state.
     */
    @JvmName("lcjtdjtbgtscljuc")
    public fun state(`value`: AlertRuleState) {
        val toBeMapped = Either.ofRight<String, AlertRuleState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("cvqmtkdecsiwowku")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("geehfvvgwdrtqfne")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The alert rule throttling information.
     */
    @JvmName("doxamkmjmgdtqsxm")
    public suspend fun throttling(`value`: ThrottlingInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttling = mapped
    }

    /**
     * @param argument The alert rule throttling information.
     */
    @JvmName("mhjnkxlpnleatdjk")
    public suspend fun throttling(argument: suspend ThrottlingInformationArgsBuilder.() -> Unit) {
        val toBeMapped = ThrottlingInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.throttling = mapped
    }

    internal fun build(): SmartDetectorAlertRuleArgs = SmartDetectorAlertRuleArgs(
        actionGroups = actionGroups,
        alertRuleName = alertRuleName,
        description = description,
        detector = detector,
        frequency = frequency,
        location = location,
        resourceGroupName = resourceGroupName,
        scope = scope,
        severity = severity,
        state = state,
        tags = tags,
        throttling = throttling,
    )
}
