@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.GetActionRuleByNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionRuleName The name of action rule that needs to be fetched
 * @property resourceGroupName Resource group name where the resource is created.
 */
public data class GetActionRuleByNamePlainArgs(
    public val actionRuleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.GetActionRuleByNamePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.GetActionRuleByNamePlainArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.GetActionRuleByNamePlainArgs.builder()
            .actionRuleName(actionRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetActionRuleByNamePlainArgs].
 */
@PulumiTagMarker
public class GetActionRuleByNamePlainArgsBuilder internal constructor() {
    private var actionRuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of action rule that needs to be fetched
     */
    @JvmName("gdbmupfjafxunsfr")
    public suspend fun actionRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.actionRuleName = mapped
    }

    /**
     * @param value Resource group name where the resource is created.
     */
    @JvmName("awevmahdqhpieqfs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetActionRuleByNamePlainArgs = GetActionRuleByNamePlainArgs(
        actionRuleName = actionRuleName ?: throw PulumiNullFieldException("actionRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
