@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.RemoveAllActionGroupsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Indicates if all action groups should be removed.
 * @property actionType Action that should be applied.
 * Expected value is 'RemoveAllActionGroups'.
 */
public data class RemoveAllActionGroupsArgs(
    public val actionType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.RemoveAllActionGroupsArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.RemoveAllActionGroupsArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.RemoveAllActionGroupsArgs.builder()
            .actionType(actionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemoveAllActionGroupsArgs].
 */
@PulumiTagMarker
public class RemoveAllActionGroupsArgsBuilder internal constructor() {
    private var actionType: Output<String>? = null

    /**
     * @param value Action that should be applied.
     * Expected value is 'RemoveAllActionGroups'.
     */
    @JvmName("kswyaoluakxqdgaq")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value Action that should be applied.
     * Expected value is 'RemoveAllActionGroups'.
     */
    @JvmName("vtxkreahgfqsclyd")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    internal fun build(): RemoveAllActionGroupsArgs = RemoveAllActionGroupsArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
    )
}
