@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The detector information. By default this is not populated, unless it's specified in expandDetector
 * @property description The Smart Detector description.
 * @property id The detector id.
 * @property imagePaths The Smart Detector image path. By default this is not populated, unless it's specified in expandDetector
 * @property name The Smart Detector name.
 * @property parameterDefinitions The Smart Detector parameters definitions.'
 * @property parameters The detector's parameters.'
 * @property supportedCadences The Smart Detector supported cadences.
 * @property supportedResourceTypes The Smart Detector supported resource types.
 */
public data class DetectorResponse(
    public val description: String,
    public val id: String,
    public val imagePaths: List<String>,
    public val name: String,
    public val parameterDefinitions: List<DetectorParameterDefinitionResponse>,
    public val parameters: Map<String, Any>? = null,
    public val supportedCadences: List<Int>,
    public val supportedResourceTypes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.DetectorResponse):
            DetectorResponse = DetectorResponse(
            description = javaType.description(),
            id = javaType.id(),
            imagePaths = javaType.imagePaths().map({ args0 -> args0 }),
            name = javaType.name(),
            parameterDefinitions = javaType.parameterDefinitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.DetectorParameterDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            supportedCadences = javaType.supportedCadences().map({ args0 -> args0 }),
            supportedResourceTypes = javaType.supportedResourceTypes().map({ args0 -> args0 }),
        )
    }
}
