@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Alert processing rule object containing target scopes, conditions and scheduling logic.
 * @property id Azure resource Id
 * @property location Resource location
 * @property name Azure resource name
 * @property properties Alert processing rule properties.
 * @property systemData Alert processing rule system data.
 * @property tags Resource tags
 * @property type Azure resource type
 */
public data class GetAlertProcessingRuleByNameResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: AlertProcessingRulePropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.GetAlertProcessingRuleByNameResult):
            GetAlertProcessingRuleByNameResult = GetAlertProcessingRuleByNameResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.alertsmanagement.kotlin.outputs.AlertProcessingRulePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.alertsmanagement.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
