@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.inputs

import com.pulumi.azurenative.analysisservices.inputs.GatewayDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The gateway details.
 * @property gatewayResourceId Gateway resource to be associated with the server.
 */
public data class GatewayDetailsArgs(
    public val gatewayResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.analysisservices.inputs.GatewayDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.analysisservices.inputs.GatewayDetailsArgs =
        com.pulumi.azurenative.analysisservices.inputs.GatewayDetailsArgs.builder()
            .gatewayResourceId(gatewayResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayDetailsArgs].
 */
@PulumiTagMarker
public class GatewayDetailsArgsBuilder internal constructor() {
    private var gatewayResourceId: Output<String>? = null

    /**
     * @param value Gateway resource to be associated with the server.
     */
    @JvmName("otkhfeosqjhofbbv")
    public suspend fun gatewayResourceId(`value`: Output<String>) {
        this.gatewayResourceId = value
    }

    /**
     * @param value Gateway resource to be associated with the server.
     */
    @JvmName("qpsvpiefkwlnfkyt")
    public suspend fun gatewayResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayResourceId = mapped
    }

    internal fun build(): GatewayDetailsArgs = GatewayDetailsArgs(
        gatewayResourceId = gatewayResourceId,
    )
}
