@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.inputs

import com.pulumi.azurenative.analysisservices.inputs.ResourceSkuArgs.builder
import com.pulumi.azurenative.analysisservices.kotlin.enums.SkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents the SKU name and Azure pricing tier for Analysis Services resource.
 * @property capacity The number of instances in the read only query pool.
 * @property name Name of the SKU level.
 * @property tier The name of the Azure pricing tier to which the SKU applies.
 */
public data class ResourceSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<String>,
    public val tier: Output<Either<String, SkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.analysisservices.inputs.ResourceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.analysisservices.inputs.ResourceSkuArgs =
        com.pulumi.azurenative.analysisservices.inputs.ResourceSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceSkuArgs].
 */
@PulumiTagMarker
public class ResourceSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<String>? = null

    private var tier: Output<Either<String, SkuTier>>? = null

    /**
     * @param value The number of instances in the read only query pool.
     */
    @JvmName("cmgnovfjtypuiquh")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of the SKU level.
     */
    @JvmName("bgnlnjvnbardqlyd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("ldevbtlsjihyftbi")
    public suspend fun tier(`value`: Output<Either<String, SkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The number of instances in the read only query pool.
     */
    @JvmName("seufyutihbwrneqy")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of the SKU level.
     */
    @JvmName("vbbxkyenfqgsrfyb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("txprecwgtvowvtmp")
    public suspend fun tier(`value`: Either<String, SkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("hvscfwgbnecoaxfi")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("ywrsiqbxdrrvlfpe")
    public fun tier(`value`: SkuTier) {
        val toBeMapped = Either.ofRight<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ResourceSkuArgs = ResourceSkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
