@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents the SKU name and Azure pricing tier for Analysis Services resource.
 * @property capacity The number of instances in the read only query pool.
 * @property name Name of the SKU level.
 * @property tier The name of the Azure pricing tier to which the SKU applies.
 */
public data class ResourceSkuResponse(
    public val capacity: Int? = null,
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.analysisservices.outputs.ResourceSkuResponse):
            ResourceSkuResponse = ResourceSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
