@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.ApiVersionArgs.builder
import com.pulumi.azurenative.apicenter.kotlin.enums.LifecycleStage
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API version entity.
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2024-03-15-preview.
 * ## Example Usage
 * ### ApiVersions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiVersion = new AzureNative.ApiCenter.ApiVersion("apiVersion", new()
 *     {
 *         ApiName = "echo-api",
 *         LifecycleStage = AzureNative.ApiCenter.LifecycleStage.Production,
 *         ResourceGroupName = "contoso-resources",
 *         ServiceName = "contoso",
 *         Title = "2023-01-01",
 *         VersionName = "2023-01-01",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewApiVersion(ctx, "apiVersion", &apicenter.ApiVersionArgs{
 * 			ApiName:           pulumi.String("echo-api"),
 * 			LifecycleStage:    pulumi.String(apicenter.LifecycleStageProduction),
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			ServiceName:       pulumi.String("contoso"),
 * 			Title:             pulumi.String("2023-01-01"),
 * 			VersionName:       pulumi.String("2023-01-01"),
 * 			WorkspaceName:     pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.ApiVersion;
 * import com.pulumi.azurenative.apicenter.ApiVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiVersion = new ApiVersion("apiVersion", ApiVersionArgs.builder()
 *             .apiName("echo-api")
 *             .lifecycleStage("production")
 *             .resourceGroupName("contoso-resources")
 *             .serviceName("contoso")
 *             .title("2023-01-01")
 *             .versionName("2023-01-01")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:ApiVersion 2023-01-01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}
 * ```
 * @property apiName The name of the API.
 * @property lifecycleStage Current lifecycle stage of the API.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 * @property title API version title.
 * @property versionName The name of the API version.
 * @property workspaceName The name of the workspace.
 */
public data class ApiVersionArgs(
    public val apiName: Output<String>? = null,
    public val lifecycleStage: Output<Either<String, LifecycleStage>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val title: Output<String>? = null,
    public val versionName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.ApiVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.ApiVersionArgs =
        com.pulumi.azurenative.apicenter.ApiVersionArgs.builder()
            .apiName(apiName?.applyValue({ args0 -> args0 }))
            .lifecycleStage(
                lifecycleStage?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .versionName(versionName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiVersionArgs].
 */
@PulumiTagMarker
public class ApiVersionArgsBuilder internal constructor() {
    private var apiName: Output<String>? = null

    private var lifecycleStage: Output<Either<String, LifecycleStage>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var title: Output<String>? = null

    private var versionName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the API.
     */
    @JvmName("nwimfqtwwetefied")
    public suspend fun apiName(`value`: Output<String>) {
        this.apiName = value
    }

    /**
     * @param value Current lifecycle stage of the API.
     */
    @JvmName("oiylcnmmdoopnbtr")
    public suspend fun lifecycleStage(`value`: Output<Either<String, LifecycleStage>>) {
        this.lifecycleStage = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("foubkcbamhpagunh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("xpgxlefdirkrvcul")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value API version title.
     */
    @JvmName("hyryukuuoaxiwvyf")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The name of the API version.
     */
    @JvmName("hadontrjeudesjtl")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mfltcfsoakypexet")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the API.
     */
    @JvmName("uqldqyetyhupirvm")
    public suspend fun apiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiName = mapped
    }

    /**
     * @param value Current lifecycle stage of the API.
     */
    @JvmName("oowjujjiuqlbovgl")
    public suspend fun lifecycleStage(`value`: Either<String, LifecycleStage>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleStage = mapped
    }

    /**
     * @param value Current lifecycle stage of the API.
     */
    @JvmName("qeemjbfeeovtkkeh")
    public fun lifecycleStage(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LifecycleStage>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleStage = mapped
    }

    /**
     * @param value Current lifecycle stage of the API.
     */
    @JvmName("nhqkxxwqeyublqxr")
    public fun lifecycleStage(`value`: LifecycleStage) {
        val toBeMapped = Either.ofRight<String, LifecycleStage>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleStage = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ybgoloijhyeivfhm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("wxrdrcunmfcmvbaj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value API version title.
     */
    @JvmName("lawyukawuykxtibe")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The name of the API version.
     */
    @JvmName("xytkrsymvpsqxglg")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("bntkuvpcluuojhcr")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ApiVersionArgs = ApiVersionArgs(
        apiName = apiName,
        lifecycleStage = lifecycleStage,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        title = title,
        versionName = versionName,
        workspaceName = workspaceName,
    )
}
