@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.EnvironmentArgs.builder
import com.pulumi.azurenative.apicenter.kotlin.enums.EnvironmentKind
import com.pulumi.azurenative.apicenter.kotlin.inputs.EnvironmentServerArgs
import com.pulumi.azurenative.apicenter.kotlin.inputs.EnvironmentServerArgsBuilder
import com.pulumi.azurenative.apicenter.kotlin.inputs.OnboardingArgs
import com.pulumi.azurenative.apicenter.kotlin.inputs.OnboardingArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Environment entity.
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2024-03-15-preview.
 * ## Example Usage
 * ### Environments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environment = new AzureNative.ApiCenter.Environment("environment", new()
 *     {
 *         Description = "The primary Azure API Management service for the European division of Contoso.",
 *         EnvironmentName = "public",
 *         Kind = AzureNative.ApiCenter.EnvironmentKind.Production,
 *         Onboarding = new AzureNative.ApiCenter.Inputs.OnboardingArgs
 *         {
 *             DeveloperPortalUri = new[]
 *             {
 *                 "https://developer.contoso.com",
 *             },
 *             Instructions = "Sign in or sign up in the specified developer portal to request API access. You must complete the internal privacy training for your account to be approved.",
 *         },
 *         ResourceGroupName = "contoso-resources",
 *         Server = new AzureNative.ApiCenter.Inputs.EnvironmentServerArgs
 *         {
 *             ManagementPortalUri = new[]
 *             {
 *                 "https://management.azure.com/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ApiManagement/service/contoso",
 *             },
 *             Type = AzureNative.ApiCenter.EnvironmentServerType.Azure_API_Management,
 *         },
 *         ServiceName = "contoso",
 *         Title = "Contoso Europe Azure API Management",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewEnvironment(ctx, "environment", &apicenter.EnvironmentArgs{
 * 			Description:     pulumi.String("The primary Azure API Management service for the European division of Contoso."),
 * 			EnvironmentName: pulumi.String("public"),
 * 			Kind:            pulumi.String(apicenter.EnvironmentKindProduction),
 * 			Onboarding: &apicenter.OnboardingArgs{
 * 				DeveloperPortalUri: pulumi.StringArray{
 * 					pulumi.String("https://developer.contoso.com"),
 * 				},
 * 				Instructions: pulumi.String("Sign in or sign up in the specified developer portal to request API access. You must complete the internal privacy training for your account to be approved."),
 * 			},
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			Server: &apicenter.EnvironmentServerArgs{
 * 				ManagementPortalUri: pulumi.StringArray{
 * 					pulumi.String("https://management.azure.com/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ApiManagement/service/contoso"),
 * 				},
 * 				Type: pulumi.String(apicenter.EnvironmentServerType_Azure_API_Management),
 * 			},
 * 			ServiceName:   pulumi.String("contoso"),
 * 			Title:         pulumi.String("Contoso Europe Azure API Management"),
 * 			WorkspaceName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.Environment;
 * import com.pulumi.azurenative.apicenter.EnvironmentArgs;
 * import com.pulumi.azurenative.apicenter.inputs.OnboardingArgs;
 * import com.pulumi.azurenative.apicenter.inputs.EnvironmentServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environment = new Environment("environment", EnvironmentArgs.builder()
 *             .description("The primary Azure API Management service for the European division of Contoso.")
 *             .environmentName("public")
 *             .kind("production")
 *             .onboarding(OnboardingArgs.builder()
 *                 .developerPortalUri("https://developer.contoso.com")
 *                 .instructions("Sign in or sign up in the specified developer portal to request API access. You must complete the internal privacy training for your account to be approved.")
 *                 .build())
 *             .resourceGroupName("contoso-resources")
 *             .server(EnvironmentServerArgs.builder()
 *                 .managementPortalUri("https://management.azure.com/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ApiManagement/service/contoso")
 *                 .type("Azure API Management")
 *                 .build())
 *             .serviceName("contoso")
 *             .title("Contoso Europe Azure API Management")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:Environment public /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/environments/{environmentName}
 * ```
 * @property customProperties The custom metadata defined for API catalog entities.
 * @property description The environment description.
 * @property environmentName The name of the environment.
 * @property kind Environment kind.
 * @property onboarding Environment onboarding information
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property server Server information of the environment.
 * @property serviceName The name of Azure API Center service.
 * @property title Environment title.
 * @property workspaceName The name of the workspace.
 */
public data class EnvironmentArgs(
    public val customProperties: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val kind: Output<Either<String, EnvironmentKind>>? = null,
    public val onboarding: Output<OnboardingArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val server: Output<EnvironmentServerArgs>? = null,
    public val serviceName: Output<String>? = null,
    public val title: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.EnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.EnvironmentArgs =
        com.pulumi.azurenative.apicenter.EnvironmentArgs.builder()
            .customProperties(customProperties?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .onboarding(onboarding?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentArgs].
 */
@PulumiTagMarker
public class EnvironmentArgsBuilder internal constructor() {
    private var customProperties: Output<Any>? = null

    private var description: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var kind: Output<Either<String, EnvironmentKind>>? = null

    private var onboarding: Output<OnboardingArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var server: Output<EnvironmentServerArgs>? = null

    private var serviceName: Output<String>? = null

    private var title: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The custom metadata defined for API catalog entities.
     */
    @JvmName("qsiqbtdrauggqutw")
    public suspend fun customProperties(`value`: Output<Any>) {
        this.customProperties = value
    }

    /**
     * @param value The environment description.
     */
    @JvmName("rxdarwkwrmqwebjq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("lbrhjqhgtimrkqfu")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Environment kind.
     */
    @JvmName("xfoourppsmgfrnxb")
    public suspend fun kind(`value`: Output<Either<String, EnvironmentKind>>) {
        this.kind = value
    }

    /**
     * @param value Environment onboarding information
     */
    @JvmName("gogickvcwleleuaw")
    public suspend fun onboarding(`value`: Output<OnboardingArgs>) {
        this.onboarding = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bwiwyaoredhrtsmy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Server information of the environment.
     */
    @JvmName("tyvocpmknugcfuix")
    public suspend fun server(`value`: Output<EnvironmentServerArgs>) {
        this.server = value
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("uvewgkrexwynxeai")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Environment title.
     */
    @JvmName("bhhwkxsoefdssdqd")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ycjlbomlxlbwqjvt")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The custom metadata defined for API catalog entities.
     */
    @JvmName("gqwniylvivdviusq")
    public suspend fun customProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value The environment description.
     */
    @JvmName("fwcspwysmlmovvaj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("dxnudohggygybrnn")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Environment kind.
     */
    @JvmName("juydjulqsjgwgvas")
    public suspend fun kind(`value`: Either<String, EnvironmentKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Environment kind.
     */
    @JvmName("tvebfhpbwlxabxfs")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnvironmentKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Environment kind.
     */
    @JvmName("dudotdwnteirdawq")
    public fun kind(`value`: EnvironmentKind) {
        val toBeMapped = Either.ofRight<String, EnvironmentKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Environment onboarding information
     */
    @JvmName("wmyogyeyiuontnsj")
    public suspend fun onboarding(`value`: OnboardingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onboarding = mapped
    }

    /**
     * @param argument Environment onboarding information
     */
    @JvmName("fpnagvljoiuijxlq")
    public suspend fun onboarding(argument: suspend OnboardingArgsBuilder.() -> Unit) {
        val toBeMapped = OnboardingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onboarding = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gmbkvwrflipkfqpb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Server information of the environment.
     */
    @JvmName("ftsdefyxaqqitlhb")
    public suspend fun server(`value`: EnvironmentServerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param argument Server information of the environment.
     */
    @JvmName("idggcrslenlmwypp")
    public suspend fun server(argument: suspend EnvironmentServerArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentServerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.server = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("wxggryfsdhycpipm")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Environment title.
     */
    @JvmName("fdmevdyihjaieujp")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("emvgsrvipvleaphy")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): EnvironmentArgs = EnvironmentArgs(
        customProperties = customProperties,
        description = description,
        environmentName = environmentName,
        kind = kind,
        onboarding = onboarding,
        resourceGroupName = resourceGroupName,
        server = server,
        serviceName = serviceName,
        title = title,
        workspaceName = workspaceName,
    )
}
