@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.kotlin.outputs.MetadataAssignmentResponse
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.apicenter.kotlin.outputs.MetadataAssignmentResponse.Companion.toKotlin as metadataAssignmentResponseToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MetadataSchema].
 */
@PulumiTagMarker
public class MetadataSchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetadataSchemaArgs = MetadataSchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetadataSchemaArgsBuilder.() -> Unit) {
        val builder = MetadataSchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MetadataSchema {
        val builtJavaResource = com.pulumi.azurenative.apicenter.MetadataSchema(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MetadataSchema(builtJavaResource)
    }
}

/**
 * Metadata schema entity. Used to define metadata for the entities in API catalog.
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2024-03-15-preview.
 * ## Example Usage
 * ### MetadataSchemas_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metadataSchema = new AzureNative.ApiCenter.MetadataSchema("metadataSchema", new()
 *     {
 *         AssignedTo = new[]
 *         {
 *             new AzureNative.ApiCenter.Inputs.MetadataAssignmentArgs
 *             {
 *                 Deprecated = true,
 *                 Entity = AzureNative.ApiCenter.MetadataAssignmentEntity.Api,
 *             },
 *         },
 *         MetadataSchemaName = "author",
 *         ResourceGroupName = "contoso-resources",
 *         Schema = "{\"type\":\"string\", \"title\":\"Author\", pattern: \"^[a-zA-Z]+$\"}",
 *         ServiceName = "contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewMetadataSchema(ctx, "metadataSchema", &apicenter.MetadataSchemaArgs{
 * 			AssignedTo: apicenter.MetadataAssignmentArray{
 * 				&apicenter.MetadataAssignmentArgs{
 * 					Deprecated: pulumi.Bool(true),
 * 					Entity:     pulumi.String(apicenter.MetadataAssignmentEntityApi),
 * 				},
 * 			},
 * 			MetadataSchemaName: pulumi.String("author"),
 * 			ResourceGroupName:  pulumi.String("contoso-resources"),
 * 			Schema:             pulumi.String("{\"type\":\"string\", \"title\":\"Author\", pattern: \"^[a-zA-Z]+$\"}"),
 * 			ServiceName:        pulumi.String("contoso"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.MetadataSchema;
 * import com.pulumi.azurenative.apicenter.MetadataSchemaArgs;
 * import com.pulumi.azurenative.apicenter.inputs.MetadataAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metadataSchema = new MetadataSchema("metadataSchema", MetadataSchemaArgs.builder()
 *             .assignedTo(MetadataAssignmentArgs.builder()
 *                 .deprecated(true)
 *                 .entity("api")
 *                 .build())
 *             .metadataSchemaName("author")
 *             .resourceGroupName("contoso-resources")
 *             .schema("{\"type\":\"string\", \"title\":\"Author\", pattern: \"^[a-zA-Z]+$\"}")
 *             .serviceName("contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:MetadataSchema author /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/metadataSchemas/{metadataSchemaName}
 * ```
 */
public class MetadataSchema internal constructor(
    override val javaResource: com.pulumi.azurenative.apicenter.MetadataSchema,
) : KotlinCustomResource(javaResource, MetadataSchemaMapper) {
    /**
     * The assignees
     */
    public val assignedTo: Output<List<MetadataAssignmentResponse>>?
        get() = javaResource.assignedTo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> metadataAssignmentResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The schema defining the type.
     */
    public val schema: Output<String>
        get() = javaResource.schema().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MetadataSchemaMapper : ResourceMapper<MetadataSchema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apicenter.MetadataSchema::class == javaResource::class

    override fun map(javaResource: Resource): MetadataSchema = MetadataSchema(
        javaResource as
            com.pulumi.azurenative.apicenter.MetadataSchema,
    )
}

/**
 * @see [MetadataSchema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetadataSchema].
 */
public suspend fun metadataSchema(
    name: String,
    block: suspend MetadataSchemaResourceBuilder.() -> Unit,
): MetadataSchema {
    val builder = MetadataSchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetadataSchema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metadataSchema(name: String): MetadataSchema {
    val builder = MetadataSchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
