@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the server that represents the environment.
 */
public enum class EnvironmentServerType(
    public val javaValue: com.pulumi.azurenative.apicenter.enums.EnvironmentServerType,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.enums.EnvironmentServerType> {
    /**
     * Api Management Server
     */
    Azure_API_Management(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Azure_API_Management),

    /**
     * Compute server
     */
    Azure_compute_service(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Azure_compute_service),

    /**
     * Apigee server
     */
    Apigee_API_Management(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Apigee_API_Management),

    /**
     * AWS Api Gateway server
     */
    AWS_API_Gateway(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.AWS_API_Gateway),

    /**
     * Kong API Gateway server
     */
    Kong_API_Gateway(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Kong_API_Gateway),

    /**
     * Kubernetes server
     */
    Kubernetes(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Kubernetes),

    /**
     * Mulesoft Api Management server
     */
    MuleSoft_API_Management(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.MuleSoft_API_Management),
    ;

    override fun toJava(): com.pulumi.azurenative.apicenter.enums.EnvironmentServerType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.enums.EnvironmentServerType):
            EnvironmentServerType = EnvironmentServerType.values().first { it.javaValue == javaType }
    }
}
