@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.GetMetadataSchemaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metadataSchemaName The name of the metadata schema.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 */
public data class GetMetadataSchemaPlainArgs(
    public val metadataSchemaName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.GetMetadataSchemaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.GetMetadataSchemaPlainArgs =
        com.pulumi.azurenative.apicenter.inputs.GetMetadataSchemaPlainArgs.builder()
            .metadataSchemaName(metadataSchemaName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMetadataSchemaPlainArgs].
 */
@PulumiTagMarker
public class GetMetadataSchemaPlainArgsBuilder internal constructor() {
    private var metadataSchemaName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the metadata schema.
     */
    @JvmName("scmummcsjviiyhku")
    public suspend fun metadataSchemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.metadataSchemaName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("okshoonjpfvxeken")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("kvresaigruckgaxq")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetMetadataSchemaPlainArgs = GetMetadataSchemaPlainArgs(
        metadataSchemaName = metadataSchemaName ?: throw PulumiNullFieldException("metadataSchemaName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
