@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.LicenseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The license information for the API.
 * @property identifier SPDX license information for the API. The identifier field is mutually
 * exclusive of the URL field.
 * @property name Name of the license.
 * @property url URL pointing to the license details. The URL field is mutually exclusive of the
 * identifier field.
 */
public data class LicenseArgs(
    public val identifier: Output<String>? = null,
    public val name: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.LicenseArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.LicenseArgs =
        com.pulumi.azurenative.apicenter.inputs.LicenseArgs.builder()
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LicenseArgs].
 */
@PulumiTagMarker
public class LicenseArgsBuilder internal constructor() {
    private var identifier: Output<String>? = null

    private var name: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value SPDX license information for the API. The identifier field is mutually
     * exclusive of the URL field.
     */
    @JvmName("qjyaubeltfaktnnu")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Name of the license.
     */
    @JvmName("qnncgberdbufktvq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value URL pointing to the license details. The URL field is mutually exclusive of the
     * identifier field.
     */
    @JvmName("aejpyckvghdvoibc")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value SPDX license information for the API. The identifier field is mutually
     * exclusive of the URL field.
     */
    @JvmName("aawevxwsxxttfumm")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Name of the license.
     */
    @JvmName("emeiaiecgthocjvq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value URL pointing to the license details. The URL field is mutually exclusive of the
     * identifier field.
     */
    @JvmName("nupixhxxwkdtxsep")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): LicenseArgs = LicenseArgs(
        identifier = identifier,
        name = name,
        url = url,
    )
}
