@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.MetadataAssignmentArgs.builder
import com.pulumi.azurenative.apicenter.kotlin.enums.MetadataAssignmentEntity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Assignment metadata
 * @property deprecated Deprecated assignment
 * @property entity The entities this metadata schema component gets applied to.
 * @property required Required assignment
 */
public data class MetadataAssignmentArgs(
    public val deprecated: Output<Boolean>? = null,
    public val entity: Output<Either<String, MetadataAssignmentEntity>>? = null,
    public val required: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.MetadataAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.MetadataAssignmentArgs =
        com.pulumi.azurenative.apicenter.inputs.MetadataAssignmentArgs.builder()
            .deprecated(deprecated?.applyValue({ args0 -> args0 }))
            .entity(
                entity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .required(required?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetadataAssignmentArgs].
 */
@PulumiTagMarker
public class MetadataAssignmentArgsBuilder internal constructor() {
    private var deprecated: Output<Boolean>? = null

    private var entity: Output<Either<String, MetadataAssignmentEntity>>? = null

    private var required: Output<Boolean>? = null

    /**
     * @param value Deprecated assignment
     */
    @JvmName("jjfcappfptpjpmjn")
    public suspend fun deprecated(`value`: Output<Boolean>) {
        this.deprecated = value
    }

    /**
     * @param value The entities this metadata schema component gets applied to.
     */
    @JvmName("jbrgxjvomixpwqof")
    public suspend fun entity(`value`: Output<Either<String, MetadataAssignmentEntity>>) {
        this.entity = value
    }

    /**
     * @param value Required assignment
     */
    @JvmName("uwbhvclwuapyvbjy")
    public suspend fun required(`value`: Output<Boolean>) {
        this.required = value
    }

    /**
     * @param value Deprecated assignment
     */
    @JvmName("uytkedbtasjvcaid")
    public suspend fun deprecated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecated = mapped
    }

    /**
     * @param value The entities this metadata schema component gets applied to.
     */
    @JvmName("kjmedqrjwdglapvj")
    public suspend fun entity(`value`: Either<String, MetadataAssignmentEntity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entity = mapped
    }

    /**
     * @param value The entities this metadata schema component gets applied to.
     */
    @JvmName("bldxwtihpgkfpgnk")
    public fun entity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MetadataAssignmentEntity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entity = mapped
    }

    /**
     * @param value The entities this metadata schema component gets applied to.
     */
    @JvmName("eqjldrlcqiweasyy")
    public fun entity(`value`: MetadataAssignmentEntity) {
        val toBeMapped = Either.ofRight<String, MetadataAssignmentEntity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entity = mapped
    }

    /**
     * @param value Required assignment
     */
    @JvmName("tpjmolbqwkogtajq")
    public suspend fun required(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.required = mapped
    }

    internal fun build(): MetadataAssignmentArgs = MetadataAssignmentArgs(
        deprecated = deprecated,
        entity = entity,
        required = required,
    )
}
