@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Metadata schema entity. Used to define metadata for the entities in API catalog.
 * @property assignedTo The assignees
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property schema The schema defining the type.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMetadataSchemaResult(
    public val assignedTo: List<MetadataAssignmentResponse>? = null,
    public val id: String,
    public val name: String,
    public val schema: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.GetMetadataSchemaResult):
            GetMetadataSchemaResult = GetMetadataSchemaResult(
            assignedTo = javaType.assignedTo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apicenter.kotlin.outputs.MetadataAssignmentResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            schema = javaType.schema(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
