@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Onboarding information
 * @property developerPortalUri The location of the development portal
 * @property instructions Onboarding guide.
 */
public data class OnboardingResponse(
    public val developerPortalUri: List<String>? = null,
    public val instructions: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.OnboardingResponse):
            OnboardingResponse = OnboardingResponse(
            developerPortalUri = javaType.developerPortalUri().map({ args0 -> args0 }),
            instructions = javaType.instructions().map({ args0 -> args0 }).orElse(null),
        )
    }
}
