@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiContactInformationResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiLicenseInformationResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiVersionSetContractDetailsResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthenticationSettingsContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.SubscriptionKeyParameterNamesContractResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiContactInformationResponse.Companion.toKotlin as apiContactInformationResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiLicenseInformationResponse.Companion.toKotlin as apiLicenseInformationResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiVersionSetContractDetailsResponse.Companion.toKotlin as apiVersionSetContractDetailsResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthenticationSettingsContractResponse.Companion.toKotlin as authenticationSettingsContractResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.SubscriptionKeyParameterNamesContractResponse.Companion.toKotlin as subscriptionKeyParameterNamesContractResponseToKotlin

/**
 * Builder for [Api].
 */
@PulumiTagMarker
public class ApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiArgs = ApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiArgsBuilder.() -> Unit) {
        val builder = ApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Api {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.Api(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Api(builtJavaResource)
    }
}

/**
 * API details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-06-01-preview, 2020-12-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             OAuth2 = new AzureNative.ApiManagement.Inputs.OAuth2AuthenticationSettingsContractArgs
 *             {
 *                 AuthorizationServerId = "authorizationServerId2283",
 *                 Scope = "oauth2scope2580",
 *             },
 *         },
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Https,
 *             AzureNative.ApiManagement.Protocol.Http,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://newechoapi.cloudapp.net/api",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "header4520",
 *             Query = "query3037",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: &apimanagement.AuthenticationSettingsContractArgs{
 * 				OAuth2: &apimanagement.OAuth2AuthenticationSettingsContractArgs{
 * 					AuthorizationServerId: pulumi.String("authorizationServerId2283"),
 * 					Scope:                 pulumi.String("oauth2scope2580"),
 * 				},
 * 			},
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolHttps),
 * 				pulumi.String(apimanagement.ProtocolHttp),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://newechoapi.cloudapp.net/api"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("header4520"),
 * 				Query:  pulumi.String("query3037"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.OAuth2AuthenticationSettingsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(AuthenticationSettingsContractArgs.builder()
 *                 .oAuth2(OAuth2AuthenticationSettingsContractArgs.builder()
 *                     .authorizationServerId("authorizationServerId2283")
 *                     .scope("oauth2scope2580")
 *                     .build())
 *                 .build())
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "https",
 *                 "http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://newechoapi.cloudapp.net/api")
 *             .subscriptionKeyParameterNames(SubscriptionKeyParameterNamesContractArgs.builder()
 *                 .header("header4520")
 *                 .query("query3037")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiClone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "echo-api2",
 *         Description = "Copy of Existing Echo Api including Operations.",
 *         DisplayName = "Echo API2",
 *         IsCurrent = true,
 *         Path = "echo2",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Http,
 *             AzureNative.ApiManagement.Protocol.Https,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://echoapi.cloudapp.net/api",
 *         SourceApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/58a4aeac497000007d040001",
 *         SubscriptionRequired = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:       pulumi.String("echo-api2"),
 * 			Description: pulumi.String("Copy of Existing Echo Api including Operations."),
 * 			DisplayName: pulumi.String("Echo API2"),
 * 			IsCurrent:   pulumi.Bool(true),
 * 			Path:        pulumi.String("echo2"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolHttp),
 * 				pulumi.String(apimanagement.ProtocolHttps),
 * 			},
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			ServiceName:          pulumi.String("apimService1"),
 * 			ServiceUrl:           pulumi.String("http://echoapi.cloudapp.net/api"),
 * 			SourceApiId:          pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/58a4aeac497000007d040001"),
 * 			SubscriptionRequired: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("echo-api2")
 *             .description("Copy of Existing Echo Api including Operations.")
 *             .displayName("Echo API2")
 *             .isCurrent(true)
 *             .path("echo2")
 *             .protocols(
 *                 "http",
 *                 "https")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://echoapi.cloudapp.net/api")
 *             .sourceApiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/58a4aeac497000007d040001")
 *             .subscriptionRequired(true)
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiNewVersionUsingExistingApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "echoapiv3",
 *         ApiVersion = "v4",
 *         ApiVersionSetId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apiVersionSets/aa9c59e6-c0cd-4258-9356-9ca7d2f0b458",
 *         Description = "Create Echo API into a new Version using Existing Version Set and Copy all Operations.",
 *         DisplayName = "Echo API2",
 *         IsCurrent = true,
 *         Path = "echo2",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Http,
 *             AzureNative.ApiManagement.Protocol.Https,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://echoapi.cloudapp.net/api",
 *         SourceApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echoPath",
 *         SubscriptionRequired = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:           pulumi.String("echoapiv3"),
 * 			ApiVersion:      pulumi.String("v4"),
 * 			ApiVersionSetId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apiVersionSets/aa9c59e6-c0cd-4258-9356-9ca7d2f0b458"),
 * 			Description:     pulumi.String("Create Echo API into a new Version using Existing Version Set and Copy all Operations."),
 * 			DisplayName:     pulumi.String("Echo API2"),
 * 			IsCurrent:       pulumi.Bool(true),
 * 			Path:            pulumi.String("echo2"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolHttp),
 * 				pulumi.String(apimanagement.ProtocolHttps),
 * 			},
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			ServiceName:          pulumi.String("apimService1"),
 * 			ServiceUrl:           pulumi.String("http://echoapi.cloudapp.net/api"),
 * 			SourceApiId:          pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echoPath"),
 * 			SubscriptionRequired: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("echoapiv3")
 *             .apiVersion("v4")
 *             .apiVersionSetId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apiVersionSets/aa9c59e6-c0cd-4258-9356-9ca7d2f0b458")
 *             .description("Create Echo API into a new Version using Existing Version Set and Copy all Operations.")
 *             .displayName("Echo API2")
 *             .isCurrent(true)
 *             .path("echo2")
 *             .protocols(
 *                 "http",
 *                 "https")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://echoapi.cloudapp.net/api")
 *             .sourceApiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echoPath")
 *             .subscriptionRequired(true)
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiRevisionFromExistingApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "echo-api;rev=3",
 *         ApiRevisionDescription = "Creating a Revision of an existing API",
 *         Path = "echo",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://echoapi.cloudapp.net/apiv3",
 *         SourceApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:                  pulumi.String("echo-api;rev=3"),
 * 			ApiRevisionDescription: pulumi.String("Creating a Revision of an existing API"),
 * 			Path:                   pulumi.String("echo"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ServiceName:            pulumi.String("apimService1"),
 * 			ServiceUrl:             pulumi.String("http://echoapi.cloudapp.net/apiv3"),
 * 			SourceApiId:            pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("echo-api;rev=3")
 *             .apiRevisionDescription("Creating a Revision of an existing API")
 *             .path("echo")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://echoapi.cloudapp.net/apiv3")
 *             .sourceApiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingImportOverrideServiceUrl
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "apidocs",
 *         Format = "swagger-link",
 *         Path = "petstoreapi123",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://petstore.swagger.wordnik.com/api",
 *         Value = "http://apimpimportviaurl.azurewebsites.net/api/apidocs/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("apidocs"),
 * 			Format:            pulumi.String("swagger-link"),
 * 			Path:              pulumi.String("petstoreapi123"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://petstore.swagger.wordnik.com/api"),
 * 			Value:             pulumi.String("http://apimpimportviaurl.azurewebsites.net/api/apidocs/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("apidocs")
 *             .format("swagger-link")
 *             .path("petstoreapi123")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://petstore.swagger.wordnik.com/api")
 *             .value("http://apimpimportviaurl.azurewebsites.net/api/apidocs/")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingOai3Import
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "petstore",
 *         Format = AzureNative.ApiManagement.ContentFormat.Openapi_link,
 *         Path = "petstore",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("petstore"),
 * 			Format:            pulumi.String(apimanagement.ContentFormat_Openapi_Link),
 * 			Path:              pulumi.String("petstore"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("petstore")
 *             .format("openapi-link")
 *             .path("petstore")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingOai3ImportWithTranslateRequiredQueryParametersConduct
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "petstore",
 *         Format = AzureNative.ApiManagement.ContentFormat.Openapi_link,
 *         Path = "petstore",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TranslateRequiredQueryParametersConduct = AzureNative.ApiManagement.TranslateRequiredQueryParametersConduct.Template,
 *         Value = "https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:                                   pulumi.String("petstore"),
 * 			Format:                                  pulumi.String(apimanagement.ContentFormat_Openapi_Link),
 * 			Path:                                    pulumi.String("petstore"),
 * 			ResourceGroupName:                       pulumi.String("rg1"),
 * 			ServiceName:                             pulumi.String("apimService1"),
 * 			TranslateRequiredQueryParametersConduct: pulumi.String(apimanagement.TranslateRequiredQueryParametersConductTemplate),
 * 			Value:                                   pulumi.String("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("petstore")
 *             .format("openapi-link")
 *             .path("petstore")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .translateRequiredQueryParametersConduct("template")
 *             .value("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingSwaggerImport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "petstore",
 *         Format = AzureNative.ApiManagement.ContentFormat.Swagger_link_json,
 *         Path = "petstore",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "http://petstore.swagger.io/v2/swagger.json",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("petstore"),
 * 			Format:            pulumi.String(apimanagement.ContentFormat_Swagger_Link_Json),
 * 			Path:              pulumi.String("petstore"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("http://petstore.swagger.io/v2/swagger.json"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("petstore")
 *             .format("swagger-link-json")
 *             .path("petstore")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("http://petstore.swagger.io/v2/swagger.json")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingWadlImport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "petstore",
 *         Format = AzureNative.ApiManagement.ContentFormat.Wadl_link_json,
 *         Path = "collector",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "https://developer.cisco.com/media/wae-release-6-2-api-reference/wae-collector-rest-api/application.wadl",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("petstore"),
 * 			Format:            pulumi.String(apimanagement.ContentFormat_Wadl_Link_Json),
 * 			Path:              pulumi.String("collector"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("https://developer.cisco.com/media/wae-release-6-2-api-reference/wae-collector-rest-api/application.wadl"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("petstore")
 *             .format("wadl-link-json")
 *             .path("collector")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("https://developer.cisco.com/media/wae-release-6-2-api-reference/wae-collector-rest-api/application.wadl")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiWithMultipleAuthServers
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             OAuth2AuthenticationSettings = new[]
 *             {
 *                 new AzureNative.ApiManagement.Inputs.OAuth2AuthenticationSettingsContractArgs
 *                 {
 *                     AuthorizationServerId = "authorizationServerId2283",
 *                     Scope = "oauth2scope2580",
 *                 },
 *                 new AzureNative.ApiManagement.Inputs.OAuth2AuthenticationSettingsContractArgs
 *                 {
 *                     AuthorizationServerId = "authorizationServerId2284",
 *                     Scope = "oauth2scope2581",
 *                 },
 *             },
 *         },
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Https,
 *             AzureNative.ApiManagement.Protocol.Http,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://newechoapi.cloudapp.net/api",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "header4520",
 *             Query = "query3037",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: &apimanagement.AuthenticationSettingsContractArgs{
 * 				OAuth2AuthenticationSettings: apimanagement.OAuth2AuthenticationSettingsContractArray{
 * 					&apimanagement.OAuth2AuthenticationSettingsContractArgs{
 * 						AuthorizationServerId: pulumi.String("authorizationServerId2283"),
 * 						Scope:                 pulumi.String("oauth2scope2580"),
 * 					},
 * 					&apimanagement.OAuth2AuthenticationSettingsContractArgs{
 * 						AuthorizationServerId: pulumi.String("authorizationServerId2284"),
 * 						Scope:                 pulumi.String("oauth2scope2581"),
 * 					},
 * 				},
 * 			},
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolHttps),
 * 				pulumi.String(apimanagement.ProtocolHttp),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://newechoapi.cloudapp.net/api"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("header4520"),
 * 				Query:  pulumi.String("query3037"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(AuthenticationSettingsContractArgs.builder()
 *                 .oAuth2AuthenticationSettings(
 *                     OAuth2AuthenticationSettingsContractArgs.builder()
 *                         .authorizationServerId("authorizationServerId2283")
 *                         .scope("oauth2scope2580")
 *                         .build(),
 *                     OAuth2AuthenticationSettingsContractArgs.builder()
 *                         .authorizationServerId("authorizationServerId2284")
 *                         .scope("oauth2scope2581")
 *                         .build())
 *                 .build())
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "https",
 *                 "http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://newechoapi.cloudapp.net/api")
 *             .subscriptionKeyParameterNames(SubscriptionKeyParameterNamesContractArgs.builder()
 *                 .header("header4520")
 *                 .query("query3037")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiWithMultipleOpenIdConnectProviders
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             OpenidAuthenticationSettings = new[]
 *             {
 *                 new AzureNative.ApiManagement.Inputs.OpenIdAuthenticationSettingsContractArgs
 *                 {
 *                     BearerTokenSendingMethods = new[]
 *                     {
 *                         AzureNative.ApiManagement.BearerTokenSendingMethods.AuthorizationHeader,
 *                     },
 *                     OpenidProviderId = "openidProviderId2283",
 *                 },
 *                 new AzureNative.ApiManagement.Inputs.OpenIdAuthenticationSettingsContractArgs
 *                 {
 *                     BearerTokenSendingMethods = new[]
 *                     {
 *                         AzureNative.ApiManagement.BearerTokenSendingMethods.AuthorizationHeader,
 *                     },
 *                     OpenidProviderId = "openidProviderId2284",
 *                 },
 *             },
 *         },
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Https,
 *             AzureNative.ApiManagement.Protocol.Http,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://newechoapi.cloudapp.net/api",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "header4520",
 *             Query = "query3037",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: &apimanagement.AuthenticationSettingsContractArgs{
 * 				OpenidAuthenticationSettings: apimanagement.OpenIdAuthenticationSettingsContractArray{
 * 					&apimanagement.OpenIdAuthenticationSettingsContractArgs{
 * 						BearerTokenSendingMethods: pulumi.StringArray{
 * 							pulumi.String(apimanagement.BearerTokenSendingMethodsAuthorizationHeader),
 * 						},
 * 						OpenidProviderId: pulumi.String("openidProviderId2283"),
 * 					},
 * 					&apimanagement.OpenIdAuthenticationSettingsContractArgs{
 * 						BearerTokenSendingMethods: pulumi.StringArray{
 * 							pulumi.String(apimanagement.BearerTokenSendingMethodsAuthorizationHeader),
 * 						},
 * 						OpenidProviderId: pulumi.String("openidProviderId2284"),
 * 					},
 * 				},
 * 			},
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolHttps),
 * 				pulumi.String(apimanagement.ProtocolHttp),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://newechoapi.cloudapp.net/api"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("header4520"),
 * 				Query:  pulumi.String("query3037"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(AuthenticationSettingsContractArgs.builder()
 *                 .openidAuthenticationSettings(
 *                     OpenIdAuthenticationSettingsContractArgs.builder()
 *                         .bearerTokenSendingMethods("authorizationHeader")
 *                         .openidProviderId("openidProviderId2283")
 *                         .build(),
 *                     OpenIdAuthenticationSettingsContractArgs.builder()
 *                         .bearerTokenSendingMethods("authorizationHeader")
 *                         .openidProviderId("openidProviderId2284")
 *                         .build())
 *                 .build())
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "https",
 *                 "http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://newechoapi.cloudapp.net/api")
 *             .subscriptionKeyParameterNames(SubscriptionKeyParameterNamesContractArgs.builder()
 *                 .header("header4520")
 *                 .query("query3037")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiWithOpenIdConnect
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             Openid = new AzureNative.ApiManagement.Inputs.OpenIdAuthenticationSettingsContractArgs
 *             {
 *                 BearerTokenSendingMethods = new[]
 *                 {
 *                     AzureNative.ApiManagement.BearerTokenSendingMethods.AuthorizationHeader,
 *                 },
 *                 OpenidProviderId = "testopenid",
 *             },
 *         },
 *         Description = "This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.",
 *         DisplayName = "Swagger Petstore",
 *         Path = "petstore",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Https,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://petstore.swagger.io/v2",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "Ocp-Apim-Subscription-Key",
 *             Query = "subscription-key",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: &apimanagement.AuthenticationSettingsContractArgs{
 * 				Openid: &apimanagement.OpenIdAuthenticationSettingsContractArgs{
 * 					BearerTokenSendingMethods: pulumi.StringArray{
 * 						pulumi.String(apimanagement.BearerTokenSendingMethodsAuthorizationHeader),
 * 					},
 * 					OpenidProviderId: pulumi.String("testopenid"),
 * 				},
 * 			},
 * 			Description: pulumi.String("This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters."),
 * 			DisplayName: pulumi.String("Swagger Petstore"),
 * 			Path:        pulumi.String("petstore"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolHttps),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://petstore.swagger.io/v2"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("Ocp-Apim-Subscription-Key"),
 * 				Query:  pulumi.String("subscription-key"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.OpenIdAuthenticationSettingsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(AuthenticationSettingsContractArgs.builder()
 *                 .openid(OpenIdAuthenticationSettingsContractArgs.builder()
 *                     .bearerTokenSendingMethods("authorizationHeader")
 *                     .openidProviderId("testopenid")
 *                     .build())
 *                 .build())
 *             .description("This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.")
 *             .displayName("Swagger Petstore")
 *             .path("petstore")
 *             .protocols("https")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://petstore.swagger.io/v2")
 *             .subscriptionKeyParameterNames(SubscriptionKeyParameterNamesContractArgs.builder()
 *                 .header("Ocp-Apim-Subscription-Key")
 *                 .query("subscription-key")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateGraphQLApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         ApiType = AzureNative.ApiManagement.ApiType.Graphql,
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "graphql-api",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Http,
 *             AzureNative.ApiManagement.Protocol.Https,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "https://api.spacex.land/graphql",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:       pulumi.String("tempgroup"),
 * 			ApiType:     pulumi.String(apimanagement.ApiTypeGraphql),
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("graphql-api"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolHttp),
 * 				pulumi.String(apimanagement.ProtocolHttps),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("https://api.spacex.land/graphql"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .apiType("graphql")
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("graphql-api")
 *             .protocols(
 *                 "http",
 *                 "https")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("https://api.spacex.land/graphql")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateSoapPassThroughApiUsingWsdlImport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "soapApi",
 *         Format = AzureNative.ApiManagement.ContentFormat.Wsdl_link,
 *         Path = "currency",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         SoapApiType = AzureNative.ApiManagement.SoapApiType.SoapPassThrough,
 *         Value = "http://www.webservicex.net/CurrencyConvertor.asmx?WSDL",
 *         WsdlSelector = new AzureNative.ApiManagement.Inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs
 *         {
 *             WsdlEndpointName = "CurrencyConvertorSoap",
 *             WsdlServiceName = "CurrencyConvertor",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("soapApi"),
 * 			Format:            pulumi.String(apimanagement.ContentFormat_Wsdl_Link),
 * 			Path:              pulumi.String("currency"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			SoapApiType:       pulumi.String(apimanagement.SoapApiTypeSoapPassThrough),
 * 			Value:             pulumi.String("http://www.webservicex.net/CurrencyConvertor.asmx?WSDL"),
 * 			WsdlSelector: &apimanagement.ApiCreateOrUpdatePropertiesWsdlSelectorArgs{
 * 				WsdlEndpointName: pulumi.String("CurrencyConvertorSoap"),
 * 				WsdlServiceName:  pulumi.String("CurrencyConvertor"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("soapApi")
 *             .format("wsdl-link")
 *             .path("currency")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .soapApiType("soap")
 *             .value("http://www.webservicex.net/CurrencyConvertor.asmx?WSDL")
 *             .wsdlSelector(ApiCreateOrUpdatePropertiesWsdlSelectorArgs.builder()
 *                 .wsdlEndpointName("CurrencyConvertorSoap")
 *                 .wsdlServiceName("CurrencyConvertor")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateSoapToRestApiUsingWsdlImport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "soapApi",
 *         Format = AzureNative.ApiManagement.ContentFormat.Wsdl_link,
 *         Path = "currency",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "http://www.webservicex.net/CurrencyConvertor.asmx?WSDL",
 *         WsdlSelector = new AzureNative.ApiManagement.Inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs
 *         {
 *             WsdlEndpointName = "CurrencyConvertorSoap",
 *             WsdlServiceName = "CurrencyConvertor",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("soapApi"),
 * 			Format:            pulumi.String(apimanagement.ContentFormat_Wsdl_Link),
 * 			Path:              pulumi.String("currency"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("http://www.webservicex.net/CurrencyConvertor.asmx?WSDL"),
 * 			WsdlSelector: &apimanagement.ApiCreateOrUpdatePropertiesWsdlSelectorArgs{
 * 				WsdlEndpointName: pulumi.String("CurrencyConvertorSoap"),
 * 				WsdlServiceName:  pulumi.String("CurrencyConvertor"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("soapApi")
 *             .format("wsdl-link")
 *             .path("currency")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("http://www.webservicex.net/CurrencyConvertor.asmx?WSDL")
 *             .wsdlSelector(ApiCreateOrUpdatePropertiesWsdlSelectorArgs.builder()
 *                 .wsdlEndpointName("CurrencyConvertorSoap")
 *                 .wsdlServiceName("CurrencyConvertor")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateWebSocketApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         ApiType = AzureNative.ApiManagement.ApiType.Websocket,
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Wss,
 *             AzureNative.ApiManagement.Protocol.Ws,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "wss://echo.websocket.org",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:       pulumi.String("tempgroup"),
 * 			ApiType:     pulumi.String(apimanagement.ApiTypeWebsocket),
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolWss),
 * 				pulumi.String(apimanagement.ProtocolWs),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("wss://echo.websocket.org"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .apiType("websocket")
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "wss",
 *                 "ws")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("wss://echo.websocket.org")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Api apiid9419 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}
 * ```
 */
public class Api internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.Api,
) : KotlinCustomResource(javaResource, ApiMapper) {
    /**
     * Describes the revision of the API. If no value is provided, default revision 1 is created
     */
    public val apiRevision: Output<String>?
        get() = javaResource.apiRevision().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the API Revision.
     */
    public val apiRevisionDescription: Output<String>?
        get() = javaResource.apiRevisionDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of API.
     */
    public val apiType: Output<String>?
        get() = javaResource.apiType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates the version identifier of the API if the API is versioned
     */
    public val apiVersion: Output<String>?
        get() = javaResource.apiVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the API Version.
     */
    public val apiVersionDescription: Output<String>?
        get() = javaResource.apiVersionDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Version set details
     */
    public val apiVersionSet: Output<ApiVersionSetContractDetailsResponse>?
        get() = javaResource.apiVersionSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiVersionSetContractDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A resource identifier for the related ApiVersionSet.
     */
    public val apiVersionSetId: Output<String>?
        get() = javaResource.apiVersionSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Collection of authentication settings included into this API.
     */
    public val authenticationSettings: Output<AuthenticationSettingsContractResponse>?
        get() = javaResource.authenticationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> authenticationSettingsContractResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Contact information for the API.
     */
    public val contact: Output<ApiContactInformationResponse>?
        get() = javaResource.contact().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    apiContactInformationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Description of the API. May include HTML formatting tags.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * API name. Must be 1 to 300 characters long.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if API revision is current api revision.
     */
    public val isCurrent: Output<Boolean>?
        get() = javaResource.isCurrent().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates if API revision is accessible via the gateway.
     */
    public val isOnline: Output<Boolean>
        get() = javaResource.isOnline().applyValue({ args0 -> args0 })

    /**
     * License information for the API.
     */
    public val license: Output<ApiLicenseInformationResponse>?
        get() = javaResource.license().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    apiLicenseInformationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
     */
    public val path: Output<String>
        get() = javaResource.path().applyValue({ args0 -> args0 })

    /**
     * Describes on which protocols the operations in this API can be invoked.
     */
    public val protocols: Output<List<String>>?
        get() = javaResource.protocols().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
     */
    public val serviceUrl: Output<String>?
        get() = javaResource.serviceUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * API identifier of the source API.
     */
    public val sourceApiId: Output<String>?
        get() = javaResource.sourceApiId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Protocols over which API is made available.
     */
    public val subscriptionKeyParameterNames: Output<SubscriptionKeyParameterNamesContractResponse>?
        get() = javaResource.subscriptionKeyParameterNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subscriptionKeyParameterNamesContractResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies whether an API or Product subscription is required for accessing the API.
     */
    public val subscriptionRequired: Output<Boolean>?
        get() = javaResource.subscriptionRequired().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     *  A URL to the Terms of Service for the API. MUST be in the format of a URL.
     */
    public val termsOfServiceUrl: Output<String>?
        get() = javaResource.termsOfServiceUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApiMapper : ResourceMapper<Api> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.Api::class == javaResource::class

    override fun map(javaResource: Resource): Api = Api(
        javaResource as
            com.pulumi.azurenative.apimanagement.Api,
    )
}

/**
 * @see [Api].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Api].
 */
public suspend fun api(name: String, block: suspend ApiResourceBuilder.() -> Unit): Api {
    val builder = ApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Api].
 * @param name The _unique_ name of the resulting resource.
 */
public fun api(name: String): Api {
    val builder = ApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
