@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiIssueArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.State
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Issue Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiIssue
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiIssue = new AzureNative.ApiManagement.ApiIssue("apiIssue", new()
 *     {
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         CreatedDate = "2018-02-01T22:21:20.467Z",
 *         Description = "New API issue description",
 *         IssueId = "57d2ef278aa04f0ad01d6cdc",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         State = AzureNative.ApiManagement.State.Open,
 *         Title = "New API issue",
 *         UserId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiIssue(ctx, "apiIssue", &apimanagement.ApiIssueArgs{
 * 			ApiId:             pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			CreatedDate:       pulumi.String("2018-02-01T22:21:20.467Z"),
 * 			Description:       pulumi.String("New API issue description"),
 * 			IssueId:           pulumi.String("57d2ef278aa04f0ad01d6cdc"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			State:             pulumi.String(apimanagement.StateOpen),
 * 			Title:             pulumi.String("New API issue"),
 * 			UserId:            pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiIssue;
 * import com.pulumi.azurenative.apimanagement.ApiIssueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiIssue = new ApiIssue("apiIssue", ApiIssueArgs.builder()
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .createdDate("2018-02-01T22:21:20.467Z")
 *             .description("New API issue description")
 *             .issueId("57d2ef278aa04f0ad01d6cdc")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .state("open")
 *             .title("New API issue")
 *             .userId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiIssue 57d2ef278aa04f0ad01d6cdc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}
 * ```
 * @property apiId A resource identifier for the API the issue was created for.
 * @property createdDate Date and time when the issue was created.
 * @property description Text describing the issue.
 * @property issueId Issue identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property state Status of the issue.
 * @property title The issue title.
 * @property userId A resource identifier for the user created the issue.
 */
public data class ApiIssueArgs(
    public val apiId: Output<String>? = null,
    public val createdDate: Output<String>? = null,
    public val description: Output<String>? = null,
    public val issueId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val state: Output<Either<String, State>>? = null,
    public val title: Output<String>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiIssueArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiIssueArgs =
        com.pulumi.azurenative.apimanagement.ApiIssueArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .createdDate(createdDate?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .issueId(issueId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .title(title?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiIssueArgs].
 */
@PulumiTagMarker
public class ApiIssueArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var createdDate: Output<String>? = null

    private var description: Output<String>? = null

    private var issueId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var state: Output<Either<String, State>>? = null

    private var title: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value A resource identifier for the API the issue was created for.
     */
    @JvmName("tapdrugvawntpfnr")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Date and time when the issue was created.
     */
    @JvmName("qoqbxthlclcuwylw")
    public suspend fun createdDate(`value`: Output<String>) {
        this.createdDate = value
    }

    /**
     * @param value Text describing the issue.
     */
    @JvmName("awrndhdrlholhlar")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("yenoqhqsgflamcia")
    public suspend fun issueId(`value`: Output<String>) {
        this.issueId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("faqpewnbddyabxuu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("pdyrtfxnswmsubrk")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Status of the issue.
     */
    @JvmName("cmvhwmlslorrcwlx")
    public suspend fun state(`value`: Output<Either<String, State>>) {
        this.state = value
    }

    /**
     * @param value The issue title.
     */
    @JvmName("yaiewjnsmoingxtc")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value A resource identifier for the user created the issue.
     */
    @JvmName("akogabxuvecrbbtq")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value A resource identifier for the API the issue was created for.
     */
    @JvmName("ncilknvlfyclkofi")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Date and time when the issue was created.
     */
    @JvmName("vqswgkpwayuterfy")
    public suspend fun createdDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdDate = mapped
    }

    /**
     * @param value Text describing the issue.
     */
    @JvmName("jkxydldsxyjqdmax")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("psyqwffnmmjqhpqf")
    public suspend fun issueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qrsgcltslmnlvqnr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("estwjfsicxhhraen")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Status of the issue.
     */
    @JvmName("gkxeewjtjmkwpqtf")
    public suspend fun state(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Status of the issue.
     */
    @JvmName("ijtgkuhgupnbmoyq")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Status of the issue.
     */
    @JvmName("dcyxtprmrrdoivbm")
    public fun state(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The issue title.
     */
    @JvmName("fimvsxywqbrfkohl")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value A resource identifier for the user created the issue.
     */
    @JvmName("ytlylohjlyhavrgw")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): ApiIssueArgs = ApiIssueArgs(
        apiId = apiId,
        createdDate = createdDate,
        description = description,
        issueId = issueId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        state = state,
        title = title,
        userId = userId,
    )
}
