@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiIssueComment].
 */
@PulumiTagMarker
public class ApiIssueCommentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiIssueCommentArgs = ApiIssueCommentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiIssueCommentArgsBuilder.() -> Unit) {
        val builder = ApiIssueCommentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApiIssueComment {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ApiIssueComment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApiIssueComment(builtJavaResource)
    }
}

/**
 * Issue Comment Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiIssueComment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiIssueComment = new AzureNative.ApiManagement.ApiIssueComment("apiIssueComment", new()
 *     {
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         CommentId = "599e29ab193c3c0bd0b3e2fb",
 *         CreatedDate = "2018-02-01T22:21:20.467Z",
 *         IssueId = "57d2ef278aa04f0ad01d6cdc",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Text = "Issue comment.",
 *         UserId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiIssueComment(ctx, "apiIssueComment", &apimanagement.ApiIssueCommentArgs{
 * 			ApiId:             pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			CommentId:         pulumi.String("599e29ab193c3c0bd0b3e2fb"),
 * 			CreatedDate:       pulumi.String("2018-02-01T22:21:20.467Z"),
 * 			IssueId:           pulumi.String("57d2ef278aa04f0ad01d6cdc"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Text:              pulumi.String("Issue comment."),
 * 			UserId:            pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiIssueComment;
 * import com.pulumi.azurenative.apimanagement.ApiIssueCommentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiIssueComment = new ApiIssueComment("apiIssueComment", ApiIssueCommentArgs.builder()
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .commentId("599e29ab193c3c0bd0b3e2fb")
 *             .createdDate("2018-02-01T22:21:20.467Z")
 *             .issueId("57d2ef278aa04f0ad01d6cdc")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .text("Issue comment.")
 *             .userId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiIssueComment 599e29ab193c3c0bd0b3e2fb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/comments/{commentId}
 * ```
 */
public class ApiIssueComment internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiIssueComment,
) : KotlinCustomResource(javaResource, ApiIssueCommentMapper) {
    /**
     * Date and time when the comment was created.
     */
    public val createdDate: Output<String>?
        get() = javaResource.createdDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Comment text.
     */
    public val text: Output<String>
        get() = javaResource.text().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A resource identifier for the user who left the comment.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object ApiIssueCommentMapper : ResourceMapper<ApiIssueComment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiIssueComment::class == javaResource::class

    override fun map(javaResource: Resource): ApiIssueComment = ApiIssueComment(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiIssueComment,
    )
}

/**
 * @see [ApiIssueComment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiIssueComment].
 */
public suspend fun apiIssueComment(
    name: String,
    block: suspend ApiIssueCommentResourceBuilder.() -> Unit,
): ApiIssueComment {
    val builder = ApiIssueCommentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiIssueComment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiIssueComment(name: String): ApiIssueComment {
    val builder = ApiIssueCommentResourceBuilder()
    builder.name(name)
    return builder.build()
}
