@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.NatGatewayState
import com.pulumi.azurenative.apimanagement.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.apimanagement.kotlin.enums.VirtualNetworkType
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AdditionalLocationArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AdditionalLocationArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiManagementServiceIdentityArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiManagementServiceIdentityArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiManagementServiceSkuPropertiesArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiManagementServiceSkuPropertiesArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiVersionConstraintArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiVersionConstraintArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.CertificateConfigurationArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.CertificateConfigurationArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.HostnameConfigurationArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.HostnameConfigurationArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.RemotePrivateEndpointConnectionWrapperArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.RemotePrivateEndpointConnectionWrapperArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.VirtualNetworkConfigurationArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.VirtualNetworkConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A single API Management service resource in List or Get response.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateMultiRegionServiceWithCustomHostname
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         AdditionalLocations = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.AdditionalLocationArgs
 *             {
 *                 DisableGateway = true,
 *                 Location = "East US",
 *                 Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *                 {
 *                     Capacity = 1,
 *                     Name = AzureNative.ApiManagement.SkuType.Premium,
 *                 },
 *             },
 *         },
 *         ApiVersionConstraint = new AzureNative.ApiManagement.Inputs.ApiVersionConstraintArgs
 *         {
 *             MinApiVersion = "2019-01-01",
 *         },
 *         HostnameConfigurations = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 CertificatePassword = "Password",
 *                 DefaultSslBinding = true,
 *                 EncodedCertificate = "****** Base 64 Encoded Certificate ************",
 *                 HostName = "gateway1.msitesting.net",
 *                 Type = AzureNative.ApiManagement.HostnameType.Proxy,
 *             },
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 CertificatePassword = "Password",
 *                 EncodedCertificate = "****** Base 64 Encoded Certificate ************",
 *                 HostName = "mgmt.msitesting.net",
 *                 Type = AzureNative.ApiManagement.HostnameType.Management,
 *             },
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 CertificatePassword = "Password",
 *                 EncodedCertificate = "****** Base 64 Encoded Certificate ************",
 *                 HostName = "portal1.msitesting.net",
 *                 Type = AzureNative.ApiManagement.HostnameType.Portal,
 *             },
 *         },
 *         Location = "West US",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.ApiManagement.SkuType.Premium,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *         VirtualNetworkType = AzureNative.ApiManagement.VirtualNetworkType.None,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			AdditionalLocations: apimanagement.AdditionalLocationArray{
 * 				&apimanagement.AdditionalLocationArgs{
 * 					DisableGateway: pulumi.Bool(true),
 * 					Location:       pulumi.String("East US"),
 * 					Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 						Capacity: pulumi.Int(1),
 * 						Name:     pulumi.String(apimanagement.SkuTypePremium),
 * 					},
 * 				},
 * 			},
 * 			ApiVersionConstraint: &apimanagement.ApiVersionConstraintArgs{
 * 				MinApiVersion: pulumi.String("2019-01-01"),
 * 			},
 * 			HostnameConfigurations: apimanagement.HostnameConfigurationArray{
 * 				&apimanagement.HostnameConfigurationArgs{
 * 					CertificatePassword: pulumi.String("Password"),
 * 					DefaultSslBinding:   pulumi.Bool(true),
 * 					EncodedCertificate:  pulumi.String("****** Base 64 Encoded Certificate ************"),
 * 					HostName:            pulumi.String("gateway1.msitesting.net"),
 * 					Type:                pulumi.String(apimanagement.HostnameTypeProxy),
 * 				},
 * 				&apimanagement.HostnameConfigurationArgs{
 * 					CertificatePassword: pulumi.String("Password"),
 * 					EncodedCertificate:  pulumi.String("****** Base 64 Encoded Certificate ************"),
 * 					HostName:            pulumi.String("mgmt.msitesting.net"),
 * 					Type:                pulumi.String(apimanagement.HostnameTypeManagement),
 * 				},
 * 				&apimanagement.HostnameConfigurationArgs{
 * 					CertificatePassword: pulumi.String("Password"),
 * 					EncodedCertificate:  pulumi.String("****** Base 64 Encoded Certificate ************"),
 * 					HostName:            pulumi.String("portal1.msitesting.net"),
 * 					Type:                pulumi.String(apimanagement.HostnameTypePortal),
 * 				},
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String(apimanagement.SkuTypePremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 			VirtualNetworkType: pulumi.String(apimanagement.VirtualNetworkTypeNone),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.AdditionalLocationArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiVersionConstraintArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.HostnameConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .additionalLocations(AdditionalLocationArgs.builder()
 *                 .disableGateway(true)
 *                 .location("East US")
 *                 .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                     .capacity(1)
 *                     .name("Premium")
 *                     .build())
 *                 .build())
 *             .apiVersionConstraint(ApiVersionConstraintArgs.builder()
 *                 .minApiVersion("2019-01-01")
 *                 .build())
 *             .hostnameConfigurations(
 *                 HostnameConfigurationArgs.builder()
 *                     .certificatePassword("Password")
 *                     .defaultSslBinding(true)
 *                     .encodedCertificate("****** Base 64 Encoded Certificate ************")
 *                     .hostName("gateway1.msitesting.net")
 *                     .type("Proxy")
 *                     .build(),
 *                 HostnameConfigurationArgs.builder()
 *                     .certificatePassword("Password")
 *                     .encodedCertificate("****** Base 64 Encoded Certificate ************")
 *                     .hostName("mgmt.msitesting.net")
 *                     .type("Management")
 *                     .build(),
 *                 HostnameConfigurationArgs.builder()
 *                     .certificatePassword("Password")
 *                     .encodedCertificate("****** Base 64 Encoded Certificate ************")
 *                     .hostName("portal1.msitesting.net")
 *                     .type("Portal")
 *                     .build())
 *             .location("West US")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(1)
 *                 .name("Premium")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .virtualNetworkType("None")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "South Central US",
 *         PublisherEmail = "foo@contoso.com",
 *         PublisherName = "foo",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.ApiManagement.SkuType.Developer,
 *         },
 *         Tags =
 *         {
 *             { "Name", "Contoso" },
 *             { "Test", "User" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			PublisherEmail:    pulumi.String("foo@contoso.com"),
 * 			PublisherName:     pulumi.String("foo"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String(apimanagement.SkuTypeDeveloper),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Contoso"),
 * 				"Test": pulumi.String("User"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("South Central US")
 *             .publisherEmail("foo@contoso.com")
 *             .publisherName("foo")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(1)
 *                 .name("Developer")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "Contoso"),
 *                 Map.entry("Test", "User")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceHavingMsi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Identity = new AzureNative.ApiManagement.Inputs.ApiManagementServiceIdentityArgs
 *         {
 *             Type = AzureNative.ApiManagement.ApimIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 0,
 *             Name = AzureNative.ApiManagement.SkuType.Consumption,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Identity: &apimanagement.ApiManagementServiceIdentityArgs{
 * 				Type: pulumi.String(apimanagement.ApimIdentityTypeSystemAssigned),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(0),
 * 				Name:     pulumi.String(apimanagement.SkuTypeConsumption),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceIdentityArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .identity(ApiManagementServiceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(0)
 *                 .name("Consumption")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceInVnetWithPublicIP
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "East US 2 EUAP",
 *         PublicIpAddressId = "/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/publicIPAddresses/apimazvnet",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 2,
 *             Name = AzureNative.ApiManagement.SkuType.Premium,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *         VirtualNetworkConfiguration = new AzureNative.ApiManagement.Inputs.VirtualNetworkConfigurationArgs
 *         {
 *             SubnetResourceId = "/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/virtualNetworks/apimcus/subnets/tenant",
 *         },
 *         VirtualNetworkType = AzureNative.ApiManagement.VirtualNetworkType.External,
 *         Zones = new[]
 *         {
 *             "1",
 *             "2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("East US 2 EUAP"),
 * 			PublicIpAddressId: pulumi.String("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/publicIPAddresses/apimazvnet"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String(apimanagement.SkuTypePremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 			VirtualNetworkConfiguration: &apimanagement.VirtualNetworkConfigurationArgs{
 * 				SubnetResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/virtualNetworks/apimcus/subnets/tenant"),
 * 			},
 * 			VirtualNetworkType: pulumi.String(apimanagement.VirtualNetworkTypeExternal),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.VirtualNetworkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("East US 2 EUAP")
 *             .publicIpAddressId("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/publicIPAddresses/apimazvnet")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(2)
 *                 .name("Premium")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .virtualNetworkConfiguration(VirtualNetworkConfigurationArgs.builder()
 *                 .subnetResourceId("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/virtualNetworks/apimcus/subnets/tenant")
 *                 .build())
 *             .virtualNetworkType("External")
 *             .zones(
 *                 "1",
 *                 "2")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceInZones
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "North europe",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 2,
 *             Name = AzureNative.ApiManagement.SkuType.Premium,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *             "2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("North europe"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String(apimanagement.SkuTypePremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("North europe")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(2)
 *                 .name("Premium")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .zones(
 *                 "1",
 *                 "2")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceWithCustomHostnameKeyVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         ApiVersionConstraint = new AzureNative.ApiManagement.Inputs.ApiVersionConstraintArgs
 *         {
 *             MinApiVersion = "2019-01-01",
 *         },
 *         HostnameConfigurations = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 DefaultSslBinding = true,
 *                 HostName = "gateway1.msitesting.net",
 *                 IdentityClientId = "329419bc-adec-4dce-9568-25a6d486e468",
 *                 KeyVaultId = "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert",
 *                 Type = AzureNative.ApiManagement.HostnameType.Proxy,
 *             },
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 HostName = "mgmt.msitesting.net",
 *                 IdentityClientId = "329419bc-adec-4dce-9568-25a6d486e468",
 *                 KeyVaultId = "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert",
 *                 Type = AzureNative.ApiManagement.HostnameType.Management,
 *             },
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 HostName = "portal1.msitesting.net",
 *                 IdentityClientId = "329419bc-adec-4dce-9568-25a6d486e468",
 *                 KeyVaultId = "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert",
 *                 Type = AzureNative.ApiManagement.HostnameType.Portal,
 *             },
 *         },
 *         Identity = new AzureNative.ApiManagement.Inputs.ApiManagementServiceIdentityArgs
 *         {
 *             Type = AzureNative.ApiManagement.ApimIdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1", null },
 *             },
 *         },
 *         Location = "North Europe",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.ApiManagement.SkuType.Premium,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *         VirtualNetworkType = AzureNative.ApiManagement.VirtualNetworkType.None,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			ApiVersionConstraint: &apimanagement.ApiVersionConstraintArgs{
 * 				MinApiVersion: pulumi.String("2019-01-01"),
 * 			},
 * 			HostnameConfigurations: apimanagement.HostnameConfigurationArray{
 * 				&apimanagement.HostnameConfigurationArgs{
 * 					DefaultSslBinding: pulumi.Bool(true),
 * 					HostName:          pulumi.String("gateway1.msitesting.net"),
 * 					IdentityClientId:  pulumi.String("329419bc-adec-4dce-9568-25a6d486e468"),
 * 					KeyVaultId:        pulumi.String("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 * 					Type:              pulumi.String(apimanagement.HostnameTypeProxy),
 * 				},
 * 				&apimanagement.HostnameConfigurationArgs{
 * 					HostName:         pulumi.String("mgmt.msitesting.net"),
 * 					IdentityClientId: pulumi.String("329419bc-adec-4dce-9568-25a6d486e468"),
 * 					KeyVaultId:       pulumi.String("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 * 					Type:             pulumi.String(apimanagement.HostnameTypeManagement),
 * 				},
 * 				&apimanagement.HostnameConfigurationArgs{
 * 					HostName:         pulumi.String("portal1.msitesting.net"),
 * 					IdentityClientId: pulumi.String("329419bc-adec-4dce-9568-25a6d486e468"),
 * 					KeyVaultId:       pulumi.String("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 * 					Type:             pulumi.String(apimanagement.HostnameTypePortal),
 * 				},
 * 			},
 * 			Identity: &apimanagement.ApiManagementServiceIdentityArgs{
 * 				Type: pulumi.String(apimanagement.ApimIdentityTypeUserAssigned),
 * 				UserAssignedIdentities: apimanagement.UserIdentityPropertiesMap{
 * 					"/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": nil,
 * 				},
 * 			},
 * 			Location:          pulumi.String("North Europe"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String(apimanagement.SkuTypePremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 			VirtualNetworkType: pulumi.String(apimanagement.VirtualNetworkTypeNone),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiVersionConstraintArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.HostnameConfigurationArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceIdentityArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .apiVersionConstraint(ApiVersionConstraintArgs.builder()
 *                 .minApiVersion("2019-01-01")
 *                 .build())
 *             .hostnameConfigurations(
 *                 HostnameConfigurationArgs.builder()
 *                     .defaultSslBinding(true)
 *                     .hostName("gateway1.msitesting.net")
 *                     .identityClientId("329419bc-adec-4dce-9568-25a6d486e468")
 *                     .keyVaultId("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert")
 *                     .type("Proxy")
 *                     .build(),
 *                 HostnameConfigurationArgs.builder()
 *                     .hostName("mgmt.msitesting.net")
 *                     .identityClientId("329419bc-adec-4dce-9568-25a6d486e468")
 *                     .keyVaultId("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert")
 *                     .type("Management")
 *                     .build(),
 *                 HostnameConfigurationArgs.builder()
 *                     .hostName("portal1.msitesting.net")
 *                     .identityClientId("329419bc-adec-4dce-9568-25a6d486e468")
 *                     .keyVaultId("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert")
 *                     .type("Portal")
 *                     .build())
 *             .identity(ApiManagementServiceIdentityArgs.builder()
 *                 .type("UserAssigned")
 *                 .userAssignedIdentities(Map.of("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1", ))
 *                 .build())
 *             .location("North Europe")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(1)
 *                 .name("Premium")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .virtualNetworkType("None")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceWithNatGatewayEnabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "East US",
 *         NatGatewayState = AzureNative.ApiManagement.NatGatewayState.Enabled,
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.ApiManagement.SkuType.Premium,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("East US"),
 * 			NatGatewayState:   pulumi.String(apimanagement.NatGatewayStateEnabled),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String(apimanagement.SkuTypePremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("East US")
 *             .natGatewayState("Enabled")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(1)
 *                 .name("Premium")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceWithSystemCertificates
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Certificates = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.CertificateConfigurationArgs
 *             {
 *                 CertificatePassword = "Password",
 *                 EncodedCertificate = "*******Base64 encoded Certificate******************",
 *                 StoreName = "CertificateAuthority",
 *             },
 *         },
 *         Location = "Central US",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.ApiManagement.SkuType.Basic,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Certificates: apimanagement.CertificateConfigurationArray{
 * 				&apimanagement.CertificateConfigurationArgs{
 * 					CertificatePassword: pulumi.String("Password"),
 * 					EncodedCertificate:  pulumi.String("*******Base64 encoded Certificate******************"),
 * 					StoreName:           pulumi.String("CertificateAuthority"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("Central US"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String(apimanagement.SkuTypeBasic),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.CertificateConfigurationArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .certificates(CertificateConfigurationArgs.builder()
 *                 .certificatePassword("Password")
 *                 .encodedCertificate("*******Base64 encoded Certificate******************")
 *                 .storeName("CertificateAuthority")
 *                 .build())
 *             .location("Central US")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(1)
 *                 .name("Basic")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceWithUserAssignedIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Identity = new AzureNative.ApiManagement.Inputs.ApiManagementServiceIdentityArgs
 *         {
 *             Type = AzureNative.ApiManagement.ApimIdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1", null },
 *             },
 *         },
 *         Location = "West US",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 0,
 *             Name = AzureNative.ApiManagement.SkuType.Consumption,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Identity: &apimanagement.ApiManagementServiceIdentityArgs{
 * 				Type: pulumi.String(apimanagement.ApimIdentityTypeUserAssigned),
 * 				UserAssignedIdentities: apimanagement.UserIdentityPropertiesMap{
 * 					"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1": nil,
 * 				},
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(0),
 * 				Name:     pulumi.String(apimanagement.SkuTypeConsumption),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceIdentityArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .identity(ApiManagementServiceIdentityArgs.builder()
 *                 .type("UserAssigned")
 *                 .userAssignedIdentities(Map.of("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1", ))
 *                 .build())
 *             .location("West US")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(0)
 *                 .name("Consumption")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementUndelete
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "South Central US",
 *         PublisherEmail = "foo@contoso.com",
 *         PublisherName = "foo",
 *         ResourceGroupName = "rg1",
 *         Restore = true,
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.ApiManagement.SkuType.Developer,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			PublisherEmail:    pulumi.String("foo@contoso.com"),
 * 			PublisherName:     pulumi.String("foo"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Restore:           pulumi.Bool(true),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String(apimanagement.SkuTypeDeveloper),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("South Central US")
 *             .publisherEmail("foo@contoso.com")
 *             .publisherName("foo")
 *             .resourceGroupName("rg1")
 *             .restore(true)
 *             .serviceName("apimService1")
 *             .sku(ApiManagementServiceSkuPropertiesArgs.builder()
 *                 .capacity(1)
 *                 .name("Developer")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiManagementService apimService1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}
 * ```
 * @property additionalLocations Additional datacenter locations of the API Management service.
 * @property apiVersionConstraint Control Plane Apis version constraint for the API Management service.
 * @property certificates List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
 * @property customProperties Custom properties of the API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS 1.1 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For all the settings except Http2 the default value is `True` if the service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is `False`.</br></br>You can disable any of the following ciphers by using settings `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`: TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example, `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The default value is `true` for them.</br> Note: The following ciphers can't be disabled since they are required by internal platform components: TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
 * @property disableGateway Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in master region.
 * @property enableClientCertificate Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each request to the gateway. This also enables the ability to authenticate the certificate in the policy on the gateway.
 * @property hostnameConfigurations Custom hostname configuration of the API Management service.
 * @property identity Managed service identity of the Api Management service.
 * @property location Resource location.
 * @property natGatewayState Property can be used to enable NAT Gateway for this API Management service.
 * @property notificationSenderEmail Email address from which the notification will be sent.
 * @property privateEndpointConnections List of Private Endpoint Connections of this service.
 * @property publicIpAddressId Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual Network.
 * @property publicNetworkAccess Whether or not public endpoint access is allowed for this API Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'
 * @property publisherEmail Publisher email.
 * @property publisherName Publisher name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property restore Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other properties will be ignored.
 * @property serviceName The name of the API Management service.
 * @property sku SKU properties of the API Management service.
 * @property tags Resource tags.
 * @property virtualNetworkConfiguration Virtual network configuration of the API Management service.
 * @property virtualNetworkType The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
 * @property zones A list of availability zones denoting where the resource needs to come from.
 */
public data class ApiManagementServiceArgs(
    public val additionalLocations: Output<List<AdditionalLocationArgs>>? = null,
    public val apiVersionConstraint: Output<ApiVersionConstraintArgs>? = null,
    public val certificates: Output<List<CertificateConfigurationArgs>>? = null,
    public val customProperties: Output<Map<String, String>>? = null,
    public val disableGateway: Output<Boolean>? = null,
    public val enableClientCertificate: Output<Boolean>? = null,
    public val hostnameConfigurations: Output<List<HostnameConfigurationArgs>>? = null,
    public val identity: Output<ApiManagementServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val natGatewayState: Output<Either<String, NatGatewayState>>? = null,
    public val notificationSenderEmail: Output<String>? = null,
    public val privateEndpointConnections: Output<List<RemotePrivateEndpointConnectionWrapperArgs>>? =
        null,
    public val publicIpAddressId: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val publisherEmail: Output<String>? = null,
    public val publisherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restore: Output<Boolean>? = null,
    public val serviceName: Output<String>? = null,
    public val sku: Output<ApiManagementServiceSkuPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNetworkConfiguration: Output<VirtualNetworkConfigurationArgs>? = null,
    public val virtualNetworkType: Output<Either<String, VirtualNetworkType>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs =
        com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs.builder()
            .additionalLocations(
                additionalLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .apiVersionConstraint(
                apiVersionConstraint?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .certificates(
                certificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .customProperties(
                customProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .disableGateway(disableGateway?.applyValue({ args0 -> args0 }))
            .enableClientCertificate(enableClientCertificate?.applyValue({ args0 -> args0 }))
            .hostnameConfigurations(
                hostnameConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .natGatewayState(
                natGatewayState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .notificationSenderEmail(notificationSenderEmail?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicIpAddressId(publicIpAddressId?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publisherEmail(publisherEmail?.applyValue({ args0 -> args0 }))
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restore(restore?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNetworkConfiguration(
                virtualNetworkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualNetworkType(
                virtualNetworkType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApiManagementServiceArgs].
 */
@PulumiTagMarker
public class ApiManagementServiceArgsBuilder internal constructor() {
    private var additionalLocations: Output<List<AdditionalLocationArgs>>? = null

    private var apiVersionConstraint: Output<ApiVersionConstraintArgs>? = null

    private var certificates: Output<List<CertificateConfigurationArgs>>? = null

    private var customProperties: Output<Map<String, String>>? = null

    private var disableGateway: Output<Boolean>? = null

    private var enableClientCertificate: Output<Boolean>? = null

    private var hostnameConfigurations: Output<List<HostnameConfigurationArgs>>? = null

    private var identity: Output<ApiManagementServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var natGatewayState: Output<Either<String, NatGatewayState>>? = null

    private var notificationSenderEmail: Output<String>? = null

    private var privateEndpointConnections: Output<List<RemotePrivateEndpointConnectionWrapperArgs>>? =
        null

    private var publicIpAddressId: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var publisherEmail: Output<String>? = null

    private var publisherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var restore: Output<Boolean>? = null

    private var serviceName: Output<String>? = null

    private var sku: Output<ApiManagementServiceSkuPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNetworkConfiguration: Output<VirtualNetworkConfigurationArgs>? = null

    private var virtualNetworkType: Output<Either<String, VirtualNetworkType>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Additional datacenter locations of the API Management service.
     */
    @JvmName("tmnvhkjyfvkoqhpj")
    public suspend fun additionalLocations(`value`: Output<List<AdditionalLocationArgs>>) {
        this.additionalLocations = value
    }

    @JvmName("ciqmrysofqejwmpf")
    public suspend fun additionalLocations(vararg values: Output<AdditionalLocationArgs>) {
        this.additionalLocations = Output.all(values.asList())
    }

    /**
     * @param values Additional datacenter locations of the API Management service.
     */
    @JvmName("ldhifmucjqlebloy")
    public suspend fun additionalLocations(values: List<Output<AdditionalLocationArgs>>) {
        this.additionalLocations = Output.all(values)
    }

    /**
     * @param value Control Plane Apis version constraint for the API Management service.
     */
    @JvmName("spebkkyyipckjsta")
    public suspend fun apiVersionConstraint(`value`: Output<ApiVersionConstraintArgs>) {
        this.apiVersionConstraint = value
    }

    /**
     * @param value List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
     */
    @JvmName("cjdimqmjpqcaktwg")
    public suspend fun certificates(`value`: Output<List<CertificateConfigurationArgs>>) {
        this.certificates = value
    }

    @JvmName("vlltgbeilrqhugky")
    public suspend fun certificates(vararg values: Output<CertificateConfigurationArgs>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
     */
    @JvmName("hiwumegeiikgbqgl")
    public suspend fun certificates(values: List<Output<CertificateConfigurationArgs>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value Custom properties of the API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS 1.1 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For all the settings except Http2 the default value is `True` if the service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is `False`.</br></br>You can disable any of the following ciphers by using settings `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`: TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example, `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The default value is `true` for them.</br> Note: The following ciphers can't be disabled since they are required by internal platform components: TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
     */
    @JvmName("tjvdhypxrpnnalyq")
    public suspend fun customProperties(`value`: Output<Map<String, String>>) {
        this.customProperties = value
    }

    /**
     * @param value Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in master region.
     */
    @JvmName("yuyggmuwkmqphcdd")
    public suspend fun disableGateway(`value`: Output<Boolean>) {
        this.disableGateway = value
    }

    /**
     * @param value Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each request to the gateway. This also enables the ability to authenticate the certificate in the policy on the gateway.
     */
    @JvmName("hfqdtngevghmhicc")
    public suspend fun enableClientCertificate(`value`: Output<Boolean>) {
        this.enableClientCertificate = value
    }

    /**
     * @param value Custom hostname configuration of the API Management service.
     */
    @JvmName("tvgmnujhxdompbcj")
    public suspend fun hostnameConfigurations(`value`: Output<List<HostnameConfigurationArgs>>) {
        this.hostnameConfigurations = value
    }

    @JvmName("odbgepnwerouwitb")
    public suspend fun hostnameConfigurations(vararg values: Output<HostnameConfigurationArgs>) {
        this.hostnameConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Custom hostname configuration of the API Management service.
     */
    @JvmName("oufspucaxtxbvhqx")
    public suspend fun hostnameConfigurations(values: List<Output<HostnameConfigurationArgs>>) {
        this.hostnameConfigurations = Output.all(values)
    }

    /**
     * @param value Managed service identity of the Api Management service.
     */
    @JvmName("ufuofucrumiefynd")
    public suspend fun identity(`value`: Output<ApiManagementServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("byupswrgxljvwdcm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Property can be used to enable NAT Gateway for this API Management service.
     */
    @JvmName("chgejpkemewnunki")
    public suspend fun natGatewayState(`value`: Output<Either<String, NatGatewayState>>) {
        this.natGatewayState = value
    }

    /**
     * @param value Email address from which the notification will be sent.
     */
    @JvmName("rsaxybajrkcvaicx")
    public suspend fun notificationSenderEmail(`value`: Output<String>) {
        this.notificationSenderEmail = value
    }

    /**
     * @param value List of Private Endpoint Connections of this service.
     */
    @JvmName("ytbqichjxbjdlxpo")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<RemotePrivateEndpointConnectionWrapperArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("ogohagtqtnifgtkh")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<RemotePrivateEndpointConnectionWrapperArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values List of Private Endpoint Connections of this service.
     */
    @JvmName("ebxsrmgwywatuwqc")
    public suspend
    fun privateEndpointConnections(values: List<Output<RemotePrivateEndpointConnectionWrapperArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual Network.
     */
    @JvmName("rxxtemrdcpjaotpu")
    public suspend fun publicIpAddressId(`value`: Output<String>) {
        this.publicIpAddressId = value
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this API Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'
     */
    @JvmName("ylunpeqdtkolevhs")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Publisher email.
     */
    @JvmName("fqjnsrnpiuhqjymj")
    public suspend fun publisherEmail(`value`: Output<String>) {
        this.publisherEmail = value
    }

    /**
     * @param value Publisher name.
     */
    @JvmName("kfntisxinquhugmr")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xulotoxrjijbbcrc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other properties will be ignored.
     */
    @JvmName("gxiyukoobctveiab")
    public suspend fun restore(`value`: Output<Boolean>) {
        this.restore = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("tmsdfjjjhgfcqlsi")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value SKU properties of the API Management service.
     */
    @JvmName("tcnbmwbpkldutalh")
    public suspend fun sku(`value`: Output<ApiManagementServiceSkuPropertiesArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qsqjeroymvhichav")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Virtual network configuration of the API Management service.
     */
    @JvmName("vgbcgqngvviexevl")
    public suspend fun virtualNetworkConfiguration(`value`: Output<VirtualNetworkConfigurationArgs>) {
        this.virtualNetworkConfiguration = value
    }

    /**
     * @param value The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     */
    @JvmName("dafrlduaejvhjcpd")
    public suspend fun virtualNetworkType(`value`: Output<Either<String, VirtualNetworkType>>) {
        this.virtualNetworkType = value
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("nhjmhagwnkqcyquj")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("ngdaujugkrbuippa")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("fucqomcfxhnjtefu")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Additional datacenter locations of the API Management service.
     */
    @JvmName("wjrtuinpdngwljnc")
    public suspend fun additionalLocations(`value`: List<AdditionalLocationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalLocations = mapped
    }

    /**
     * @param argument Additional datacenter locations of the API Management service.
     */
    @JvmName("wlcioumwqodmfifg")
    public suspend
    fun additionalLocations(argument: List<suspend AdditionalLocationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AdditionalLocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalLocations = mapped
    }

    /**
     * @param argument Additional datacenter locations of the API Management service.
     */
    @JvmName("yfywphkfrpixrkmn")
    public suspend fun additionalLocations(
        vararg
        argument: suspend AdditionalLocationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AdditionalLocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalLocations = mapped
    }

    /**
     * @param argument Additional datacenter locations of the API Management service.
     */
    @JvmName("dtrnfrwytvmkhfik")
    public suspend
    fun additionalLocations(argument: suspend AdditionalLocationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AdditionalLocationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.additionalLocations = mapped
    }

    /**
     * @param values Additional datacenter locations of the API Management service.
     */
    @JvmName("buevqsdjghtbgecf")
    public suspend fun additionalLocations(vararg values: AdditionalLocationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalLocations = mapped
    }

    /**
     * @param value Control Plane Apis version constraint for the API Management service.
     */
    @JvmName("igqsokenvylhcahp")
    public suspend fun apiVersionConstraint(`value`: ApiVersionConstraintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersionConstraint = mapped
    }

    /**
     * @param argument Control Plane Apis version constraint for the API Management service.
     */
    @JvmName("fopqociiourokict")
    public suspend
    fun apiVersionConstraint(argument: suspend ApiVersionConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = ApiVersionConstraintArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiVersionConstraint = mapped
    }

    /**
     * @param value List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
     */
    @JvmName("rubnuwifitvfbghd")
    public suspend fun certificates(`value`: List<CertificateConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param argument List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
     */
    @JvmName("prknmgonasikcdfn")
    public suspend
    fun certificates(argument: List<suspend CertificateConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CertificateConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
     */
    @JvmName("htgxlafdxwtslcsa")
    public suspend fun certificates(
        vararg
        argument: suspend CertificateConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CertificateConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
     */
    @JvmName("nhnxmwvcighcvpcf")
    public suspend
    fun certificates(argument: suspend CertificateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CertificateConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param values List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
     */
    @JvmName("cxosafihxnaylujq")
    public suspend fun certificates(vararg values: CertificateConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value Custom properties of the API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS 1.1 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For all the settings except Http2 the default value is `True` if the service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is `False`.</br></br>You can disable any of the following ciphers by using settings `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`: TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example, `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The default value is `true` for them.</br> Note: The following ciphers can't be disabled since they are required by internal platform components: TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
     */
    @JvmName("ycyxrcbjylewxrmi")
    public suspend fun customProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param values Custom properties of the API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS 1.1 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For all the settings except Http2 the default value is `True` if the service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is `False`.</br></br>You can disable any of the following ciphers by using settings `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`: TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example, `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The default value is `true` for them.</br> Note: The following ciphers can't be disabled since they are required by internal platform components: TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
     */
    @JvmName("sewrtmexxvkidwar")
    public fun customProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in master region.
     */
    @JvmName("aoslhggdkywegnpf")
    public suspend fun disableGateway(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableGateway = mapped
    }

    /**
     * @param value Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each request to the gateway. This also enables the ability to authenticate the certificate in the policy on the gateway.
     */
    @JvmName("ninxipydbjabbqfl")
    public suspend fun enableClientCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableClientCertificate = mapped
    }

    /**
     * @param value Custom hostname configuration of the API Management service.
     */
    @JvmName("ptogubhjasspianp")
    public suspend fun hostnameConfigurations(`value`: List<HostnameConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostnameConfigurations = mapped
    }

    /**
     * @param argument Custom hostname configuration of the API Management service.
     */
    @JvmName("nvxqjtbtsinwnjqs")
    public suspend
    fun hostnameConfigurations(argument: List<suspend HostnameConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HostnameConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hostnameConfigurations = mapped
    }

    /**
     * @param argument Custom hostname configuration of the API Management service.
     */
    @JvmName("expslwjsunjvyrpe")
    public suspend fun hostnameConfigurations(
        vararg
        argument: suspend HostnameConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HostnameConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hostnameConfigurations = mapped
    }

    /**
     * @param argument Custom hostname configuration of the API Management service.
     */
    @JvmName("csugbhikemkwrakm")
    public suspend
    fun hostnameConfigurations(argument: suspend HostnameConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HostnameConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.hostnameConfigurations = mapped
    }

    /**
     * @param values Custom hostname configuration of the API Management service.
     */
    @JvmName("nekupeujdfwnipmf")
    public suspend fun hostnameConfigurations(vararg values: HostnameConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostnameConfigurations = mapped
    }

    /**
     * @param value Managed service identity of the Api Management service.
     */
    @JvmName("dqxevomrknyxydge")
    public suspend fun identity(`value`: ApiManagementServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity of the Api Management service.
     */
    @JvmName("wpnnqxcqqhejdnys")
    public suspend
    fun identity(argument: suspend ApiManagementServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ApiManagementServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qfgfkahsqhnpvrbx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Property can be used to enable NAT Gateway for this API Management service.
     */
    @JvmName("cebgqlehcbarytvs")
    public suspend fun natGatewayState(`value`: Either<String, NatGatewayState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayState = mapped
    }

    /**
     * @param value Property can be used to enable NAT Gateway for this API Management service.
     */
    @JvmName("ptgcjdaxsvqrfejj")
    public fun natGatewayState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NatGatewayState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.natGatewayState = mapped
    }

    /**
     * @param value Property can be used to enable NAT Gateway for this API Management service.
     */
    @JvmName("bydjejoatswiooxc")
    public fun natGatewayState(`value`: NatGatewayState) {
        val toBeMapped = Either.ofRight<String, NatGatewayState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.natGatewayState = mapped
    }

    /**
     * @param value Email address from which the notification will be sent.
     */
    @JvmName("exwqpmbxkqvlxwls")
    public suspend fun notificationSenderEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationSenderEmail = mapped
    }

    /**
     * @param value List of Private Endpoint Connections of this service.
     */
    @JvmName("ccqoouybolpjdkgx")
    public suspend
    fun privateEndpointConnections(`value`: List<RemotePrivateEndpointConnectionWrapperArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of Private Endpoint Connections of this service.
     */
    @JvmName("byfqgnmtedkagsxy")
    public suspend
    fun privateEndpointConnections(argument: List<suspend RemotePrivateEndpointConnectionWrapperArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RemotePrivateEndpointConnectionWrapperArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of Private Endpoint Connections of this service.
     */
    @JvmName("ccpxrigjlcsfntcc")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend RemotePrivateEndpointConnectionWrapperArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RemotePrivateEndpointConnectionWrapperArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of Private Endpoint Connections of this service.
     */
    @JvmName("uvesiymxauryxfsj")
    public suspend
    fun privateEndpointConnections(argument: suspend RemotePrivateEndpointConnectionWrapperArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RemotePrivateEndpointConnectionWrapperArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values List of Private Endpoint Connections of this service.
     */
    @JvmName("ythcjoxfxehsnsim")
    public suspend fun privateEndpointConnections(
        vararg
        values: RemotePrivateEndpointConnectionWrapperArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual Network.
     */
    @JvmName("jwttobgjsdnmnqmr")
    public suspend fun publicIpAddressId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressId = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this API Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'
     */
    @JvmName("rpcgjckmrbjvjswc")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this API Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'
     */
    @JvmName("hjokmnpjwpjshmvg")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this API Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'
     */
    @JvmName("egyucvjbvogytebl")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Publisher email.
     */
    @JvmName("kyakoxqndnemduiw")
    public suspend fun publisherEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherEmail = mapped
    }

    /**
     * @param value Publisher name.
     */
    @JvmName("doeoiwvdycmvkyyh")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("djiycknracdjefok")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other properties will be ignored.
     */
    @JvmName("hksagshmkssqihdr")
    public suspend fun restore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restore = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jpiynmctjumdbuir")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value SKU properties of the API Management service.
     */
    @JvmName("dqlobcjcjrlcflft")
    public suspend fun sku(`value`: ApiManagementServiceSkuPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU properties of the API Management service.
     */
    @JvmName("vdcdatesnyuiutnr")
    public suspend
    fun sku(argument: suspend ApiManagementServiceSkuPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApiManagementServiceSkuPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("acbtpyastxmcfgmm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nhtvkjsujfhkasyt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Virtual network configuration of the API Management service.
     */
    @JvmName("jcetyojjltfmseyb")
    public suspend fun virtualNetworkConfiguration(`value`: VirtualNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkConfiguration = mapped
    }

    /**
     * @param argument Virtual network configuration of the API Management service.
     */
    @JvmName("coufyjwckwovjxao")
    public suspend
    fun virtualNetworkConfiguration(argument: suspend VirtualNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkConfiguration = mapped
    }

    /**
     * @param value The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     */
    @JvmName("yutpecdrohmqpdml")
    public suspend fun virtualNetworkType(`value`: Either<String, VirtualNetworkType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkType = mapped
    }

    /**
     * @param value The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     */
    @JvmName("camxleukhwuhrdjr")
    public fun virtualNetworkType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkType = mapped
    }

    /**
     * @param value The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     */
    @JvmName("eeyofarvxcminxei")
    public fun virtualNetworkType(`value`: VirtualNetworkType) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkType = mapped
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("cmyrctpgxvnafunq")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("ysakbohwlagqcedg")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): ApiManagementServiceArgs = ApiManagementServiceArgs(
        additionalLocations = additionalLocations,
        apiVersionConstraint = apiVersionConstraint,
        certificates = certificates,
        customProperties = customProperties,
        disableGateway = disableGateway,
        enableClientCertificate = enableClientCertificate,
        hostnameConfigurations = hostnameConfigurations,
        identity = identity,
        location = location,
        natGatewayState = natGatewayState,
        notificationSenderEmail = notificationSenderEmail,
        privateEndpointConnections = privateEndpointConnections,
        publicIpAddressId = publicIpAddressId,
        publicNetworkAccess = publicNetworkAccess,
        publisherEmail = publisherEmail,
        publisherName = publisherName,
        resourceGroupName = resourceGroupName,
        restore = restore,
        serviceName = serviceName,
        sku = sku,
        tags = tags,
        virtualNetworkConfiguration = virtualNetworkConfiguration,
        virtualNetworkType = virtualNetworkType,
        zones = zones,
    )
}
