@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiRelease].
 */
@PulumiTagMarker
public class ApiReleaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiReleaseArgs = ApiReleaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiReleaseArgsBuilder.() -> Unit) {
        val builder = ApiReleaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApiRelease {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.ApiRelease(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiRelease(builtJavaResource)
    }
}

/**
 * ApiRelease details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiRelease
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiRelease = new AzureNative.ApiManagement.ApiRelease("apiRelease", new()
 *     {
 *         ApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/a1",
 *         Notes = "yahooagain",
 *         ReleaseId = "testrev",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiRelease(ctx, "apiRelease", &apimanagement.ApiReleaseArgs{
 * 			ApiId:             pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/a1"),
 * 			Notes:             pulumi.String("yahooagain"),
 * 			ReleaseId:         pulumi.String("testrev"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiRelease;
 * import com.pulumi.azurenative.apimanagement.ApiReleaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiRelease = new ApiRelease("apiRelease", ApiReleaseArgs.builder()
 *             .apiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/a1")
 *             .notes("yahooagain")
 *             .releaseId("testrev")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiRelease testrev /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases/{releaseId}
 * ```
 */
public class ApiRelease internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiRelease,
) : KotlinCustomResource(javaResource, ApiReleaseMapper) {
    /**
     * Identifier of the API the release belongs to.
     */
    public val apiId: Output<String>?
        get() = javaResource.apiId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time the API was released. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     */
    public val createdDateTime: Output<String>
        get() = javaResource.createdDateTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Release Notes
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The time the API release was updated.
     */
    public val updatedDateTime: Output<String>
        get() = javaResource.updatedDateTime().applyValue({ args0 -> args0 })
}

public object ApiReleaseMapper : ResourceMapper<ApiRelease> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiRelease::class == javaResource::class

    override fun map(javaResource: Resource): ApiRelease = ApiRelease(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiRelease,
    )
}

/**
 * @see [ApiRelease].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiRelease].
 */
public suspend fun apiRelease(name: String, block: suspend ApiReleaseResourceBuilder.() -> Unit):
    ApiRelease {
    val builder = ApiReleaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiRelease].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiRelease(name: String): ApiRelease {
    val builder = ApiReleaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
