@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiDiagnosticPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiIssueAttachmentPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiIssueCommentPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiIssuePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiManagementServiceDomainOwnershipIdentifierPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiManagementServicePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiManagementServiceSsoTokenPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiOperationPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiOperationPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiReleasePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiSchemaPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiTagDescriptionPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiVersionSetPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getApiWikiPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getAuthorizationAccessPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getAuthorizationLoginLinkPostPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getAuthorizationPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getAuthorizationProviderPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getAuthorizationServerPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getBackendPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getCachePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getCertificatePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getContentItemPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getContentTypePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getDiagnosticPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getDocumentationPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getEmailTemplatePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getGatewayCertificateAuthorityPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getGatewayHostnameConfigurationPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getGatewayPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getGlobalSchemaPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getGraphQLApiResolverPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getGraphQLApiResolverPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getGroupPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getIdentityProviderPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getLoggerPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getNamedValuePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getOpenIdConnectProviderPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getPolicyFragmentPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getPolicyRestrictionPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getPrivateEndpointConnectionByNamePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getProductApiLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getProductGroupLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getProductPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getProductPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getProductWikiPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getSchemaPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getSubscriptionPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getTagApiLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getTagByApiPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getTagByOperationPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getTagByProductPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getTagOperationLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getTagPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getTagProductLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getUserPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getUserSharedAccessTokenPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceApiOperationPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceApiOperationPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceApiPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceApiPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceApiReleasePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceApiSchemaPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceApiVersionSetPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceGlobalSchemaPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceGroupPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceNamedValuePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspacePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspacePolicyFragmentPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspacePolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceProductApiLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceProductGroupLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceProductPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceProductPolicyPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceSubscriptionPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceTagApiLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceTagOperationLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceTagPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.getWorkspaceTagProductLinkPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listAuthorizationServerSecretsPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listDelegationSettingSecretsPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listGatewayDebugCredentialsPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listGatewayKeysPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listIdentityProviderSecretsPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listNamedValuePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listOpenIdConnectProviderSecretsPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listPolicyFragmentReferencesPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listSubscriptionSecretsPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listTenantAccessSecretsPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listWorkspaceNamedValuePlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listWorkspacePolicyFragmentReferencesPlain
import com.pulumi.azurenative.apimanagement.ApimanagementFunctions.listWorkspaceSubscriptionSecretsPlain
import com.pulumi.azurenative.apimanagement.kotlin.enums.GatewayListDebugCredentialsContractPurpose
import com.pulumi.azurenative.apimanagement.kotlin.enums.KeyType
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiDiagnosticPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiDiagnosticPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiIssueAttachmentPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiIssueAttachmentPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiIssueCommentPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiIssueCommentPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiIssuePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiIssuePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiManagementServicePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiManagementServicePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiManagementServiceSsoTokenPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiManagementServiceSsoTokenPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiOperationPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiOperationPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiOperationPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiOperationPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiReleasePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiReleasePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiSchemaPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiSchemaPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiTagDescriptionPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiTagDescriptionPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiVersionSetPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiVersionSetPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiWikiPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetApiWikiPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationAccessPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationAccessPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationLoginLinkPostPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationLoginLinkPostPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationProviderPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationProviderPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationServerPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetAuthorizationServerPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetBackendPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetBackendPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetCachePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetCachePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetContentItemPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetContentItemPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetContentTypePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetContentTypePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetDiagnosticPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetDiagnosticPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetDocumentationPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetDocumentationPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetEmailTemplatePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetEmailTemplatePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGatewayCertificateAuthorityPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGatewayCertificateAuthorityPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGatewayHostnameConfigurationPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGatewayHostnameConfigurationPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGatewayPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGatewayPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGlobalSchemaPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGlobalSchemaPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGraphQLApiResolverPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGraphQLApiResolverPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGraphQLApiResolverPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGraphQLApiResolverPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGroupPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetGroupPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetIdentityProviderPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetIdentityProviderPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetLoggerPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetLoggerPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetNamedValuePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetNamedValuePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetOpenIdConnectProviderPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetOpenIdConnectProviderPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetPolicyFragmentPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetPolicyFragmentPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetPolicyRestrictionPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetPolicyRestrictionPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetPrivateEndpointConnectionByNamePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetPrivateEndpointConnectionByNamePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductApiLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductApiLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductGroupLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductGroupLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductWikiPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetProductWikiPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetSchemaPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetSchemaPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetSubscriptionPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagApiLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagApiLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagByApiPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagByApiPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagByOperationPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagByOperationPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagByProductPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagByProductPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagOperationLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagOperationLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagProductLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetTagProductLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetUserPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetUserSharedAccessTokenPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetUserSharedAccessTokenPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiOperationPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiOperationPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiOperationPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiOperationPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiReleasePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiReleasePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiSchemaPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiSchemaPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiVersionSetPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceApiVersionSetPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceGlobalSchemaPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceGlobalSchemaPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceGroupPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceGroupPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceNamedValuePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceNamedValuePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspacePolicyFragmentPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspacePolicyFragmentPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspacePolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspacePolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceProductApiLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceProductApiLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceProductGroupLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceProductGroupLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceProductPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceProductPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceProductPolicyPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceProductPolicyPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceSubscriptionPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceTagApiLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceTagApiLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceTagOperationLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceTagOperationLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceTagPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceTagPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceTagProductLinkPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.GetWorkspaceTagProductLinkPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListAuthorizationServerSecretsPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListAuthorizationServerSecretsPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListDelegationSettingSecretsPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListDelegationSettingSecretsPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListGatewayDebugCredentialsPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListGatewayDebugCredentialsPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListGatewayKeysPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListGatewayKeysPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListIdentityProviderSecretsPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListIdentityProviderSecretsPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListNamedValuePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListNamedValuePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListOpenIdConnectProviderSecretsPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListOpenIdConnectProviderSecretsPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListPolicyFragmentReferencesPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListPolicyFragmentReferencesPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListSubscriptionSecretsPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListSubscriptionSecretsPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListTenantAccessSecretsPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListTenantAccessSecretsPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListWorkspaceNamedValuePlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListWorkspaceNamedValuePlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListWorkspacePolicyFragmentReferencesPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListWorkspacePolicyFragmentReferencesPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListWorkspaceSubscriptionSecretsPlainArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ListWorkspaceSubscriptionSecretsPlainArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiDiagnosticResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiIssueAttachmentResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiIssueCommentResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiIssueResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiManagementServiceDomainOwnershipIdentifierResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiManagementServiceResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiManagementServiceSsoTokenResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiOperationPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiOperationResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiReleaseResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiSchemaResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiTagDescriptionResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiVersionSetResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiWikiResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationAccessPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationLoginLinkPostResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationProviderResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationServerResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetBackendResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetCacheResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetCertificateResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetContentItemResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetContentTypeResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetDiagnosticResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetDocumentationResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetEmailTemplateResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGatewayCertificateAuthorityResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGatewayHostnameConfigurationResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGatewayResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGlobalSchemaResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGraphQLApiResolverPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGraphQLApiResolverResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGroupResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetIdentityProviderResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetLoggerResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetNamedValueResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetOpenIdConnectProviderResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetPolicyFragmentResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetPolicyRestrictionResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetPrivateEndpointConnectionByNameResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductApiLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductGroupLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductWikiResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetSchemaResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetSubscriptionResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagApiLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagByApiResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagByOperationResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagByProductResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagOperationLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagProductLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetUserResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetUserSharedAccessTokenResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiOperationPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiOperationResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiReleaseResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiSchemaResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiVersionSetResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceGlobalSchemaResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceGroupResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceNamedValueResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspacePolicyFragmentResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspacePolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceProductApiLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceProductGroupLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceProductPolicyResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceProductResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceSubscriptionResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceTagApiLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceTagOperationLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceTagProductLinkResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceTagResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListAuthorizationServerSecretsResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListDelegationSettingSecretsResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListGatewayDebugCredentialsResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListGatewayKeysResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListIdentityProviderSecretsResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListNamedValueResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListOpenIdConnectProviderSecretsResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListPolicyFragmentReferencesResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListSubscriptionSecretsResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListTenantAccessSecretsResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListWorkspaceNamedValueResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListWorkspacePolicyFragmentReferencesResult
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListWorkspaceSubscriptionSecretsResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiDiagnosticResult.Companion.toKotlin as getApiDiagnosticResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiIssueAttachmentResult.Companion.toKotlin as getApiIssueAttachmentResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiIssueCommentResult.Companion.toKotlin as getApiIssueCommentResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiIssueResult.Companion.toKotlin as getApiIssueResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiManagementServiceDomainOwnershipIdentifierResult.Companion.toKotlin as getApiManagementServiceDomainOwnershipIdentifierResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiManagementServiceResult.Companion.toKotlin as getApiManagementServiceResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiManagementServiceSsoTokenResult.Companion.toKotlin as getApiManagementServiceSsoTokenResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiOperationPolicyResult.Companion.toKotlin as getApiOperationPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiOperationResult.Companion.toKotlin as getApiOperationResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiPolicyResult.Companion.toKotlin as getApiPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiReleaseResult.Companion.toKotlin as getApiReleaseResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiResult.Companion.toKotlin as getApiResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiSchemaResult.Companion.toKotlin as getApiSchemaResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiTagDescriptionResult.Companion.toKotlin as getApiTagDescriptionResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiVersionSetResult.Companion.toKotlin as getApiVersionSetResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetApiWikiResult.Companion.toKotlin as getApiWikiResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationAccessPolicyResult.Companion.toKotlin as getAuthorizationAccessPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationLoginLinkPostResult.Companion.toKotlin as getAuthorizationLoginLinkPostResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationProviderResult.Companion.toKotlin as getAuthorizationProviderResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationResult.Companion.toKotlin as getAuthorizationResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetAuthorizationServerResult.Companion.toKotlin as getAuthorizationServerResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetBackendResult.Companion.toKotlin as getBackendResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetCacheResult.Companion.toKotlin as getCacheResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetContentItemResult.Companion.toKotlin as getContentItemResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetContentTypeResult.Companion.toKotlin as getContentTypeResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetDiagnosticResult.Companion.toKotlin as getDiagnosticResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetDocumentationResult.Companion.toKotlin as getDocumentationResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetEmailTemplateResult.Companion.toKotlin as getEmailTemplateResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGatewayCertificateAuthorityResult.Companion.toKotlin as getGatewayCertificateAuthorityResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGatewayHostnameConfigurationResult.Companion.toKotlin as getGatewayHostnameConfigurationResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGatewayResult.Companion.toKotlin as getGatewayResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGlobalSchemaResult.Companion.toKotlin as getGlobalSchemaResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGraphQLApiResolverPolicyResult.Companion.toKotlin as getGraphQLApiResolverPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGraphQLApiResolverResult.Companion.toKotlin as getGraphQLApiResolverResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetGroupResult.Companion.toKotlin as getGroupResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetIdentityProviderResult.Companion.toKotlin as getIdentityProviderResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetLoggerResult.Companion.toKotlin as getLoggerResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetNamedValueResult.Companion.toKotlin as getNamedValueResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetOpenIdConnectProviderResult.Companion.toKotlin as getOpenIdConnectProviderResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetPolicyFragmentResult.Companion.toKotlin as getPolicyFragmentResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetPolicyRestrictionResult.Companion.toKotlin as getPolicyRestrictionResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetPolicyResult.Companion.toKotlin as getPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetPrivateEndpointConnectionByNameResult.Companion.toKotlin as getPrivateEndpointConnectionByNameResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductApiLinkResult.Companion.toKotlin as getProductApiLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductGroupLinkResult.Companion.toKotlin as getProductGroupLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductPolicyResult.Companion.toKotlin as getProductPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductResult.Companion.toKotlin as getProductResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetProductWikiResult.Companion.toKotlin as getProductWikiResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetSchemaResult.Companion.toKotlin as getSchemaResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetSubscriptionResult.Companion.toKotlin as getSubscriptionResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagApiLinkResult.Companion.toKotlin as getTagApiLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagByApiResult.Companion.toKotlin as getTagByApiResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagByOperationResult.Companion.toKotlin as getTagByOperationResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagByProductResult.Companion.toKotlin as getTagByProductResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagOperationLinkResult.Companion.toKotlin as getTagOperationLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagProductLinkResult.Companion.toKotlin as getTagProductLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetTagResult.Companion.toKotlin as getTagResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetUserSharedAccessTokenResult.Companion.toKotlin as getUserSharedAccessTokenResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiOperationPolicyResult.Companion.toKotlin as getWorkspaceApiOperationPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiOperationResult.Companion.toKotlin as getWorkspaceApiOperationResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiPolicyResult.Companion.toKotlin as getWorkspaceApiPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiReleaseResult.Companion.toKotlin as getWorkspaceApiReleaseResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiResult.Companion.toKotlin as getWorkspaceApiResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiSchemaResult.Companion.toKotlin as getWorkspaceApiSchemaResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceApiVersionSetResult.Companion.toKotlin as getWorkspaceApiVersionSetResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceGlobalSchemaResult.Companion.toKotlin as getWorkspaceGlobalSchemaResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceGroupResult.Companion.toKotlin as getWorkspaceGroupResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceNamedValueResult.Companion.toKotlin as getWorkspaceNamedValueResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspacePolicyFragmentResult.Companion.toKotlin as getWorkspacePolicyFragmentResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspacePolicyResult.Companion.toKotlin as getWorkspacePolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceProductApiLinkResult.Companion.toKotlin as getWorkspaceProductApiLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceProductGroupLinkResult.Companion.toKotlin as getWorkspaceProductGroupLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceProductPolicyResult.Companion.toKotlin as getWorkspaceProductPolicyResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceProductResult.Companion.toKotlin as getWorkspaceProductResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceSubscriptionResult.Companion.toKotlin as getWorkspaceSubscriptionResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceTagApiLinkResult.Companion.toKotlin as getWorkspaceTagApiLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceTagOperationLinkResult.Companion.toKotlin as getWorkspaceTagOperationLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceTagProductLinkResult.Companion.toKotlin as getWorkspaceTagProductLinkResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GetWorkspaceTagResult.Companion.toKotlin as getWorkspaceTagResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListAuthorizationServerSecretsResult.Companion.toKotlin as listAuthorizationServerSecretsResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListDelegationSettingSecretsResult.Companion.toKotlin as listDelegationSettingSecretsResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListGatewayDebugCredentialsResult.Companion.toKotlin as listGatewayDebugCredentialsResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListGatewayKeysResult.Companion.toKotlin as listGatewayKeysResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListIdentityProviderSecretsResult.Companion.toKotlin as listIdentityProviderSecretsResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListNamedValueResult.Companion.toKotlin as listNamedValueResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListOpenIdConnectProviderSecretsResult.Companion.toKotlin as listOpenIdConnectProviderSecretsResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListPolicyFragmentReferencesResult.Companion.toKotlin as listPolicyFragmentReferencesResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListSubscriptionSecretsResult.Companion.toKotlin as listSubscriptionSecretsResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListTenantAccessSecretsResult.Companion.toKotlin as listTenantAccessSecretsResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListWorkspaceNamedValueResult.Companion.toKotlin as listWorkspaceNamedValueResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListWorkspacePolicyFragmentReferencesResult.Companion.toKotlin as listWorkspacePolicyFragmentReferencesResultToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ListWorkspaceSubscriptionSecretsResult.Companion.toKotlin as listWorkspaceSubscriptionSecretsResultToKotlin

public object ApimanagementFunctions {
    /**
     * Gets the details of the API specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-06-01-preview, 2020-12-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return API details.
     */
    public suspend fun getApi(argument: GetApiPlainArgs): GetApiResult =
        getApiResultToKotlin(getApiPlain(argument.toJava()).await())

    /**
     * @see [getApi].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return API details.
     */
    public suspend fun getApi(
        apiId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiResult {
        val argument = GetApiPlainArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiResultToKotlin(getApiPlain(argument.toJava()).await())
    }

    /**
     * @see [getApi].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiPlainArgs].
     * @return API details.
     */
    public suspend fun getApi(argument: suspend GetApiPlainArgsBuilder.() -> Unit): GetApiResult {
        val builder = GetApiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiResultToKotlin(getApiPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Diagnostic for an API specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2018-01-01, 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Diagnostic details.
     */
    public suspend fun getApiDiagnostic(argument: GetApiDiagnosticPlainArgs): GetApiDiagnosticResult =
        getApiDiagnosticResultToKotlin(getApiDiagnosticPlain(argument.toJava()).await())

    /**
     * @see [getApiDiagnostic].
     * @param apiId API identifier. Must be unique in the current API Management service instance.
     * @param diagnosticId Diagnostic identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Diagnostic details.
     */
    public suspend fun getApiDiagnostic(
        apiId: String,
        diagnosticId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiDiagnosticResult {
        val argument = GetApiDiagnosticPlainArgs(
            apiId = apiId,
            diagnosticId = diagnosticId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiDiagnosticResultToKotlin(getApiDiagnosticPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiDiagnostic].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiDiagnosticPlainArgs].
     * @return Diagnostic details.
     */
    public suspend
    fun getApiDiagnostic(argument: suspend GetApiDiagnosticPlainArgsBuilder.() -> Unit):
        GetApiDiagnosticResult {
        val builder = GetApiDiagnosticPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiDiagnosticResultToKotlin(getApiDiagnosticPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Issue for an API specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Issue Contract details.
     */
    public suspend fun getApiIssue(argument: GetApiIssuePlainArgs): GetApiIssueResult =
        getApiIssueResultToKotlin(getApiIssuePlain(argument.toJava()).await())

    /**
     * @see [getApiIssue].
     * @param apiId API identifier. Must be unique in the current API Management service instance.
     * @param expandCommentsAttachments Expand the comment attachments.
     * @param issueId Issue identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Issue Contract details.
     */
    public suspend fun getApiIssue(
        apiId: String,
        expandCommentsAttachments: Boolean? = null,
        issueId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiIssueResult {
        val argument = GetApiIssuePlainArgs(
            apiId = apiId,
            expandCommentsAttachments = expandCommentsAttachments,
            issueId = issueId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiIssueResultToKotlin(getApiIssuePlain(argument.toJava()).await())
    }

    /**
     * @see [getApiIssue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiIssuePlainArgs].
     * @return Issue Contract details.
     */
    public suspend fun getApiIssue(argument: suspend GetApiIssuePlainArgsBuilder.() -> Unit):
        GetApiIssueResult {
        val builder = GetApiIssuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiIssueResultToKotlin(getApiIssuePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the issue Attachment for an API specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Issue Attachment Contract details.
     */
    public suspend fun getApiIssueAttachment(argument: GetApiIssueAttachmentPlainArgs):
        GetApiIssueAttachmentResult =
        getApiIssueAttachmentResultToKotlin(getApiIssueAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getApiIssueAttachment].
     * @param apiId API identifier. Must be unique in the current API Management service instance.
     * @param attachmentId Attachment identifier within an Issue. Must be unique in the current Issue.
     * @param issueId Issue identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Issue Attachment Contract details.
     */
    public suspend fun getApiIssueAttachment(
        apiId: String,
        attachmentId: String,
        issueId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiIssueAttachmentResult {
        val argument = GetApiIssueAttachmentPlainArgs(
            apiId = apiId,
            attachmentId = attachmentId,
            issueId = issueId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiIssueAttachmentResultToKotlin(getApiIssueAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiIssueAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiIssueAttachmentPlainArgs].
     * @return Issue Attachment Contract details.
     */
    public suspend
    fun getApiIssueAttachment(argument: suspend GetApiIssueAttachmentPlainArgsBuilder.() -> Unit):
        GetApiIssueAttachmentResult {
        val builder = GetApiIssueAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiIssueAttachmentResultToKotlin(getApiIssueAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the issue Comment for an API specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Issue Comment Contract details.
     */
    public suspend fun getApiIssueComment(argument: GetApiIssueCommentPlainArgs):
        GetApiIssueCommentResult =
        getApiIssueCommentResultToKotlin(getApiIssueCommentPlain(argument.toJava()).await())

    /**
     * @see [getApiIssueComment].
     * @param apiId API identifier. Must be unique in the current API Management service instance.
     * @param commentId Comment identifier within an Issue. Must be unique in the current Issue.
     * @param issueId Issue identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Issue Comment Contract details.
     */
    public suspend fun getApiIssueComment(
        apiId: String,
        commentId: String,
        issueId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiIssueCommentResult {
        val argument = GetApiIssueCommentPlainArgs(
            apiId = apiId,
            commentId = commentId,
            issueId = issueId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiIssueCommentResultToKotlin(getApiIssueCommentPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiIssueComment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiIssueCommentPlainArgs].
     * @return Issue Comment Contract details.
     */
    public suspend
    fun getApiIssueComment(argument: suspend GetApiIssueCommentPlainArgsBuilder.() -> Unit):
        GetApiIssueCommentResult {
        val builder = GetApiIssueCommentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiIssueCommentResultToKotlin(getApiIssueCommentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an API Management service resource description.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A single API Management service resource in List or Get response.
     */
    public suspend fun getApiManagementService(argument: GetApiManagementServicePlainArgs):
        GetApiManagementServiceResult =
        getApiManagementServiceResultToKotlin(getApiManagementServicePlain(argument.toJava()).await())

    /**
     * @see [getApiManagementService].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return A single API Management service resource in List or Get response.
     */
    public suspend fun getApiManagementService(resourceGroupName: String, serviceName: String):
        GetApiManagementServiceResult {
        val argument = GetApiManagementServicePlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiManagementServiceResultToKotlin(getApiManagementServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getApiManagementService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiManagementServicePlainArgs].
     * @return A single API Management service resource in List or Get response.
     */
    public suspend
    fun getApiManagementService(argument: suspend GetApiManagementServicePlainArgsBuilder.() -> Unit):
        GetApiManagementServiceResult {
        val builder = GetApiManagementServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiManagementServiceResultToKotlin(getApiManagementServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the custom domain ownership identifier for an API Management service.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2020-06-01-preview, 2020-12-01, 2021-01-01-preview, 2021-04-01-preview, 2021-08-01, 2021-12-01-preview, 2022-04-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Response of the GetDomainOwnershipIdentifier operation.
     */
    public suspend fun getApiManagementServiceDomainOwnershipIdentifier():
        GetApiManagementServiceDomainOwnershipIdentifierResult =
        getApiManagementServiceDomainOwnershipIdentifierResultToKotlin(getApiManagementServiceDomainOwnershipIdentifierPlain().await())

    /**
     * Gets the Single-Sign-On token for the API Management Service which is valid for 5 Minutes.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-10-10, 2017-03-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return The response of the GetSsoToken operation.
     */
    public suspend
    fun getApiManagementServiceSsoToken(argument: GetApiManagementServiceSsoTokenPlainArgs):
        GetApiManagementServiceSsoTokenResult =
        getApiManagementServiceSsoTokenResultToKotlin(getApiManagementServiceSsoTokenPlain(argument.toJava()).await())

    /**
     * @see [getApiManagementServiceSsoToken].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return The response of the GetSsoToken operation.
     */
    public suspend fun getApiManagementServiceSsoToken(
        resourceGroupName: String,
        serviceName: String,
    ): GetApiManagementServiceSsoTokenResult {
        val argument = GetApiManagementServiceSsoTokenPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiManagementServiceSsoTokenResultToKotlin(getApiManagementServiceSsoTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiManagementServiceSsoToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiManagementServiceSsoTokenPlainArgs].
     * @return The response of the GetSsoToken operation.
     */
    public suspend
    fun getApiManagementServiceSsoToken(argument: suspend GetApiManagementServiceSsoTokenPlainArgsBuilder.() -> Unit):
        GetApiManagementServiceSsoTokenResult {
        val builder = GetApiManagementServiceSsoTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiManagementServiceSsoTokenResultToKotlin(getApiManagementServiceSsoTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the API Operation specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return API Operation details.
     */
    public suspend fun getApiOperation(argument: GetApiOperationPlainArgs): GetApiOperationResult =
        getApiOperationResultToKotlin(getApiOperationPlain(argument.toJava()).await())

    /**
     * @see [getApiOperation].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param operationId Operation identifier within an API. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return API Operation details.
     */
    public suspend fun getApiOperation(
        apiId: String,
        operationId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiOperationResult {
        val argument = GetApiOperationPlainArgs(
            apiId = apiId,
            operationId = operationId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiOperationResultToKotlin(getApiOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiOperationPlainArgs].
     * @return API Operation details.
     */
    public suspend fun getApiOperation(argument: suspend GetApiOperationPlainArgsBuilder.() -> Unit):
        GetApiOperationResult {
        val builder = GetApiOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiOperationResultToKotlin(getApiOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy configuration at the API Operation level.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2018-06-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend fun getApiOperationPolicy(argument: GetApiOperationPolicyPlainArgs):
        GetApiOperationPolicyResult =
        getApiOperationPolicyResultToKotlin(getApiOperationPolicyPlain(argument.toJava()).await())

    /**
     * @see [getApiOperationPolicy].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param format Policy Export Format.
     * @param operationId Operation identifier within an API. Must be unique in the current API Management service instance.
     * @param policyId The identifier of the Policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Policy Contract details.
     */
    public suspend fun getApiOperationPolicy(
        apiId: String,
        format: String? = null,
        operationId: String,
        policyId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiOperationPolicyResult {
        val argument = GetApiOperationPolicyPlainArgs(
            apiId = apiId,
            format = format,
            operationId = operationId,
            policyId = policyId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiOperationPolicyResultToKotlin(getApiOperationPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiOperationPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiOperationPolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend
    fun getApiOperationPolicy(argument: suspend GetApiOperationPolicyPlainArgsBuilder.() -> Unit):
        GetApiOperationPolicyResult {
        val builder = GetApiOperationPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiOperationPolicyResultToKotlin(getApiOperationPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy configuration at the API level.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-10-10, 2018-06-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend fun getApiPolicy(argument: GetApiPolicyPlainArgs): GetApiPolicyResult =
        getApiPolicyResultToKotlin(getApiPolicyPlain(argument.toJava()).await())

    /**
     * @see [getApiPolicy].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param format Policy Export Format.
     * @param policyId The identifier of the Policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Policy Contract details.
     */
    public suspend fun getApiPolicy(
        apiId: String,
        format: String? = null,
        policyId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiPolicyResult {
        val argument = GetApiPolicyPlainArgs(
            apiId = apiId,
            format = format,
            policyId = policyId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiPolicyResultToKotlin(getApiPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiPolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend fun getApiPolicy(argument: suspend GetApiPolicyPlainArgsBuilder.() -> Unit):
        GetApiPolicyResult {
        val builder = GetApiPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiPolicyResultToKotlin(getApiPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the details of an API release.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return ApiRelease details.
     */
    public suspend fun getApiRelease(argument: GetApiReleasePlainArgs): GetApiReleaseResult =
        getApiReleaseResultToKotlin(getApiReleasePlain(argument.toJava()).await())

    /**
     * @see [getApiRelease].
     * @param apiId API identifier. Must be unique in the current API Management service instance.
     * @param releaseId Release identifier within an API. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return ApiRelease details.
     */
    public suspend fun getApiRelease(
        apiId: String,
        releaseId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiReleaseResult {
        val argument = GetApiReleasePlainArgs(
            apiId = apiId,
            releaseId = releaseId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiReleaseResultToKotlin(getApiReleasePlain(argument.toJava()).await())
    }

    /**
     * @see [getApiRelease].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiReleasePlainArgs].
     * @return ApiRelease details.
     */
    public suspend fun getApiRelease(argument: suspend GetApiReleasePlainArgsBuilder.() -> Unit):
        GetApiReleaseResult {
        val builder = GetApiReleasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiReleaseResultToKotlin(getApiReleasePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the schema configuration at the API level.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return API Schema Contract details.
     */
    public suspend fun getApiSchema(argument: GetApiSchemaPlainArgs): GetApiSchemaResult =
        getApiSchemaResultToKotlin(getApiSchemaPlain(argument.toJava()).await())

    /**
     * @see [getApiSchema].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param schemaId Schema id identifier. Must be unique in the current API Management service instance.
     * @param serviceName The name of the API Management service.
     * @return API Schema Contract details.
     */
    public suspend fun getApiSchema(
        apiId: String,
        resourceGroupName: String,
        schemaId: String,
        serviceName: String,
    ): GetApiSchemaResult {
        val argument = GetApiSchemaPlainArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            schemaId = schemaId,
            serviceName = serviceName,
        )
        return getApiSchemaResultToKotlin(getApiSchemaPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiSchema].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiSchemaPlainArgs].
     * @return API Schema Contract details.
     */
    public suspend fun getApiSchema(argument: suspend GetApiSchemaPlainArgsBuilder.() -> Unit):
        GetApiSchemaResult {
        val builder = GetApiSchemaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiSchemaResultToKotlin(getApiSchemaPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Tag description in scope of API
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Contract details.
     */
    public suspend fun getApiTagDescription(argument: GetApiTagDescriptionPlainArgs):
        GetApiTagDescriptionResult =
        getApiTagDescriptionResultToKotlin(getApiTagDescriptionPlain(argument.toJava()).await())

    /**
     * @see [getApiTagDescription].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagDescriptionId Tag description identifier. Used when creating tagDescription for API/Tag association. Based on API and Tag names.
     * @return Contract details.
     */
    public suspend fun getApiTagDescription(
        apiId: String,
        resourceGroupName: String,
        serviceName: String,
        tagDescriptionId: String,
    ): GetApiTagDescriptionResult {
        val argument = GetApiTagDescriptionPlainArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagDescriptionId = tagDescriptionId,
        )
        return getApiTagDescriptionResultToKotlin(getApiTagDescriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiTagDescription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiTagDescriptionPlainArgs].
     * @return Contract details.
     */
    public suspend
    fun getApiTagDescription(argument: suspend GetApiTagDescriptionPlainArgsBuilder.() -> Unit):
        GetApiTagDescriptionResult {
        val builder = GetApiTagDescriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiTagDescriptionResultToKotlin(getApiTagDescriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Api Version Set specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return API Version Set Contract details.
     */
    public suspend fun getApiVersionSet(argument: GetApiVersionSetPlainArgs): GetApiVersionSetResult =
        getApiVersionSetResultToKotlin(getApiVersionSetPlain(argument.toJava()).await())

    /**
     * @see [getApiVersionSet].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param versionSetId Api Version Set identifier. Must be unique in the current API Management service instance.
     * @return API Version Set Contract details.
     */
    public suspend fun getApiVersionSet(
        resourceGroupName: String,
        serviceName: String,
        versionSetId: String,
    ): GetApiVersionSetResult {
        val argument = GetApiVersionSetPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            versionSetId = versionSetId,
        )
        return getApiVersionSetResultToKotlin(getApiVersionSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiVersionSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiVersionSetPlainArgs].
     * @return API Version Set Contract details.
     */
    public suspend
    fun getApiVersionSet(argument: suspend GetApiVersionSetPlainArgsBuilder.() -> Unit):
        GetApiVersionSetResult {
        val builder = GetApiVersionSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiVersionSetResultToKotlin(getApiVersionSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Wiki for an API specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Wiki properties
     */
    public suspend fun getApiWiki(argument: GetApiWikiPlainArgs): GetApiWikiResult =
        getApiWikiResultToKotlin(getApiWikiPlain(argument.toJava()).await())

    /**
     * @see [getApiWiki].
     * @param apiId API identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Wiki properties
     */
    public suspend fun getApiWiki(
        apiId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiWikiResult {
        val argument = GetApiWikiPlainArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiWikiResultToKotlin(getApiWikiPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiWiki].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetApiWikiPlainArgs].
     * @return Wiki properties
     */
    public suspend fun getApiWiki(argument: suspend GetApiWikiPlainArgsBuilder.() -> Unit):
        GetApiWikiResult {
        val builder = GetApiWikiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiWikiResultToKotlin(getApiWikiPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the authorization specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Authorization contract.
     */
    public suspend fun getAuthorization(argument: GetAuthorizationPlainArgs): GetAuthorizationResult =
        getAuthorizationResultToKotlin(getAuthorizationPlain(argument.toJava()).await())

    /**
     * @see [getAuthorization].
     * @param authorizationId Identifier of the authorization.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Authorization contract.
     */
    public suspend fun getAuthorization(
        authorizationId: String,
        authorizationProviderId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetAuthorizationResult {
        val argument = GetAuthorizationPlainArgs(
            authorizationId = authorizationId,
            authorizationProviderId = authorizationProviderId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getAuthorizationResultToKotlin(getAuthorizationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorization].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetAuthorizationPlainArgs].
     * @return Authorization contract.
     */
    public suspend
    fun getAuthorization(argument: suspend GetAuthorizationPlainArgsBuilder.() -> Unit):
        GetAuthorizationResult {
        val builder = GetAuthorizationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationResultToKotlin(getAuthorizationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the authorization access policy specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Authorization access policy contract.
     */
    public suspend fun getAuthorizationAccessPolicy(argument: GetAuthorizationAccessPolicyPlainArgs):
        GetAuthorizationAccessPolicyResult =
        getAuthorizationAccessPolicyResultToKotlin(getAuthorizationAccessPolicyPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizationAccessPolicy].
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Authorization access policy contract.
     */
    public suspend fun getAuthorizationAccessPolicy(
        authorizationAccessPolicyId: String,
        authorizationId: String,
        authorizationProviderId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetAuthorizationAccessPolicyResult {
        val argument = GetAuthorizationAccessPolicyPlainArgs(
            authorizationAccessPolicyId = authorizationAccessPolicyId,
            authorizationId = authorizationId,
            authorizationProviderId = authorizationProviderId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getAuthorizationAccessPolicyResultToKotlin(getAuthorizationAccessPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizationAccessPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetAuthorizationAccessPolicyPlainArgs].
     * @return Authorization access policy contract.
     */
    public suspend
    fun getAuthorizationAccessPolicy(argument: suspend GetAuthorizationAccessPolicyPlainArgsBuilder.() -> Unit):
        GetAuthorizationAccessPolicyResult {
        val builder = GetAuthorizationAccessPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationAccessPolicyResultToKotlin(getAuthorizationAccessPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets authorization login links.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Authorization login response contract.
     */
    public suspend
    fun getAuthorizationLoginLinkPost(argument: GetAuthorizationLoginLinkPostPlainArgs):
        GetAuthorizationLoginLinkPostResult =
        getAuthorizationLoginLinkPostResultToKotlin(getAuthorizationLoginLinkPostPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizationLoginLinkPost].
     * @param authorizationId Identifier of the authorization.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param postLoginRedirectUrl The redirect URL after login has completed.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Authorization login response contract.
     */
    public suspend fun getAuthorizationLoginLinkPost(
        authorizationId: String,
        authorizationProviderId: String,
        postLoginRedirectUrl: String? = null,
        resourceGroupName: String,
        serviceName: String,
    ): GetAuthorizationLoginLinkPostResult {
        val argument = GetAuthorizationLoginLinkPostPlainArgs(
            authorizationId = authorizationId,
            authorizationProviderId = authorizationProviderId,
            postLoginRedirectUrl = postLoginRedirectUrl,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getAuthorizationLoginLinkPostResultToKotlin(getAuthorizationLoginLinkPostPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizationLoginLinkPost].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetAuthorizationLoginLinkPostPlainArgs].
     * @return Authorization login response contract.
     */
    public suspend
    fun getAuthorizationLoginLinkPost(argument: suspend GetAuthorizationLoginLinkPostPlainArgsBuilder.() -> Unit):
        GetAuthorizationLoginLinkPostResult {
        val builder = GetAuthorizationLoginLinkPostPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationLoginLinkPostResultToKotlin(getAuthorizationLoginLinkPostPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the authorization provider specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Authorization Provider contract.
     */
    public suspend fun getAuthorizationProvider(argument: GetAuthorizationProviderPlainArgs):
        GetAuthorizationProviderResult =
        getAuthorizationProviderResultToKotlin(getAuthorizationProviderPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizationProvider].
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Authorization Provider contract.
     */
    public suspend fun getAuthorizationProvider(
        authorizationProviderId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetAuthorizationProviderResult {
        val argument = GetAuthorizationProviderPlainArgs(
            authorizationProviderId = authorizationProviderId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getAuthorizationProviderResultToKotlin(getAuthorizationProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizationProvider].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetAuthorizationProviderPlainArgs].
     * @return Authorization Provider contract.
     */
    public suspend
    fun getAuthorizationProvider(argument: suspend GetAuthorizationProviderPlainArgsBuilder.() -> Unit):
        GetAuthorizationProviderResult {
        val builder = GetAuthorizationProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationProviderResultToKotlin(getAuthorizationProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the authorization server specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return External OAuth authorization server settings.
     */
    public suspend fun getAuthorizationServer(argument: GetAuthorizationServerPlainArgs):
        GetAuthorizationServerResult =
        getAuthorizationServerResultToKotlin(getAuthorizationServerPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizationServer].
     * @param authsid Identifier of the authorization server.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return External OAuth authorization server settings.
     */
    public suspend fun getAuthorizationServer(
        authsid: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetAuthorizationServerResult {
        val argument = GetAuthorizationServerPlainArgs(
            authsid = authsid,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getAuthorizationServerResultToKotlin(getAuthorizationServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizationServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetAuthorizationServerPlainArgs].
     * @return External OAuth authorization server settings.
     */
    public suspend
    fun getAuthorizationServer(argument: suspend GetAuthorizationServerPlainArgsBuilder.() -> Unit):
        GetAuthorizationServerResult {
        val builder = GetAuthorizationServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationServerResultToKotlin(getAuthorizationServerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the backend specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2018-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Backend details.
     */
    public suspend fun getBackend(argument: GetBackendPlainArgs): GetBackendResult =
        getBackendResultToKotlin(getBackendPlain(argument.toJava()).await())

    /**
     * @see [getBackend].
     * @param backendId Identifier of the Backend entity. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Backend details.
     */
    public suspend fun getBackend(
        backendId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetBackendResult {
        val argument = GetBackendPlainArgs(
            backendId = backendId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getBackendResultToKotlin(getBackendPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackend].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetBackendPlainArgs].
     * @return Backend details.
     */
    public suspend fun getBackend(argument: suspend GetBackendPlainArgsBuilder.() -> Unit):
        GetBackendResult {
        val builder = GetBackendPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackendResultToKotlin(getBackendPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Cache specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2019-12-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Cache details.
     */
    public suspend fun getCache(argument: GetCachePlainArgs): GetCacheResult =
        getCacheResultToKotlin(getCachePlain(argument.toJava()).await())

    /**
     * @see [getCache].
     * @param cacheId Identifier of the Cache entity. Cache identifier (should be either 'default' or valid Azure region identifier).
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Cache details.
     */
    public suspend fun getCache(
        cacheId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetCacheResult {
        val argument = GetCachePlainArgs(
            cacheId = cacheId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getCacheResultToKotlin(getCachePlain(argument.toJava()).await())
    }

    /**
     * @see [getCache].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetCachePlainArgs].
     * @return Cache details.
     */
    public suspend fun getCache(argument: suspend GetCachePlainArgsBuilder.() -> Unit):
        GetCacheResult {
        val builder = GetCachePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCacheResultToKotlin(getCachePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the certificate specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Certificate details.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param certificateId Identifier of the certificate entity. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Certificate details.
     */
    public suspend fun getCertificate(
        certificateId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            certificateId = certificateId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return Certificate details.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit):
        GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the developer portal's content item specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Content type contract details.
     */
    public suspend fun getContentItem(argument: GetContentItemPlainArgs): GetContentItemResult =
        getContentItemResultToKotlin(getContentItemPlain(argument.toJava()).await())

    /**
     * @see [getContentItem].
     * @param contentItemId Content item identifier.
     * @param contentTypeId Content type identifier.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Content type contract details.
     */
    public suspend fun getContentItem(
        contentItemId: String,
        contentTypeId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetContentItemResult {
        val argument = GetContentItemPlainArgs(
            contentItemId = contentItemId,
            contentTypeId = contentTypeId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getContentItemResultToKotlin(getContentItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getContentItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetContentItemPlainArgs].
     * @return Content type contract details.
     */
    public suspend fun getContentItem(argument: suspend GetContentItemPlainArgsBuilder.() -> Unit):
        GetContentItemResult {
        val builder = GetContentItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContentItemResultToKotlin(getContentItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the developer portal's content type. Content types describe content items' properties, validation rules, and constraints.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Content type contract details.
     */
    public suspend fun getContentType(argument: GetContentTypePlainArgs): GetContentTypeResult =
        getContentTypeResultToKotlin(getContentTypePlain(argument.toJava()).await())

    /**
     * @see [getContentType].
     * @param contentTypeId Content type identifier.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Content type contract details.
     */
    public suspend fun getContentType(
        contentTypeId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetContentTypeResult {
        val argument = GetContentTypePlainArgs(
            contentTypeId = contentTypeId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getContentTypeResultToKotlin(getContentTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getContentType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetContentTypePlainArgs].
     * @return Content type contract details.
     */
    public suspend fun getContentType(argument: suspend GetContentTypePlainArgsBuilder.() -> Unit):
        GetContentTypeResult {
        val builder = GetContentTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContentTypeResultToKotlin(getContentTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Diagnostic specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2018-01-01, 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Diagnostic details.
     */
    public suspend fun getDiagnostic(argument: GetDiagnosticPlainArgs): GetDiagnosticResult =
        getDiagnosticResultToKotlin(getDiagnosticPlain(argument.toJava()).await())

    /**
     * @see [getDiagnostic].
     * @param diagnosticId Diagnostic identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Diagnostic details.
     */
    public suspend fun getDiagnostic(
        diagnosticId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetDiagnosticResult {
        val argument = GetDiagnosticPlainArgs(
            diagnosticId = diagnosticId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getDiagnosticResultToKotlin(getDiagnosticPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiagnostic].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetDiagnosticPlainArgs].
     * @return Diagnostic details.
     */
    public suspend fun getDiagnostic(argument: suspend GetDiagnosticPlainArgsBuilder.() -> Unit):
        GetDiagnosticResult {
        val builder = GetDiagnosticPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiagnosticResultToKotlin(getDiagnosticPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Documentation specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Markdown documentation details.
     */
    public suspend fun getDocumentation(argument: GetDocumentationPlainArgs): GetDocumentationResult =
        getDocumentationResultToKotlin(getDocumentationPlain(argument.toJava()).await())

    /**
     * @see [getDocumentation].
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Markdown documentation details.
     */
    public suspend fun getDocumentation(
        documentationId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetDocumentationResult {
        val argument = GetDocumentationPlainArgs(
            documentationId = documentationId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getDocumentationResultToKotlin(getDocumentationPlain(argument.toJava()).await())
    }

    /**
     * @see [getDocumentation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetDocumentationPlainArgs].
     * @return Markdown documentation details.
     */
    public suspend
    fun getDocumentation(argument: suspend GetDocumentationPlainArgsBuilder.() -> Unit):
        GetDocumentationResult {
        val builder = GetDocumentationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDocumentationResultToKotlin(getDocumentationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the email template specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Email Template details.
     */
    public suspend fun getEmailTemplate(argument: GetEmailTemplatePlainArgs): GetEmailTemplateResult =
        getEmailTemplateResultToKotlin(getEmailTemplatePlain(argument.toJava()).await())

    /**
     * @see [getEmailTemplate].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param templateName Email Template Name Identifier.
     * @return Email Template details.
     */
    public suspend fun getEmailTemplate(
        resourceGroupName: String,
        serviceName: String,
        templateName: String,
    ): GetEmailTemplateResult {
        val argument = GetEmailTemplatePlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            templateName = templateName,
        )
        return getEmailTemplateResultToKotlin(getEmailTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getEmailTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetEmailTemplatePlainArgs].
     * @return Email Template details.
     */
    public suspend
    fun getEmailTemplate(argument: suspend GetEmailTemplatePlainArgsBuilder.() -> Unit):
        GetEmailTemplateResult {
        val builder = GetEmailTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEmailTemplateResultToKotlin(getEmailTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Gateway specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Gateway details.
     */
    public suspend fun getGateway(argument: GetGatewayPlainArgs): GetGatewayResult =
        getGatewayResultToKotlin(getGatewayPlain(argument.toJava()).await())

    /**
     * @see [getGateway].
     * @param gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Gateway details.
     */
    public suspend fun getGateway(
        gatewayId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetGatewayResult {
        val argument = GetGatewayPlainArgs(
            gatewayId = gatewayId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getGatewayResultToKotlin(getGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getGateway].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetGatewayPlainArgs].
     * @return Gateway details.
     */
    public suspend fun getGateway(argument: suspend GetGatewayPlainArgsBuilder.() -> Unit):
        GetGatewayResult {
        val builder = GetGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayResultToKotlin(getGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Get assigned Gateway Certificate Authority details.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Gateway certificate authority details.
     */
    public suspend
    fun getGatewayCertificateAuthority(argument: GetGatewayCertificateAuthorityPlainArgs):
        GetGatewayCertificateAuthorityResult =
        getGatewayCertificateAuthorityResultToKotlin(getGatewayCertificateAuthorityPlain(argument.toJava()).await())

    /**
     * @see [getGatewayCertificateAuthority].
     * @param certificateId Identifier of the certificate entity. Must be unique in the current API Management service instance.
     * @param gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Gateway certificate authority details.
     */
    public suspend fun getGatewayCertificateAuthority(
        certificateId: String,
        gatewayId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetGatewayCertificateAuthorityResult {
        val argument = GetGatewayCertificateAuthorityPlainArgs(
            certificateId = certificateId,
            gatewayId = gatewayId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getGatewayCertificateAuthorityResultToKotlin(getGatewayCertificateAuthorityPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayCertificateAuthority].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetGatewayCertificateAuthorityPlainArgs].
     * @return Gateway certificate authority details.
     */
    public suspend
    fun getGatewayCertificateAuthority(argument: suspend GetGatewayCertificateAuthorityPlainArgsBuilder.() -> Unit):
        GetGatewayCertificateAuthorityResult {
        val builder = GetGatewayCertificateAuthorityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayCertificateAuthorityResultToKotlin(getGatewayCertificateAuthorityPlain(builtArgument.toJava()).await())
    }

    /**
     * Get details of a hostname configuration
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Gateway hostname configuration details.
     */
    public suspend
    fun getGatewayHostnameConfiguration(argument: GetGatewayHostnameConfigurationPlainArgs):
        GetGatewayHostnameConfigurationResult =
        getGatewayHostnameConfigurationResultToKotlin(getGatewayHostnameConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getGatewayHostnameConfiguration].
     * @param gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     * @param hcId Gateway hostname configuration identifier. Must be unique in the scope of parent Gateway entity.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Gateway hostname configuration details.
     */
    public suspend fun getGatewayHostnameConfiguration(
        gatewayId: String,
        hcId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetGatewayHostnameConfigurationResult {
        val argument = GetGatewayHostnameConfigurationPlainArgs(
            gatewayId = gatewayId,
            hcId = hcId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getGatewayHostnameConfigurationResultToKotlin(getGatewayHostnameConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayHostnameConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetGatewayHostnameConfigurationPlainArgs].
     * @return Gateway hostname configuration details.
     */
    public suspend
    fun getGatewayHostnameConfiguration(argument: suspend GetGatewayHostnameConfigurationPlainArgsBuilder.() -> Unit):
        GetGatewayHostnameConfigurationResult {
        val builder = GetGatewayHostnameConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayHostnameConfigurationResultToKotlin(getGatewayHostnameConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Schema specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Global Schema Contract details.
     */
    public suspend fun getGlobalSchema(argument: GetGlobalSchemaPlainArgs): GetGlobalSchemaResult =
        getGlobalSchemaResultToKotlin(getGlobalSchemaPlain(argument.toJava()).await())

    /**
     * @see [getGlobalSchema].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param schemaId Schema id identifier. Must be unique in the current API Management service instance.
     * @param serviceName The name of the API Management service.
     * @return Global Schema Contract details.
     */
    public suspend fun getGlobalSchema(
        resourceGroupName: String,
        schemaId: String,
        serviceName: String,
    ): GetGlobalSchemaResult {
        val argument = GetGlobalSchemaPlainArgs(
            resourceGroupName = resourceGroupName,
            schemaId = schemaId,
            serviceName = serviceName,
        )
        return getGlobalSchemaResultToKotlin(getGlobalSchemaPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalSchema].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetGlobalSchemaPlainArgs].
     * @return Global Schema Contract details.
     */
    public suspend fun getGlobalSchema(argument: suspend GetGlobalSchemaPlainArgsBuilder.() -> Unit):
        GetGlobalSchemaResult {
        val builder = GetGlobalSchemaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalSchemaResultToKotlin(getGlobalSchemaPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the GraphQL API Resolver specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return GraphQL API Resolver details.
     */
    public suspend fun getGraphQLApiResolver(argument: GetGraphQLApiResolverPlainArgs):
        GetGraphQLApiResolverResult =
        getGraphQLApiResolverResultToKotlin(getGraphQLApiResolverPlain(argument.toJava()).await())

    /**
     * @see [getGraphQLApiResolver].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param resolverId Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return GraphQL API Resolver details.
     */
    public suspend fun getGraphQLApiResolver(
        apiId: String,
        resolverId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetGraphQLApiResolverResult {
        val argument = GetGraphQLApiResolverPlainArgs(
            apiId = apiId,
            resolverId = resolverId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getGraphQLApiResolverResultToKotlin(getGraphQLApiResolverPlain(argument.toJava()).await())
    }

    /**
     * @see [getGraphQLApiResolver].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetGraphQLApiResolverPlainArgs].
     * @return GraphQL API Resolver details.
     */
    public suspend
    fun getGraphQLApiResolver(argument: suspend GetGraphQLApiResolverPlainArgsBuilder.() -> Unit):
        GetGraphQLApiResolverResult {
        val builder = GetGraphQLApiResolverPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGraphQLApiResolverResultToKotlin(getGraphQLApiResolverPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy configuration at the GraphQL API Resolver level.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend fun getGraphQLApiResolverPolicy(argument: GetGraphQLApiResolverPolicyPlainArgs):
        GetGraphQLApiResolverPolicyResult =
        getGraphQLApiResolverPolicyResultToKotlin(getGraphQLApiResolverPolicyPlain(argument.toJava()).await())

    /**
     * @see [getGraphQLApiResolverPolicy].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param format Policy Export Format.
     * @param policyId The identifier of the Policy.
     * @param resolverId Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Policy Contract details.
     */
    public suspend fun getGraphQLApiResolverPolicy(
        apiId: String,
        format: String? = null,
        policyId: String,
        resolverId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetGraphQLApiResolverPolicyResult {
        val argument = GetGraphQLApiResolverPolicyPlainArgs(
            apiId = apiId,
            format = format,
            policyId = policyId,
            resolverId = resolverId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getGraphQLApiResolverPolicyResultToKotlin(getGraphQLApiResolverPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getGraphQLApiResolverPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetGraphQLApiResolverPolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend
    fun getGraphQLApiResolverPolicy(argument: suspend GetGraphQLApiResolverPolicyPlainArgsBuilder.() -> Unit):
        GetGraphQLApiResolverPolicyResult {
        val builder = GetGraphQLApiResolverPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGraphQLApiResolverPolicyResultToKotlin(getGraphQLApiResolverPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the group specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Contract details.
     */
    public suspend fun getGroup(argument: GetGroupPlainArgs): GetGroupResult =
        getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())

    /**
     * @see [getGroup].
     * @param groupId Group identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Contract details.
     */
    public suspend fun getGroup(
        groupId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetGroupResult {
        val argument = GetGroupPlainArgs(
            groupId = groupId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetGroupPlainArgs].
     * @return Contract details.
     */
    public suspend fun getGroup(argument: suspend GetGroupPlainArgsBuilder.() -> Unit):
        GetGroupResult {
        val builder = GetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupResultToKotlin(getGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the configuration details of the identity Provider configured in specified service instance.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Identity Provider details.
     */
    public suspend fun getIdentityProvider(argument: GetIdentityProviderPlainArgs):
        GetIdentityProviderResult =
        getIdentityProviderResultToKotlin(getIdentityProviderPlain(argument.toJava()).await())

    /**
     * @see [getIdentityProvider].
     * @param identityProviderName Identity Provider Type identifier.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Identity Provider details.
     */
    public suspend fun getIdentityProvider(
        identityProviderName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetIdentityProviderResult {
        val argument = GetIdentityProviderPlainArgs(
            identityProviderName = identityProviderName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getIdentityProviderResultToKotlin(getIdentityProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getIdentityProvider].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetIdentityProviderPlainArgs].
     * @return Identity Provider details.
     */
    public suspend
    fun getIdentityProvider(argument: suspend GetIdentityProviderPlainArgsBuilder.() -> Unit):
        GetIdentityProviderResult {
        val builder = GetIdentityProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIdentityProviderResultToKotlin(getIdentityProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the logger specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-01-01, 2019-12-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Logger details.
     */
    public suspend fun getLogger(argument: GetLoggerPlainArgs): GetLoggerResult =
        getLoggerResultToKotlin(getLoggerPlain(argument.toJava()).await())

    /**
     * @see [getLogger].
     * @param loggerId Logger identifier. Must be unique in the API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Logger details.
     */
    public suspend fun getLogger(
        loggerId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetLoggerResult {
        val argument = GetLoggerPlainArgs(
            loggerId = loggerId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getLoggerResultToKotlin(getLoggerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogger].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetLoggerPlainArgs].
     * @return Logger details.
     */
    public suspend fun getLogger(argument: suspend GetLoggerPlainArgsBuilder.() -> Unit):
        GetLoggerResult {
        val builder = GetLoggerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLoggerResultToKotlin(getLoggerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the named value specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return NamedValue details.
     */
    public suspend fun getNamedValue(argument: GetNamedValuePlainArgs): GetNamedValueResult =
        getNamedValueResultToKotlin(getNamedValuePlain(argument.toJava()).await())

    /**
     * @see [getNamedValue].
     * @param namedValueId Identifier of the NamedValue.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return NamedValue details.
     */
    public suspend fun getNamedValue(
        namedValueId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetNamedValueResult {
        val argument = GetNamedValuePlainArgs(
            namedValueId = namedValueId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getNamedValueResultToKotlin(getNamedValuePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamedValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetNamedValuePlainArgs].
     * @return NamedValue details.
     */
    public suspend fun getNamedValue(argument: suspend GetNamedValuePlainArgsBuilder.() -> Unit):
        GetNamedValueResult {
        val builder = GetNamedValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamedValueResultToKotlin(getNamedValuePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets specific OpenID Connect Provider without secrets.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return OpenId Connect Provider details.
     */
    public suspend fun getOpenIdConnectProvider(argument: GetOpenIdConnectProviderPlainArgs):
        GetOpenIdConnectProviderResult =
        getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(argument.toJava()).await())

    /**
     * @see [getOpenIdConnectProvider].
     * @param opid Identifier of the OpenID Connect Provider.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return OpenId Connect Provider details.
     */
    public suspend fun getOpenIdConnectProvider(
        opid: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetOpenIdConnectProviderResult {
        val argument = GetOpenIdConnectProviderPlainArgs(
            opid = opid,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenIdConnectProvider].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetOpenIdConnectProviderPlainArgs].
     * @return OpenId Connect Provider details.
     */
    public suspend
    fun getOpenIdConnectProvider(argument: suspend GetOpenIdConnectProviderPlainArgsBuilder.() -> Unit):
        GetOpenIdConnectProviderResult {
        val builder = GetOpenIdConnectProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Global policy definition of the Api Management service.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2018-06-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend fun getPolicy(argument: GetPolicyPlainArgs): GetPolicyResult =
        getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())

    /**
     * @see [getPolicy].
     * @param format Policy Export Format.
     * @param policyId The identifier of the Policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Policy Contract details.
     */
    public suspend fun getPolicy(
        format: String? = null,
        policyId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetPolicyResult {
        val argument = GetPolicyPlainArgs(
            format = format,
            policyId = policyId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetPolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend fun getPolicy(argument: suspend GetPolicyPlainArgsBuilder.() -> Unit):
        GetPolicyResult {
        val builder = GetPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyResultToKotlin(getPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a policy fragment.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy fragment contract details.
     */
    public suspend fun getPolicyFragment(argument: GetPolicyFragmentPlainArgs):
        GetPolicyFragmentResult =
        getPolicyFragmentResultToKotlin(getPolicyFragmentPlain(argument.toJava()).await())

    /**
     * @see [getPolicyFragment].
     * @param format Policy fragment content format.
     * @param id A resource identifier.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Policy fragment contract details.
     */
    public suspend fun getPolicyFragment(
        format: String? = null,
        id: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetPolicyFragmentResult {
        val argument = GetPolicyFragmentPlainArgs(
            format = format,
            id = id,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getPolicyFragmentResultToKotlin(getPolicyFragmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyFragment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetPolicyFragmentPlainArgs].
     * @return Policy fragment contract details.
     */
    public suspend
    fun getPolicyFragment(argument: suspend GetPolicyFragmentPlainArgsBuilder.() -> Unit):
        GetPolicyFragmentResult {
        val builder = GetPolicyFragmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyFragmentResultToKotlin(getPolicyFragmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy restriction of the Api Management service.
     * Azure REST API version: 2023-05-01-preview.
     * @param argument null
     * @return Policy restriction contract details.
     */
    public suspend fun getPolicyRestriction(argument: GetPolicyRestrictionPlainArgs):
        GetPolicyRestrictionResult =
        getPolicyRestrictionResultToKotlin(getPolicyRestrictionPlain(argument.toJava()).await())

    /**
     * @see [getPolicyRestriction].
     * @param policyRestrictionId Policy restrictions after an entity level
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Policy restriction contract details.
     */
    public suspend fun getPolicyRestriction(
        policyRestrictionId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetPolicyRestrictionResult {
        val argument = GetPolicyRestrictionPlainArgs(
            policyRestrictionId = policyRestrictionId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getPolicyRestrictionResultToKotlin(getPolicyRestrictionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyRestriction].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetPolicyRestrictionPlainArgs].
     * @return Policy restriction contract details.
     */
    public suspend
    fun getPolicyRestriction(argument: suspend GetPolicyRestrictionPlainArgsBuilder.() -> Unit):
        GetPolicyRestrictionResult {
        val builder = GetPolicyRestrictionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyRestrictionResultToKotlin(getPolicyRestrictionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Private Endpoint Connection specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionByName(argument: GetPrivateEndpointConnectionByNamePlainArgs):
        GetPrivateEndpointConnectionByNameResult =
        getPrivateEndpointConnectionByNameResultToKotlin(getPrivateEndpointConnectionByNamePlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionByName].
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionByName(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetPrivateEndpointConnectionByNameResult {
        val argument = GetPrivateEndpointConnectionByNamePlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getPrivateEndpointConnectionByNameResultToKotlin(getPrivateEndpointConnectionByNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionByName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionByNamePlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionByName(argument: suspend GetPrivateEndpointConnectionByNamePlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionByNameResult {
        val builder = GetPrivateEndpointConnectionByNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionByNameResultToKotlin(getPrivateEndpointConnectionByNamePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the product specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Product details.
     */
    public suspend fun getProduct(argument: GetProductPlainArgs): GetProductResult =
        getProductResultToKotlin(getProductPlain(argument.toJava()).await())

    /**
     * @see [getProduct].
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Product details.
     */
    public suspend fun getProduct(
        productId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetProductResult {
        val argument = GetProductPlainArgs(
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getProductResultToKotlin(getProductPlain(argument.toJava()).await())
    }

    /**
     * @see [getProduct].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetProductPlainArgs].
     * @return Product details.
     */
    public suspend fun getProduct(argument: suspend GetProductPlainArgsBuilder.() -> Unit):
        GetProductResult {
        val builder = GetProductPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductResultToKotlin(getProductPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the API link for the product.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Product-API link details.
     */
    public suspend fun getProductApiLink(argument: GetProductApiLinkPlainArgs):
        GetProductApiLinkResult =
        getProductApiLinkResultToKotlin(getProductApiLinkPlain(argument.toJava()).await())

    /**
     * @see [getProductApiLink].
     * @param apiLinkId Product-API link identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Product-API link details.
     */
    public suspend fun getProductApiLink(
        apiLinkId: String,
        productId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetProductApiLinkResult {
        val argument = GetProductApiLinkPlainArgs(
            apiLinkId = apiLinkId,
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getProductApiLinkResultToKotlin(getProductApiLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getProductApiLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetProductApiLinkPlainArgs].
     * @return Product-API link details.
     */
    public suspend
    fun getProductApiLink(argument: suspend GetProductApiLinkPlainArgsBuilder.() -> Unit):
        GetProductApiLinkResult {
        val builder = GetProductApiLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductApiLinkResultToKotlin(getProductApiLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the group link for the product.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Product-group link details.
     */
    public suspend fun getProductGroupLink(argument: GetProductGroupLinkPlainArgs):
        GetProductGroupLinkResult =
        getProductGroupLinkResultToKotlin(getProductGroupLinkPlain(argument.toJava()).await())

    /**
     * @see [getProductGroupLink].
     * @param groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Product-group link details.
     */
    public suspend fun getProductGroupLink(
        groupLinkId: String,
        productId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetProductGroupLinkResult {
        val argument = GetProductGroupLinkPlainArgs(
            groupLinkId = groupLinkId,
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getProductGroupLinkResultToKotlin(getProductGroupLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getProductGroupLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetProductGroupLinkPlainArgs].
     * @return Product-group link details.
     */
    public suspend
    fun getProductGroupLink(argument: suspend GetProductGroupLinkPlainArgsBuilder.() -> Unit):
        GetProductGroupLinkResult {
        val builder = GetProductGroupLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductGroupLinkResultToKotlin(getProductGroupLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy configuration at the Product level.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-10-10, 2018-06-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend fun getProductPolicy(argument: GetProductPolicyPlainArgs): GetProductPolicyResult =
        getProductPolicyResultToKotlin(getProductPolicyPlain(argument.toJava()).await())

    /**
     * @see [getProductPolicy].
     * @param format Policy Export Format.
     * @param policyId The identifier of the Policy.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Policy Contract details.
     */
    public suspend fun getProductPolicy(
        format: String? = null,
        policyId: String,
        productId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetProductPolicyResult {
        val argument = GetProductPolicyPlainArgs(
            format = format,
            policyId = policyId,
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getProductPolicyResultToKotlin(getProductPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getProductPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetProductPolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend
    fun getProductPolicy(argument: suspend GetProductPolicyPlainArgsBuilder.() -> Unit):
        GetProductPolicyResult {
        val builder = GetProductPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductPolicyResultToKotlin(getProductPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Wiki for a Product specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Wiki properties
     */
    public suspend fun getProductWiki(argument: GetProductWikiPlainArgs): GetProductWikiResult =
        getProductWikiResultToKotlin(getProductWikiPlain(argument.toJava()).await())

    /**
     * @see [getProductWiki].
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Wiki properties
     */
    public suspend fun getProductWiki(
        productId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetProductWikiResult {
        val argument = GetProductWikiPlainArgs(
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getProductWikiResultToKotlin(getProductWikiPlain(argument.toJava()).await())
    }

    /**
     * @see [getProductWiki].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetProductWikiPlainArgs].
     * @return Wiki properties
     */
    public suspend fun getProductWiki(argument: suspend GetProductWikiPlainArgsBuilder.() -> Unit):
        GetProductWikiResult {
        val builder = GetProductWikiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductWikiResultToKotlin(getProductWikiPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Schema specified by its identifier.
     * Azure REST API version: 2021-04-01-preview.
     * @param argument null
     * @return Schema Contract details.
     */
    public suspend fun getSchema(argument: GetSchemaPlainArgs): GetSchemaResult =
        getSchemaResultToKotlin(getSchemaPlain(argument.toJava()).await())

    /**
     * @see [getSchema].
     * @param resourceGroupName The name of the resource group.
     * @param schemaId Schema id identifier. Must be unique in the current API Management service instance.
     * @param serviceName The name of the API Management service.
     * @return Schema Contract details.
     */
    public suspend fun getSchema(
        resourceGroupName: String,
        schemaId: String,
        serviceName: String,
    ): GetSchemaResult {
        val argument = GetSchemaPlainArgs(
            resourceGroupName = resourceGroupName,
            schemaId = schemaId,
            serviceName = serviceName,
        )
        return getSchemaResultToKotlin(getSchemaPlain(argument.toJava()).await())
    }

    /**
     * @see [getSchema].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetSchemaPlainArgs].
     * @return Schema Contract details.
     */
    public suspend fun getSchema(argument: suspend GetSchemaPlainArgsBuilder.() -> Unit):
        GetSchemaResult {
        val builder = GetSchemaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSchemaResultToKotlin(getSchemaPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Subscription entity.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2018-01-01, 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Subscription details.
     */
    public suspend fun getSubscription(argument: GetSubscriptionPlainArgs): GetSubscriptionResult =
        getSubscriptionResultToKotlin(getSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getSubscription].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
     * @return Subscription details.
     */
    public suspend fun getSubscription(
        resourceGroupName: String,
        serviceName: String,
        sid: String,
    ): GetSubscriptionResult {
        val argument = GetSubscriptionPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            sid = sid,
        )
        return getSubscriptionResultToKotlin(getSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetSubscriptionPlainArgs].
     * @return Subscription details.
     */
    public suspend fun getSubscription(argument: suspend GetSubscriptionPlainArgsBuilder.() -> Unit):
        GetSubscriptionResult {
        val builder = GetSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubscriptionResultToKotlin(getSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the tag specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag Contract details.
     */
    public suspend fun getTag(argument: GetTagPlainArgs): GetTagResult =
        getTagResultToKotlin(getTagPlain(argument.toJava()).await())

    /**
     * @see [getTag].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @return Tag Contract details.
     */
    public suspend fun getTag(
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
    ): GetTagResult {
        val argument = GetTagPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
        )
        return getTagResultToKotlin(getTagPlain(argument.toJava()).await())
    }

    /**
     * @see [getTag].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetTagPlainArgs].
     * @return Tag Contract details.
     */
    public suspend fun getTag(argument: suspend GetTagPlainArgsBuilder.() -> Unit): GetTagResult {
        val builder = GetTagPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagResultToKotlin(getTagPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the API link for the tag.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag-API link details.
     */
    public suspend fun getTagApiLink(argument: GetTagApiLinkPlainArgs): GetTagApiLinkResult =
        getTagApiLinkResultToKotlin(getTagApiLinkPlain(argument.toJava()).await())

    /**
     * @see [getTagApiLink].
     * @param apiLinkId Tag-API link identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @return Tag-API link details.
     */
    public suspend fun getTagApiLink(
        apiLinkId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
    ): GetTagApiLinkResult {
        val argument = GetTagApiLinkPlainArgs(
            apiLinkId = apiLinkId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
        )
        return getTagApiLinkResultToKotlin(getTagApiLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getTagApiLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetTagApiLinkPlainArgs].
     * @return Tag-API link details.
     */
    public suspend fun getTagApiLink(argument: suspend GetTagApiLinkPlainArgsBuilder.() -> Unit):
        GetTagApiLinkResult {
        val builder = GetTagApiLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagApiLinkResultToKotlin(getTagApiLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get tag associated with the API.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag Contract details.
     */
    public suspend fun getTagByApi(argument: GetTagByApiPlainArgs): GetTagByApiResult =
        getTagByApiResultToKotlin(getTagByApiPlain(argument.toJava()).await())

    /**
     * @see [getTagByApi].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @return Tag Contract details.
     */
    public suspend fun getTagByApi(
        apiId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
    ): GetTagByApiResult {
        val argument = GetTagByApiPlainArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
        )
        return getTagByApiResultToKotlin(getTagByApiPlain(argument.toJava()).await())
    }

    /**
     * @see [getTagByApi].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetTagByApiPlainArgs].
     * @return Tag Contract details.
     */
    public suspend fun getTagByApi(argument: suspend GetTagByApiPlainArgsBuilder.() -> Unit):
        GetTagByApiResult {
        val builder = GetTagByApiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagByApiResultToKotlin(getTagByApiPlain(builtArgument.toJava()).await())
    }

    /**
     * Get tag associated with the Operation.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag Contract details.
     */
    public suspend fun getTagByOperation(argument: GetTagByOperationPlainArgs):
        GetTagByOperationResult =
        getTagByOperationResultToKotlin(getTagByOperationPlain(argument.toJava()).await())

    /**
     * @see [getTagByOperation].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param operationId Operation identifier within an API. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @return Tag Contract details.
     */
    public suspend fun getTagByOperation(
        apiId: String,
        operationId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
    ): GetTagByOperationResult {
        val argument = GetTagByOperationPlainArgs(
            apiId = apiId,
            operationId = operationId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
        )
        return getTagByOperationResultToKotlin(getTagByOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getTagByOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetTagByOperationPlainArgs].
     * @return Tag Contract details.
     */
    public suspend
    fun getTagByOperation(argument: suspend GetTagByOperationPlainArgsBuilder.() -> Unit):
        GetTagByOperationResult {
        val builder = GetTagByOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagByOperationResultToKotlin(getTagByOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get tag associated with the Product.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag Contract details.
     */
    public suspend fun getTagByProduct(argument: GetTagByProductPlainArgs): GetTagByProductResult =
        getTagByProductResultToKotlin(getTagByProductPlain(argument.toJava()).await())

    /**
     * @see [getTagByProduct].
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @return Tag Contract details.
     */
    public suspend fun getTagByProduct(
        productId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
    ): GetTagByProductResult {
        val argument = GetTagByProductPlainArgs(
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
        )
        return getTagByProductResultToKotlin(getTagByProductPlain(argument.toJava()).await())
    }

    /**
     * @see [getTagByProduct].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetTagByProductPlainArgs].
     * @return Tag Contract details.
     */
    public suspend fun getTagByProduct(argument: suspend GetTagByProductPlainArgsBuilder.() -> Unit):
        GetTagByProductResult {
        val builder = GetTagByProductPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagByProductResultToKotlin(getTagByProductPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the operation link for the tag.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag-operation link details.
     */
    public suspend fun getTagOperationLink(argument: GetTagOperationLinkPlainArgs):
        GetTagOperationLinkResult =
        getTagOperationLinkResultToKotlin(getTagOperationLinkPlain(argument.toJava()).await())

    /**
     * @see [getTagOperationLink].
     * @param operationLinkId Tag-operation link identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @return Tag-operation link details.
     */
    public suspend fun getTagOperationLink(
        operationLinkId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
    ): GetTagOperationLinkResult {
        val argument = GetTagOperationLinkPlainArgs(
            operationLinkId = operationLinkId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
        )
        return getTagOperationLinkResultToKotlin(getTagOperationLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getTagOperationLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetTagOperationLinkPlainArgs].
     * @return Tag-operation link details.
     */
    public suspend
    fun getTagOperationLink(argument: suspend GetTagOperationLinkPlainArgsBuilder.() -> Unit):
        GetTagOperationLinkResult {
        val builder = GetTagOperationLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagOperationLinkResultToKotlin(getTagOperationLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the product link for the tag.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag-product link details.
     */
    public suspend fun getTagProductLink(argument: GetTagProductLinkPlainArgs):
        GetTagProductLinkResult =
        getTagProductLinkResultToKotlin(getTagProductLinkPlain(argument.toJava()).await())

    /**
     * @see [getTagProductLink].
     * @param productLinkId Tag-product link identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @return Tag-product link details.
     */
    public suspend fun getTagProductLink(
        productLinkId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
    ): GetTagProductLinkResult {
        val argument = GetTagProductLinkPlainArgs(
            productLinkId = productLinkId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
        )
        return getTagProductLinkResultToKotlin(getTagProductLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getTagProductLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetTagProductLinkPlainArgs].
     * @return Tag-product link details.
     */
    public suspend
    fun getTagProductLink(argument: suspend GetTagProductLinkPlainArgsBuilder.() -> Unit):
        GetTagProductLinkResult {
        val builder = GetTagProductLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagProductLinkResultToKotlin(getTagProductLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the user specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return User details.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param userId User identifier. Must be unique in the current API Management service instance.
     * @return User details.
     */
    public suspend fun getUser(
        resourceGroupName: String,
        serviceName: String,
        userId: String,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            userId = userId,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return User details.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Shared Access Authorization Token for the User.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2016-10-10, 2017-03-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Get User Token response details.
     */
    public suspend fun getUserSharedAccessToken(argument: GetUserSharedAccessTokenPlainArgs):
        GetUserSharedAccessTokenResult =
        getUserSharedAccessTokenResultToKotlin(getUserSharedAccessTokenPlain(argument.toJava()).await())

    /**
     * @see [getUserSharedAccessToken].
     * @param expiry The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * @param keyType The Key to be used to generate token for user.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param userId User identifier. Must be unique in the current API Management service instance.
     * @return Get User Token response details.
     */
    public suspend fun getUserSharedAccessToken(
        expiry: String,
        keyType: KeyType,
        resourceGroupName: String,
        serviceName: String,
        userId: String,
    ): GetUserSharedAccessTokenResult {
        val argument = GetUserSharedAccessTokenPlainArgs(
            expiry = expiry,
            keyType = keyType,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            userId = userId,
        )
        return getUserSharedAccessTokenResultToKotlin(getUserSharedAccessTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserSharedAccessToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetUserSharedAccessTokenPlainArgs].
     * @return Get User Token response details.
     */
    public suspend
    fun getUserSharedAccessToken(argument: suspend GetUserSharedAccessTokenPlainArgsBuilder.() -> Unit):
        GetUserSharedAccessTokenResult {
        val builder = GetUserSharedAccessTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserSharedAccessTokenResultToKotlin(getUserSharedAccessTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the workspace specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Workspace details.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Workspace details.
     */
    public suspend fun getWorkspace(
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return Workspace details.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the API specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return API details.
     */
    public suspend fun getWorkspaceApi(argument: GetWorkspaceApiPlainArgs): GetWorkspaceApiResult =
        getWorkspaceApiResultToKotlin(getWorkspaceApiPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceApi].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return API details.
     */
    public suspend fun getWorkspaceApi(
        apiId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceApiResult {
        val argument = GetWorkspaceApiPlainArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceApiResultToKotlin(getWorkspaceApiPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceApi].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceApiPlainArgs].
     * @return API details.
     */
    public suspend fun getWorkspaceApi(argument: suspend GetWorkspaceApiPlainArgsBuilder.() -> Unit):
        GetWorkspaceApiResult {
        val builder = GetWorkspaceApiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceApiResultToKotlin(getWorkspaceApiPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the API Operation specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return API Operation details.
     */
    public suspend fun getWorkspaceApiOperation(argument: GetWorkspaceApiOperationPlainArgs):
        GetWorkspaceApiOperationResult =
        getWorkspaceApiOperationResultToKotlin(getWorkspaceApiOperationPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceApiOperation].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param operationId Operation identifier within an API. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return API Operation details.
     */
    public suspend fun getWorkspaceApiOperation(
        apiId: String,
        operationId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceApiOperationResult {
        val argument = GetWorkspaceApiOperationPlainArgs(
            apiId = apiId,
            operationId = operationId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceApiOperationResultToKotlin(getWorkspaceApiOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceApiOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceApiOperationPlainArgs].
     * @return API Operation details.
     */
    public suspend
    fun getWorkspaceApiOperation(argument: suspend GetWorkspaceApiOperationPlainArgsBuilder.() -> Unit):
        GetWorkspaceApiOperationResult {
        val builder = GetWorkspaceApiOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceApiOperationResultToKotlin(getWorkspaceApiOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy configuration at the API Operation level.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend
    fun getWorkspaceApiOperationPolicy(argument: GetWorkspaceApiOperationPolicyPlainArgs):
        GetWorkspaceApiOperationPolicyResult =
        getWorkspaceApiOperationPolicyResultToKotlin(getWorkspaceApiOperationPolicyPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceApiOperationPolicy].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param format Policy Export Format.
     * @param operationId Operation identifier within an API. Must be unique in the current API Management service instance.
     * @param policyId The identifier of the Policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Policy Contract details.
     */
    public suspend fun getWorkspaceApiOperationPolicy(
        apiId: String,
        format: String? = null,
        operationId: String,
        policyId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceApiOperationPolicyResult {
        val argument = GetWorkspaceApiOperationPolicyPlainArgs(
            apiId = apiId,
            format = format,
            operationId = operationId,
            policyId = policyId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceApiOperationPolicyResultToKotlin(getWorkspaceApiOperationPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceApiOperationPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceApiOperationPolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend
    fun getWorkspaceApiOperationPolicy(argument: suspend GetWorkspaceApiOperationPolicyPlainArgsBuilder.() -> Unit):
        GetWorkspaceApiOperationPolicyResult {
        val builder = GetWorkspaceApiOperationPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceApiOperationPolicyResultToKotlin(getWorkspaceApiOperationPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy configuration at the API level.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend fun getWorkspaceApiPolicy(argument: GetWorkspaceApiPolicyPlainArgs):
        GetWorkspaceApiPolicyResult =
        getWorkspaceApiPolicyResultToKotlin(getWorkspaceApiPolicyPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceApiPolicy].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param format Policy Export Format.
     * @param policyId The identifier of the Policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Policy Contract details.
     */
    public suspend fun getWorkspaceApiPolicy(
        apiId: String,
        format: String? = null,
        policyId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceApiPolicyResult {
        val argument = GetWorkspaceApiPolicyPlainArgs(
            apiId = apiId,
            format = format,
            policyId = policyId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceApiPolicyResultToKotlin(getWorkspaceApiPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceApiPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceApiPolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend
    fun getWorkspaceApiPolicy(argument: suspend GetWorkspaceApiPolicyPlainArgsBuilder.() -> Unit):
        GetWorkspaceApiPolicyResult {
        val builder = GetWorkspaceApiPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceApiPolicyResultToKotlin(getWorkspaceApiPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the details of an API release.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return ApiRelease details.
     */
    public suspend fun getWorkspaceApiRelease(argument: GetWorkspaceApiReleasePlainArgs):
        GetWorkspaceApiReleaseResult =
        getWorkspaceApiReleaseResultToKotlin(getWorkspaceApiReleasePlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceApiRelease].
     * @param apiId API identifier. Must be unique in the current API Management service instance.
     * @param releaseId Release identifier within an API. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return ApiRelease details.
     */
    public suspend fun getWorkspaceApiRelease(
        apiId: String,
        releaseId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceApiReleaseResult {
        val argument = GetWorkspaceApiReleasePlainArgs(
            apiId = apiId,
            releaseId = releaseId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceApiReleaseResultToKotlin(getWorkspaceApiReleasePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceApiRelease].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceApiReleasePlainArgs].
     * @return ApiRelease details.
     */
    public suspend
    fun getWorkspaceApiRelease(argument: suspend GetWorkspaceApiReleasePlainArgsBuilder.() -> Unit):
        GetWorkspaceApiReleaseResult {
        val builder = GetWorkspaceApiReleasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceApiReleaseResultToKotlin(getWorkspaceApiReleasePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the schema configuration at the API level.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return API Schema Contract details.
     */
    public suspend fun getWorkspaceApiSchema(argument: GetWorkspaceApiSchemaPlainArgs):
        GetWorkspaceApiSchemaResult =
        getWorkspaceApiSchemaResultToKotlin(getWorkspaceApiSchemaPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceApiSchema].
     * @param apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param schemaId Schema id identifier. Must be unique in the current API Management service instance.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return API Schema Contract details.
     */
    public suspend fun getWorkspaceApiSchema(
        apiId: String,
        resourceGroupName: String,
        schemaId: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceApiSchemaResult {
        val argument = GetWorkspaceApiSchemaPlainArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            schemaId = schemaId,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceApiSchemaResultToKotlin(getWorkspaceApiSchemaPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceApiSchema].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceApiSchemaPlainArgs].
     * @return API Schema Contract details.
     */
    public suspend
    fun getWorkspaceApiSchema(argument: suspend GetWorkspaceApiSchemaPlainArgsBuilder.() -> Unit):
        GetWorkspaceApiSchemaResult {
        val builder = GetWorkspaceApiSchemaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceApiSchemaResultToKotlin(getWorkspaceApiSchemaPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Api Version Set specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return API Version Set Contract details.
     */
    public suspend fun getWorkspaceApiVersionSet(argument: GetWorkspaceApiVersionSetPlainArgs):
        GetWorkspaceApiVersionSetResult =
        getWorkspaceApiVersionSetResultToKotlin(getWorkspaceApiVersionSetPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceApiVersionSet].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param versionSetId Api Version Set identifier. Must be unique in the current API Management service instance.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return API Version Set Contract details.
     */
    public suspend fun getWorkspaceApiVersionSet(
        resourceGroupName: String,
        serviceName: String,
        versionSetId: String,
        workspaceId: String,
    ): GetWorkspaceApiVersionSetResult {
        val argument = GetWorkspaceApiVersionSetPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            versionSetId = versionSetId,
            workspaceId = workspaceId,
        )
        return getWorkspaceApiVersionSetResultToKotlin(getWorkspaceApiVersionSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceApiVersionSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceApiVersionSetPlainArgs].
     * @return API Version Set Contract details.
     */
    public suspend
    fun getWorkspaceApiVersionSet(argument: suspend GetWorkspaceApiVersionSetPlainArgsBuilder.() -> Unit):
        GetWorkspaceApiVersionSetResult {
        val builder = GetWorkspaceApiVersionSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceApiVersionSetResultToKotlin(getWorkspaceApiVersionSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the Schema specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Global Schema Contract details.
     */
    public suspend fun getWorkspaceGlobalSchema(argument: GetWorkspaceGlobalSchemaPlainArgs):
        GetWorkspaceGlobalSchemaResult =
        getWorkspaceGlobalSchemaResultToKotlin(getWorkspaceGlobalSchemaPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceGlobalSchema].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param schemaId Schema id identifier. Must be unique in the current API Management service instance.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Global Schema Contract details.
     */
    public suspend fun getWorkspaceGlobalSchema(
        resourceGroupName: String,
        schemaId: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceGlobalSchemaResult {
        val argument = GetWorkspaceGlobalSchemaPlainArgs(
            resourceGroupName = resourceGroupName,
            schemaId = schemaId,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceGlobalSchemaResultToKotlin(getWorkspaceGlobalSchemaPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceGlobalSchema].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceGlobalSchemaPlainArgs].
     * @return Global Schema Contract details.
     */
    public suspend
    fun getWorkspaceGlobalSchema(argument: suspend GetWorkspaceGlobalSchemaPlainArgsBuilder.() -> Unit):
        GetWorkspaceGlobalSchemaResult {
        val builder = GetWorkspaceGlobalSchemaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceGlobalSchemaResultToKotlin(getWorkspaceGlobalSchemaPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the group specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Contract details.
     */
    public suspend fun getWorkspaceGroup(argument: GetWorkspaceGroupPlainArgs):
        GetWorkspaceGroupResult =
        getWorkspaceGroupResultToKotlin(getWorkspaceGroupPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceGroup].
     * @param groupId Group identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Contract details.
     */
    public suspend fun getWorkspaceGroup(
        groupId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceGroupResult {
        val argument = GetWorkspaceGroupPlainArgs(
            groupId = groupId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceGroupResultToKotlin(getWorkspaceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceGroupPlainArgs].
     * @return Contract details.
     */
    public suspend
    fun getWorkspaceGroup(argument: suspend GetWorkspaceGroupPlainArgsBuilder.() -> Unit):
        GetWorkspaceGroupResult {
        val builder = GetWorkspaceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceGroupResultToKotlin(getWorkspaceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the named value specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return NamedValue details.
     */
    public suspend fun getWorkspaceNamedValue(argument: GetWorkspaceNamedValuePlainArgs):
        GetWorkspaceNamedValueResult =
        getWorkspaceNamedValueResultToKotlin(getWorkspaceNamedValuePlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceNamedValue].
     * @param namedValueId Identifier of the NamedValue.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return NamedValue details.
     */
    public suspend fun getWorkspaceNamedValue(
        namedValueId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceNamedValueResult {
        val argument = GetWorkspaceNamedValuePlainArgs(
            namedValueId = namedValueId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceNamedValueResultToKotlin(getWorkspaceNamedValuePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceNamedValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceNamedValuePlainArgs].
     * @return NamedValue details.
     */
    public suspend
    fun getWorkspaceNamedValue(argument: suspend GetWorkspaceNamedValuePlainArgsBuilder.() -> Unit):
        GetWorkspaceNamedValueResult {
        val builder = GetWorkspaceNamedValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceNamedValueResultToKotlin(getWorkspaceNamedValuePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy configuration at the API level.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend fun getWorkspacePolicy(argument: GetWorkspacePolicyPlainArgs):
        GetWorkspacePolicyResult =
        getWorkspacePolicyResultToKotlin(getWorkspacePolicyPlain(argument.toJava()).await())

    /**
     * @see [getWorkspacePolicy].
     * @param format Policy Export Format.
     * @param policyId The identifier of the Policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Policy Contract details.
     */
    public suspend fun getWorkspacePolicy(
        format: String? = null,
        policyId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspacePolicyResult {
        val argument = GetWorkspacePolicyPlainArgs(
            format = format,
            policyId = policyId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspacePolicyResultToKotlin(getWorkspacePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspacePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspacePolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend
    fun getWorkspacePolicy(argument: suspend GetWorkspacePolicyPlainArgsBuilder.() -> Unit):
        GetWorkspacePolicyResult {
        val builder = GetWorkspacePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspacePolicyResultToKotlin(getWorkspacePolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a policy fragment.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy fragment contract details.
     */
    public suspend fun getWorkspacePolicyFragment(argument: GetWorkspacePolicyFragmentPlainArgs):
        GetWorkspacePolicyFragmentResult =
        getWorkspacePolicyFragmentResultToKotlin(getWorkspacePolicyFragmentPlain(argument.toJava()).await())

    /**
     * @see [getWorkspacePolicyFragment].
     * @param format Policy fragment content format.
     * @param id A resource identifier.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Policy fragment contract details.
     */
    public suspend fun getWorkspacePolicyFragment(
        format: String? = null,
        id: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspacePolicyFragmentResult {
        val argument = GetWorkspacePolicyFragmentPlainArgs(
            format = format,
            id = id,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspacePolicyFragmentResultToKotlin(getWorkspacePolicyFragmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspacePolicyFragment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspacePolicyFragmentPlainArgs].
     * @return Policy fragment contract details.
     */
    public suspend
    fun getWorkspacePolicyFragment(argument: suspend GetWorkspacePolicyFragmentPlainArgsBuilder.() -> Unit):
        GetWorkspacePolicyFragmentResult {
        val builder = GetWorkspacePolicyFragmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspacePolicyFragmentResultToKotlin(getWorkspacePolicyFragmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the product specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Product details.
     */
    public suspend fun getWorkspaceProduct(argument: GetWorkspaceProductPlainArgs):
        GetWorkspaceProductResult =
        getWorkspaceProductResultToKotlin(getWorkspaceProductPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceProduct].
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Product details.
     */
    public suspend fun getWorkspaceProduct(
        productId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceProductResult {
        val argument = GetWorkspaceProductPlainArgs(
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceProductResultToKotlin(getWorkspaceProductPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceProduct].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceProductPlainArgs].
     * @return Product details.
     */
    public suspend
    fun getWorkspaceProduct(argument: suspend GetWorkspaceProductPlainArgsBuilder.() -> Unit):
        GetWorkspaceProductResult {
        val builder = GetWorkspaceProductPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceProductResultToKotlin(getWorkspaceProductPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the API link for the product.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Product-API link details.
     */
    public suspend fun getWorkspaceProductApiLink(argument: GetWorkspaceProductApiLinkPlainArgs):
        GetWorkspaceProductApiLinkResult =
        getWorkspaceProductApiLinkResultToKotlin(getWorkspaceProductApiLinkPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceProductApiLink].
     * @param apiLinkId Product-API link identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Product-API link details.
     */
    public suspend fun getWorkspaceProductApiLink(
        apiLinkId: String,
        productId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceProductApiLinkResult {
        val argument = GetWorkspaceProductApiLinkPlainArgs(
            apiLinkId = apiLinkId,
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceProductApiLinkResultToKotlin(getWorkspaceProductApiLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceProductApiLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceProductApiLinkPlainArgs].
     * @return Product-API link details.
     */
    public suspend
    fun getWorkspaceProductApiLink(argument: suspend GetWorkspaceProductApiLinkPlainArgsBuilder.() -> Unit):
        GetWorkspaceProductApiLinkResult {
        val builder = GetWorkspaceProductApiLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceProductApiLinkResultToKotlin(getWorkspaceProductApiLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the group link for the product.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Product-group link details.
     */
    public suspend fun getWorkspaceProductGroupLink(argument: GetWorkspaceProductGroupLinkPlainArgs):
        GetWorkspaceProductGroupLinkResult =
        getWorkspaceProductGroupLinkResultToKotlin(getWorkspaceProductGroupLinkPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceProductGroupLink].
     * @param groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Product-group link details.
     */
    public suspend fun getWorkspaceProductGroupLink(
        groupLinkId: String,
        productId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceProductGroupLinkResult {
        val argument = GetWorkspaceProductGroupLinkPlainArgs(
            groupLinkId = groupLinkId,
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceProductGroupLinkResultToKotlin(getWorkspaceProductGroupLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceProductGroupLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceProductGroupLinkPlainArgs].
     * @return Product-group link details.
     */
    public suspend
    fun getWorkspaceProductGroupLink(argument: suspend GetWorkspaceProductGroupLinkPlainArgsBuilder.() -> Unit):
        GetWorkspaceProductGroupLinkResult {
        val builder = GetWorkspaceProductGroupLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceProductGroupLinkResultToKotlin(getWorkspaceProductGroupLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the policy configuration at the Product level.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Policy Contract details.
     */
    public suspend fun getWorkspaceProductPolicy(argument: GetWorkspaceProductPolicyPlainArgs):
        GetWorkspaceProductPolicyResult =
        getWorkspaceProductPolicyResultToKotlin(getWorkspaceProductPolicyPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceProductPolicy].
     * @param format Policy Export Format.
     * @param policyId The identifier of the Policy.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Policy Contract details.
     */
    public suspend fun getWorkspaceProductPolicy(
        format: String? = null,
        policyId: String,
        productId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): GetWorkspaceProductPolicyResult {
        val argument = GetWorkspaceProductPolicyPlainArgs(
            format = format,
            policyId = policyId,
            productId = productId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return getWorkspaceProductPolicyResultToKotlin(getWorkspaceProductPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceProductPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceProductPolicyPlainArgs].
     * @return Policy Contract details.
     */
    public suspend
    fun getWorkspaceProductPolicy(argument: suspend GetWorkspaceProductPolicyPlainArgsBuilder.() -> Unit):
        GetWorkspaceProductPolicyResult {
        val builder = GetWorkspaceProductPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceProductPolicyResultToKotlin(getWorkspaceProductPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Subscription entity.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Subscription details.
     */
    public suspend fun getWorkspaceSubscription(argument: GetWorkspaceSubscriptionPlainArgs):
        GetWorkspaceSubscriptionResult =
        getWorkspaceSubscriptionResultToKotlin(getWorkspaceSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceSubscription].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Subscription details.
     */
    public suspend fun getWorkspaceSubscription(
        resourceGroupName: String,
        serviceName: String,
        sid: String,
        workspaceId: String,
    ): GetWorkspaceSubscriptionResult {
        val argument = GetWorkspaceSubscriptionPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            sid = sid,
            workspaceId = workspaceId,
        )
        return getWorkspaceSubscriptionResultToKotlin(getWorkspaceSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceSubscriptionPlainArgs].
     * @return Subscription details.
     */
    public suspend
    fun getWorkspaceSubscription(argument: suspend GetWorkspaceSubscriptionPlainArgsBuilder.() -> Unit):
        GetWorkspaceSubscriptionResult {
        val builder = GetWorkspaceSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceSubscriptionResultToKotlin(getWorkspaceSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the tag specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag Contract details.
     */
    public suspend fun getWorkspaceTag(argument: GetWorkspaceTagPlainArgs): GetWorkspaceTagResult =
        getWorkspaceTagResultToKotlin(getWorkspaceTagPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceTag].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Tag Contract details.
     */
    public suspend fun getWorkspaceTag(
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
        workspaceId: String,
    ): GetWorkspaceTagResult {
        val argument = GetWorkspaceTagPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
            workspaceId = workspaceId,
        )
        return getWorkspaceTagResultToKotlin(getWorkspaceTagPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceTag].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceTagPlainArgs].
     * @return Tag Contract details.
     */
    public suspend fun getWorkspaceTag(argument: suspend GetWorkspaceTagPlainArgsBuilder.() -> Unit):
        GetWorkspaceTagResult {
        val builder = GetWorkspaceTagPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceTagResultToKotlin(getWorkspaceTagPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the API link for the tag.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag-API link details.
     */
    public suspend fun getWorkspaceTagApiLink(argument: GetWorkspaceTagApiLinkPlainArgs):
        GetWorkspaceTagApiLinkResult =
        getWorkspaceTagApiLinkResultToKotlin(getWorkspaceTagApiLinkPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceTagApiLink].
     * @param apiLinkId Tag-API link identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Tag-API link details.
     */
    public suspend fun getWorkspaceTagApiLink(
        apiLinkId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
        workspaceId: String,
    ): GetWorkspaceTagApiLinkResult {
        val argument = GetWorkspaceTagApiLinkPlainArgs(
            apiLinkId = apiLinkId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
            workspaceId = workspaceId,
        )
        return getWorkspaceTagApiLinkResultToKotlin(getWorkspaceTagApiLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceTagApiLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceTagApiLinkPlainArgs].
     * @return Tag-API link details.
     */
    public suspend
    fun getWorkspaceTagApiLink(argument: suspend GetWorkspaceTagApiLinkPlainArgsBuilder.() -> Unit):
        GetWorkspaceTagApiLinkResult {
        val builder = GetWorkspaceTagApiLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceTagApiLinkResultToKotlin(getWorkspaceTagApiLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the operation link for the tag.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag-operation link details.
     */
    public suspend fun getWorkspaceTagOperationLink(argument: GetWorkspaceTagOperationLinkPlainArgs):
        GetWorkspaceTagOperationLinkResult =
        getWorkspaceTagOperationLinkResultToKotlin(getWorkspaceTagOperationLinkPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceTagOperationLink].
     * @param operationLinkId Tag-operation link identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Tag-operation link details.
     */
    public suspend fun getWorkspaceTagOperationLink(
        operationLinkId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
        workspaceId: String,
    ): GetWorkspaceTagOperationLinkResult {
        val argument = GetWorkspaceTagOperationLinkPlainArgs(
            operationLinkId = operationLinkId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
            workspaceId = workspaceId,
        )
        return getWorkspaceTagOperationLinkResultToKotlin(getWorkspaceTagOperationLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceTagOperationLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceTagOperationLinkPlainArgs].
     * @return Tag-operation link details.
     */
    public suspend
    fun getWorkspaceTagOperationLink(argument: suspend GetWorkspaceTagOperationLinkPlainArgsBuilder.() -> Unit):
        GetWorkspaceTagOperationLinkResult {
        val builder = GetWorkspaceTagOperationLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceTagOperationLinkResultToKotlin(getWorkspaceTagOperationLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the product link for the tag.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tag-product link details.
     */
    public suspend fun getWorkspaceTagProductLink(argument: GetWorkspaceTagProductLinkPlainArgs):
        GetWorkspaceTagProductLinkResult =
        getWorkspaceTagProductLinkResultToKotlin(getWorkspaceTagProductLinkPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceTagProductLink].
     * @param productLinkId Tag-product link identifier. Must be unique in the current API Management service instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param tagId Tag identifier. Must be unique in the current API Management service instance.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Tag-product link details.
     */
    public suspend fun getWorkspaceTagProductLink(
        productLinkId: String,
        resourceGroupName: String,
        serviceName: String,
        tagId: String,
        workspaceId: String,
    ): GetWorkspaceTagProductLinkResult {
        val argument = GetWorkspaceTagProductLinkPlainArgs(
            productLinkId = productLinkId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            tagId = tagId,
            workspaceId = workspaceId,
        )
        return getWorkspaceTagProductLinkResultToKotlin(getWorkspaceTagProductLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceTagProductLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;GetWorkspaceTagProductLinkPlainArgs].
     * @return Tag-product link details.
     */
    public suspend
    fun getWorkspaceTagProductLink(argument: suspend GetWorkspaceTagProductLinkPlainArgsBuilder.() -> Unit):
        GetWorkspaceTagProductLinkResult {
        val builder = GetWorkspaceTagProductLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceTagProductLinkResultToKotlin(getWorkspaceTagProductLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the client secret details of the authorization server.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return OAuth Server Secrets Contract.
     */
    public suspend
    fun listAuthorizationServerSecrets(argument: ListAuthorizationServerSecretsPlainArgs):
        ListAuthorizationServerSecretsResult =
        listAuthorizationServerSecretsResultToKotlin(listAuthorizationServerSecretsPlain(argument.toJava()).await())

    /**
     * @see [listAuthorizationServerSecrets].
     * @param authsid Identifier of the authorization server.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return OAuth Server Secrets Contract.
     */
    public suspend fun listAuthorizationServerSecrets(
        authsid: String,
        resourceGroupName: String,
        serviceName: String,
    ): ListAuthorizationServerSecretsResult {
        val argument = ListAuthorizationServerSecretsPlainArgs(
            authsid = authsid,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listAuthorizationServerSecretsResultToKotlin(listAuthorizationServerSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listAuthorizationServerSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListAuthorizationServerSecretsPlainArgs].
     * @return OAuth Server Secrets Contract.
     */
    public suspend
    fun listAuthorizationServerSecrets(argument: suspend ListAuthorizationServerSecretsPlainArgsBuilder.() -> Unit):
        ListAuthorizationServerSecretsResult {
        val builder = ListAuthorizationServerSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAuthorizationServerSecretsResultToKotlin(listAuthorizationServerSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the secret validation key of the DelegationSettings.
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listDelegationSettingSecrets(argument: ListDelegationSettingSecretsPlainArgs):
        ListDelegationSettingSecretsResult =
        listDelegationSettingSecretsResultToKotlin(listDelegationSettingSecretsPlain(argument.toJava()).await())

    /**
     * @see [listDelegationSettingSecrets].
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the API Management service.
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listDelegationSettingSecrets(resourceGroupName: String, serviceName: String):
        ListDelegationSettingSecretsResult {
        val argument = ListDelegationSettingSecretsPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listDelegationSettingSecretsResultToKotlin(listDelegationSettingSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDelegationSettingSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListDelegationSettingSecretsPlainArgs].
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend
    fun listDelegationSettingSecrets(argument: suspend ListDelegationSettingSecretsPlainArgsBuilder.() -> Unit):
        ListDelegationSettingSecretsResult {
        val builder = ListDelegationSettingSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDelegationSettingSecretsResultToKotlin(listDelegationSettingSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Create new debug credentials for gateway.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-05-01-preview.
     * @param argument null
     * @return Gateway debug credentials.
     */
    public suspend fun listGatewayDebugCredentials(argument: ListGatewayDebugCredentialsPlainArgs):
        ListGatewayDebugCredentialsResult =
        listGatewayDebugCredentialsResultToKotlin(listGatewayDebugCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listGatewayDebugCredentials].
     * @param apiId Full resource Id of an API.
     * @param credentialsExpireAfter Credentials expiration in ISO8601 format. Maximum duration of the credentials is PT1H. When property is not specified, them value PT1H is used.
     * @param gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     * @param purposes Purposes of debug credential.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Gateway debug credentials.
     */
    public suspend fun listGatewayDebugCredentials(
        apiId: String,
        credentialsExpireAfter: String? = null,
        gatewayId: String,
        purposes: List<Either<String, GatewayListDebugCredentialsContractPurpose>>,
        resourceGroupName: String,
        serviceName: String,
    ): ListGatewayDebugCredentialsResult {
        val argument = ListGatewayDebugCredentialsPlainArgs(
            apiId = apiId,
            credentialsExpireAfter = credentialsExpireAfter,
            gatewayId = gatewayId,
            purposes = purposes,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listGatewayDebugCredentialsResultToKotlin(listGatewayDebugCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listGatewayDebugCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListGatewayDebugCredentialsPlainArgs].
     * @return Gateway debug credentials.
     */
    public suspend
    fun listGatewayDebugCredentials(argument: suspend ListGatewayDebugCredentialsPlainArgsBuilder.() -> Unit):
        ListGatewayDebugCredentialsResult {
        val builder = ListGatewayDebugCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGatewayDebugCredentialsResultToKotlin(listGatewayDebugCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves gateway keys.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Gateway authentication keys.
     */
    public suspend fun listGatewayKeys(argument: ListGatewayKeysPlainArgs): ListGatewayKeysResult =
        listGatewayKeysResultToKotlin(listGatewayKeysPlain(argument.toJava()).await())

    /**
     * @see [listGatewayKeys].
     * @param gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Gateway authentication keys.
     */
    public suspend fun listGatewayKeys(
        gatewayId: String,
        resourceGroupName: String,
        serviceName: String,
    ): ListGatewayKeysResult {
        val argument = ListGatewayKeysPlainArgs(
            gatewayId = gatewayId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listGatewayKeysResultToKotlin(listGatewayKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listGatewayKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListGatewayKeysPlainArgs].
     * @return Gateway authentication keys.
     */
    public suspend fun listGatewayKeys(argument: suspend ListGatewayKeysPlainArgsBuilder.() -> Unit):
        ListGatewayKeysResult {
        val builder = ListGatewayKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGatewayKeysResultToKotlin(listGatewayKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the client secret details of the Identity Provider.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listIdentityProviderSecrets(argument: ListIdentityProviderSecretsPlainArgs):
        ListIdentityProviderSecretsResult =
        listIdentityProviderSecretsResultToKotlin(listIdentityProviderSecretsPlain(argument.toJava()).await())

    /**
     * @see [listIdentityProviderSecrets].
     * @param identityProviderName Identity Provider Type identifier.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listIdentityProviderSecrets(
        identityProviderName: String,
        resourceGroupName: String,
        serviceName: String,
    ): ListIdentityProviderSecretsResult {
        val argument = ListIdentityProviderSecretsPlainArgs(
            identityProviderName = identityProviderName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listIdentityProviderSecretsResultToKotlin(listIdentityProviderSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listIdentityProviderSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListIdentityProviderSecretsPlainArgs].
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend
    fun listIdentityProviderSecrets(argument: suspend ListIdentityProviderSecretsPlainArgsBuilder.() -> Unit):
        ListIdentityProviderSecretsResult {
        val builder = ListIdentityProviderSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIdentityProviderSecretsResultToKotlin(listIdentityProviderSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the secret of the named value specified by its identifier.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listNamedValue(argument: ListNamedValuePlainArgs): ListNamedValueResult =
        listNamedValueResultToKotlin(listNamedValuePlain(argument.toJava()).await())

    /**
     * @see [listNamedValue].
     * @param namedValueId Identifier of the NamedValue.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listNamedValue(
        namedValueId: String,
        resourceGroupName: String,
        serviceName: String,
    ): ListNamedValueResult {
        val argument = ListNamedValuePlainArgs(
            namedValueId = namedValueId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listNamedValueResultToKotlin(listNamedValuePlain(argument.toJava()).await())
    }

    /**
     * @see [listNamedValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListNamedValuePlainArgs].
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listNamedValue(argument: suspend ListNamedValuePlainArgsBuilder.() -> Unit):
        ListNamedValueResult {
        val builder = ListNamedValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNamedValueResultToKotlin(listNamedValuePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the client secret details of the OpenID Connect Provider.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend
    fun listOpenIdConnectProviderSecrets(argument: ListOpenIdConnectProviderSecretsPlainArgs):
        ListOpenIdConnectProviderSecretsResult =
        listOpenIdConnectProviderSecretsResultToKotlin(listOpenIdConnectProviderSecretsPlain(argument.toJava()).await())

    /**
     * @see [listOpenIdConnectProviderSecrets].
     * @param opid Identifier of the OpenID Connect Provider.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listOpenIdConnectProviderSecrets(
        opid: String,
        resourceGroupName: String,
        serviceName: String,
    ): ListOpenIdConnectProviderSecretsResult {
        val argument = ListOpenIdConnectProviderSecretsPlainArgs(
            opid = opid,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listOpenIdConnectProviderSecretsResultToKotlin(listOpenIdConnectProviderSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listOpenIdConnectProviderSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListOpenIdConnectProviderSecretsPlainArgs].
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend
    fun listOpenIdConnectProviderSecrets(argument: suspend ListOpenIdConnectProviderSecretsPlainArgsBuilder.() -> Unit):
        ListOpenIdConnectProviderSecretsResult {
        val builder = ListOpenIdConnectProviderSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listOpenIdConnectProviderSecretsResultToKotlin(listOpenIdConnectProviderSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists policy resources that reference the policy fragment.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A collection of resources.
     */
    public suspend fun listPolicyFragmentReferences(argument: ListPolicyFragmentReferencesPlainArgs):
        ListPolicyFragmentReferencesResult =
        listPolicyFragmentReferencesResultToKotlin(listPolicyFragmentReferencesPlain(argument.toJava()).await())

    /**
     * @see [listPolicyFragmentReferences].
     * @param id A resource identifier.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param skip Number of records to skip.
     * @param top Number of records to return.
     * @return A collection of resources.
     */
    public suspend fun listPolicyFragmentReferences(
        id: String,
        resourceGroupName: String,
        serviceName: String,
        skip: Int? = null,
        top: Int? = null,
    ): ListPolicyFragmentReferencesResult {
        val argument = ListPolicyFragmentReferencesPlainArgs(
            id = id,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            skip = skip,
            top = top,
        )
        return listPolicyFragmentReferencesResultToKotlin(listPolicyFragmentReferencesPlain(argument.toJava()).await())
    }

    /**
     * @see [listPolicyFragmentReferences].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListPolicyFragmentReferencesPlainArgs].
     * @return A collection of resources.
     */
    public suspend
    fun listPolicyFragmentReferences(argument: suspend ListPolicyFragmentReferencesPlainArgsBuilder.() -> Unit):
        ListPolicyFragmentReferencesResult {
        val builder = ListPolicyFragmentReferencesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listPolicyFragmentReferencesResultToKotlin(listPolicyFragmentReferencesPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Subscription keys.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Subscription keys.
     */
    public suspend fun listSubscriptionSecrets(argument: ListSubscriptionSecretsPlainArgs):
        ListSubscriptionSecretsResult =
        listSubscriptionSecretsResultToKotlin(listSubscriptionSecretsPlain(argument.toJava()).await())

    /**
     * @see [listSubscriptionSecrets].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
     * @return Subscription keys.
     */
    public suspend fun listSubscriptionSecrets(
        resourceGroupName: String,
        serviceName: String,
        sid: String,
    ): ListSubscriptionSecretsResult {
        val argument = ListSubscriptionSecretsPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            sid = sid,
        )
        return listSubscriptionSecretsResultToKotlin(listSubscriptionSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listSubscriptionSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListSubscriptionSecretsPlainArgs].
     * @return Subscription keys.
     */
    public suspend
    fun listSubscriptionSecrets(argument: suspend ListSubscriptionSecretsPlainArgsBuilder.() -> Unit):
        ListSubscriptionSecretsResult {
        val builder = ListSubscriptionSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSubscriptionSecretsResultToKotlin(listSubscriptionSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get tenant access information details.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Tenant access information contract of the API Management service.
     */
    public suspend fun listTenantAccessSecrets(argument: ListTenantAccessSecretsPlainArgs):
        ListTenantAccessSecretsResult =
        listTenantAccessSecretsResultToKotlin(listTenantAccessSecretsPlain(argument.toJava()).await())

    /**
     * @see [listTenantAccessSecrets].
     * @param accessName The identifier of the Access configuration.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return Tenant access information contract of the API Management service.
     */
    public suspend fun listTenantAccessSecrets(
        accessName: String,
        resourceGroupName: String,
        serviceName: String,
    ): ListTenantAccessSecretsResult {
        val argument = ListTenantAccessSecretsPlainArgs(
            accessName = accessName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listTenantAccessSecretsResultToKotlin(listTenantAccessSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listTenantAccessSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListTenantAccessSecretsPlainArgs].
     * @return Tenant access information contract of the API Management service.
     */
    public suspend
    fun listTenantAccessSecrets(argument: suspend ListTenantAccessSecretsPlainArgsBuilder.() -> Unit):
        ListTenantAccessSecretsResult {
        val builder = ListTenantAccessSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listTenantAccessSecretsResultToKotlin(listTenantAccessSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the secret of the named value specified by its identifier.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listWorkspaceNamedValue(argument: ListWorkspaceNamedValuePlainArgs):
        ListWorkspaceNamedValueResult =
        listWorkspaceNamedValueResultToKotlin(listWorkspaceNamedValuePlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceNamedValue].
     * @param namedValueId Identifier of the NamedValue.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend fun listWorkspaceNamedValue(
        namedValueId: String,
        resourceGroupName: String,
        serviceName: String,
        workspaceId: String,
    ): ListWorkspaceNamedValueResult {
        val argument = ListWorkspaceNamedValuePlainArgs(
            namedValueId = namedValueId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
        return listWorkspaceNamedValueResultToKotlin(listWorkspaceNamedValuePlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceNamedValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListWorkspaceNamedValuePlainArgs].
     * @return Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    public suspend
    fun listWorkspaceNamedValue(argument: suspend ListWorkspaceNamedValuePlainArgsBuilder.() -> Unit):
        ListWorkspaceNamedValueResult {
        val builder = ListWorkspaceNamedValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceNamedValueResultToKotlin(listWorkspaceNamedValuePlain(builtArgument.toJava()).await())
    }

    /**
     * Lists policy resources that reference the policy fragment.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A collection of resources.
     */
    public suspend
    fun listWorkspacePolicyFragmentReferences(argument: ListWorkspacePolicyFragmentReferencesPlainArgs):
        ListWorkspacePolicyFragmentReferencesResult =
        listWorkspacePolicyFragmentReferencesResultToKotlin(listWorkspacePolicyFragmentReferencesPlain(argument.toJava()).await())

    /**
     * @see [listWorkspacePolicyFragmentReferences].
     * @param id A resource identifier.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param skip Number of records to skip.
     * @param top Number of records to return.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return A collection of resources.
     */
    public suspend fun listWorkspacePolicyFragmentReferences(
        id: String,
        resourceGroupName: String,
        serviceName: String,
        skip: Int? = null,
        top: Int? = null,
        workspaceId: String,
    ): ListWorkspacePolicyFragmentReferencesResult {
        val argument = ListWorkspacePolicyFragmentReferencesPlainArgs(
            id = id,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            skip = skip,
            top = top,
            workspaceId = workspaceId,
        )
        return listWorkspacePolicyFragmentReferencesResultToKotlin(listWorkspacePolicyFragmentReferencesPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspacePolicyFragmentReferences].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListWorkspacePolicyFragmentReferencesPlainArgs].
     * @return A collection of resources.
     */
    public suspend
    fun listWorkspacePolicyFragmentReferences(argument: suspend ListWorkspacePolicyFragmentReferencesPlainArgsBuilder.() -> Unit):
        ListWorkspacePolicyFragmentReferencesResult {
        val builder = ListWorkspacePolicyFragmentReferencesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspacePolicyFragmentReferencesResultToKotlin(listWorkspacePolicyFragmentReferencesPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Subscription keys.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Subscription keys.
     */
    public suspend
    fun listWorkspaceSubscriptionSecrets(argument: ListWorkspaceSubscriptionSecretsPlainArgs):
        ListWorkspaceSubscriptionSecretsResult =
        listWorkspaceSubscriptionSecretsResultToKotlin(listWorkspaceSubscriptionSecretsPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceSubscriptionSecrets].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @return Subscription keys.
     */
    public suspend fun listWorkspaceSubscriptionSecrets(
        resourceGroupName: String,
        serviceName: String,
        sid: String,
        workspaceId: String,
    ): ListWorkspaceSubscriptionSecretsResult {
        val argument = ListWorkspaceSubscriptionSecretsPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            sid = sid,
            workspaceId = workspaceId,
        )
        return listWorkspaceSubscriptionSecretsResultToKotlin(listWorkspaceSubscriptionSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceSubscriptionSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;apimanagement&#46;kotlin&#46;inputs&#46;ListWorkspaceSubscriptionSecretsPlainArgs].
     * @return Subscription keys.
     */
    public suspend
    fun listWorkspaceSubscriptionSecrets(argument: suspend ListWorkspaceSubscriptionSecretsPlainArgsBuilder.() -> Unit):
        ListWorkspaceSubscriptionSecretsResult {
        val builder = ListWorkspaceSubscriptionSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceSubscriptionSecretsResultToKotlin(listWorkspaceSubscriptionSecretsPlain(builtArgument.toJava()).await())
    }
}
