@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ContentItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Content type contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateContentTypeContentItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentItem = new AzureNative.ApiManagement.ContentItem("contentItem", new()
 *     {
 *         ContentItemId = "4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8",
 *         ContentTypeId = "page",
 *         Properties = new Dictionary<string, object?>
 *         {
 *             ["en_us"] = new Dictionary<string, object?>
 *             {
 *                 ["description"] = "Short story about the company.",
 *                 ["documentId"] = "contentTypes/document/contentItems/4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8",
 *                 ["keywords"] = "company, about",
 *                 ["permalink"] = "/about",
 *                 ["title"] = "About",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewContentItem(ctx, "contentItem", &apimanagement.ContentItemArgs{
 * 			ContentItemId: pulumi.String("4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8"),
 * 			ContentTypeId: pulumi.String("page"),
 * 			Properties: pulumi.Any(map[string]interface{}{
 * 				"en_us": map[string]interface{}{
 * 					"description": "Short story about the company.",
 * 					"documentId":  "contentTypes/document/contentItems/4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8",
 * 					"keywords":    "company, about",
 * 					"permalink":   "/about",
 * 					"title":       "About",
 * 				},
 * 			}),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ContentItem;
 * import com.pulumi.azurenative.apimanagement.ContentItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentItem = new ContentItem("contentItem", ContentItemArgs.builder()
 *             .contentItemId("4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8")
 *             .contentTypeId("page")
 *             .properties(Map.of("en_us", Map.ofEntries(
 *                 Map.entry("description", "Short story about the company."),
 *                 Map.entry("documentId", "contentTypes/document/contentItems/4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8"),
 *                 Map.entry("keywords", "company, about"),
 *                 Map.entry("permalink", "/about"),
 *                 Map.entry("title", "About")
 *             )))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ContentItem 4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/contentTypes/{contentTypeId}/contentItems/{contentItemId}
 * ```
 * @property contentItemId Content item identifier.
 * @property contentTypeId Content type identifier.
 * @property properties Properties of the content item.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class ContentItemArgs(
    public val contentItemId: Output<String>? = null,
    public val contentTypeId: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ContentItemArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ContentItemArgs =
        com.pulumi.azurenative.apimanagement.ContentItemArgs.builder()
            .contentItemId(contentItemId?.applyValue({ args0 -> args0 }))
            .contentTypeId(contentTypeId?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentItemArgs].
 */
@PulumiTagMarker
public class ContentItemArgsBuilder internal constructor() {
    private var contentItemId: Output<String>? = null

    private var contentTypeId: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Content item identifier.
     */
    @JvmName("ocdaykcieimgpcew")
    public suspend fun contentItemId(`value`: Output<String>) {
        this.contentItemId = value
    }

    /**
     * @param value Content type identifier.
     */
    @JvmName("hmvsyxqfvlxgespl")
    public suspend fun contentTypeId(`value`: Output<String>) {
        this.contentTypeId = value
    }

    /**
     * @param value Properties of the content item.
     */
    @JvmName("pdtcsukfflwpfkiq")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jthvvbxnswtcvaci")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xhnpgbpfkjwqaafg")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Content item identifier.
     */
    @JvmName("pcyudtfjbnelgdqa")
    public suspend fun contentItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentItemId = mapped
    }

    /**
     * @param value Content type identifier.
     */
    @JvmName("crxmvpmfyrvpkixk")
    public suspend fun contentTypeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypeId = mapped
    }

    /**
     * @param value Properties of the content item.
     */
    @JvmName("efaacnfbpukyudtl")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tacuheaknhcarkbi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("riunrdohqhleqbma")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ContentItemArgs = ContentItemArgs(
        contentItemId = contentItemId,
        contentTypeId = contentTypeId,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
