@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.GatewayCertificateAuthorityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gateway certificate authority details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGatewayCertificateAuthority
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayCertificateAuthority = new AzureNative.ApiManagement.GatewayCertificateAuthority("gatewayCertificateAuthority", new()
 *     {
 *         CertificateId = "cert1",
 *         GatewayId = "gw1",
 *         IsTrusted = false,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGatewayCertificateAuthority(ctx, "gatewayCertificateAuthority", &apimanagement.GatewayCertificateAuthorityArgs{
 * 			CertificateId:     pulumi.String("cert1"),
 * 			GatewayId:         pulumi.String("gw1"),
 * 			IsTrusted:         pulumi.Bool(false),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GatewayCertificateAuthority;
 * import com.pulumi.azurenative.apimanagement.GatewayCertificateAuthorityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayCertificateAuthority = new GatewayCertificateAuthority("gatewayCertificateAuthority", GatewayCertificateAuthorityArgs.builder()
 *             .certificateId("cert1")
 *             .gatewayId("gw1")
 *             .isTrusted(false)
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GatewayCertificateAuthority cert1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/gateways/{gatewayId}/certificateAuthorities/{certificateId}
 * ```
 * @property certificateId Identifier of the certificate entity. Must be unique in the current API Management service instance.
 * @property gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
 * @property isTrusted Determines whether certificate authority is trusted.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GatewayCertificateAuthorityArgs(
    public val certificateId: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val isTrusted: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.GatewayCertificateAuthorityArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.GatewayCertificateAuthorityArgs =
        com.pulumi.azurenative.apimanagement.GatewayCertificateAuthorityArgs.builder()
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .isTrusted(isTrusted?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayCertificateAuthorityArgs].
 */
@PulumiTagMarker
public class GatewayCertificateAuthorityArgsBuilder internal constructor() {
    private var certificateId: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var isTrusted: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Identifier of the certificate entity. Must be unique in the current API Management service instance.
     */
    @JvmName("bqypiyqypmrcrubg")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("ftnsjresejnsxboj")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value Determines whether certificate authority is trusted.
     */
    @JvmName("dgrqfsxgannerqrm")
    public suspend fun isTrusted(`value`: Output<Boolean>) {
        this.isTrusted = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lhgsakugrfnipcal")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("iyubfwftmkfvrlqv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Identifier of the certificate entity. Must be unique in the current API Management service instance.
     */
    @JvmName("otwwgfcoqytrxylw")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("ktehppxsaergpqvh")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value Determines whether certificate authority is trusted.
     */
    @JvmName("hdtnliqbpssklaoc")
    public suspend fun isTrusted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isTrusted = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lmdnfcbgmqfjossj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("dhfjhrsgtgiouyjv")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): GatewayCertificateAuthorityArgs = GatewayCertificateAuthorityArgs(
        certificateId = certificateId,
        gatewayId = gatewayId,
        isTrusted = isTrusted,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
