@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GatewayHostnameConfiguration].
 */
@PulumiTagMarker
public class GatewayHostnameConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayHostnameConfigurationArgs = GatewayHostnameConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayHostnameConfigurationArgsBuilder.() -> Unit) {
        val builder = GatewayHostnameConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayHostnameConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.GatewayHostnameConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayHostnameConfiguration(builtJavaResource)
    }
}

/**
 * Gateway hostname configuration details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGatewayHostnameConfiguration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayHostnameConfiguration = new AzureNative.ApiManagement.GatewayHostnameConfiguration("gatewayHostnameConfiguration", new()
 *     {
 *         CertificateId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1",
 *         GatewayId = "gw1",
 *         HcId = "default",
 *         Hostname = "*",
 *         Http2Enabled = true,
 *         NegotiateClientCertificate = false,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Tls10Enabled = false,
 *         Tls11Enabled = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGatewayHostnameConfiguration(ctx, "gatewayHostnameConfiguration", &apimanagement.GatewayHostnameConfigurationArgs{
 * 			CertificateId:              pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1"),
 * 			GatewayId:                  pulumi.String("gw1"),
 * 			HcId:                       pulumi.String("default"),
 * 			Hostname:                   pulumi.String("*"),
 * 			Http2Enabled:               pulumi.Bool(true),
 * 			NegotiateClientCertificate: pulumi.Bool(false),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			ServiceName:                pulumi.String("apimService1"),
 * 			Tls10Enabled:               pulumi.Bool(false),
 * 			Tls11Enabled:               pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GatewayHostnameConfiguration;
 * import com.pulumi.azurenative.apimanagement.GatewayHostnameConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayHostnameConfiguration = new GatewayHostnameConfiguration("gatewayHostnameConfiguration", GatewayHostnameConfigurationArgs.builder()
 *             .certificateId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1")
 *             .gatewayId("gw1")
 *             .hcId("default")
 *             .hostname("*")
 *             .http2Enabled(true)
 *             .negotiateClientCertificate(false)
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tls10Enabled(false)
 *             .tls11Enabled(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GatewayHostnameConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/gateways/{gatewayId}/hostnameConfigurations/{hcId}
 * ```
 */
public class GatewayHostnameConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.GatewayHostnameConfiguration,
) : KotlinCustomResource(javaResource, GatewayHostnameConfigurationMapper) {
    /**
     * Identifier of Certificate entity that will be used for TLS connection establishment
     */
    public val certificateId: Output<String>?
        get() = javaResource.certificateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Hostname value. Supports valid domain name, partial or full wildcard
     */
    public val hostname: Output<String>?
        get() = javaResource.hostname().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies if HTTP/2.0 is supported
     */
    public val http2Enabled: Output<Boolean>?
        get() = javaResource.http2Enabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines whether gateway requests client certificate
     */
    public val negotiateClientCertificate: Output<Boolean>?
        get() = javaResource.negotiateClientCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if TLS 1.0 is supported
     */
    public val tls10Enabled: Output<Boolean>?
        get() = javaResource.tls10Enabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if TLS 1.1 is supported
     */
    public val tls11Enabled: Output<Boolean>?
        get() = javaResource.tls11Enabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GatewayHostnameConfigurationMapper : ResourceMapper<GatewayHostnameConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.GatewayHostnameConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): GatewayHostnameConfiguration =
        GatewayHostnameConfiguration(
            javaResource as
                com.pulumi.azurenative.apimanagement.GatewayHostnameConfiguration,
        )
}

/**
 * @see [GatewayHostnameConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayHostnameConfiguration].
 */
public suspend fun gatewayHostnameConfiguration(
    name: String,
    block: suspend GatewayHostnameConfigurationResourceBuilder.() -> Unit,
):
    GatewayHostnameConfiguration {
    val builder = GatewayHostnameConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayHostnameConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayHostnameConfiguration(name: String): GatewayHostnameConfiguration {
    val builder = GatewayHostnameConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
