@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.GraphQLApiResolverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * GraphQL API Resolver details.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGraphQLApiResolver
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var graphQLApiResolver = new AzureNative.ApiManagement.GraphQLApiResolver("graphQLApiResolver", new()
 *     {
 *         ApiId = "someAPI",
 *         Description = "A GraphQL Resolver example",
 *         DisplayName = "Query Users",
 *         Path = "Query/users",
 *         ResolverId = "newResolver",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGraphQLApiResolver(ctx, "graphQLApiResolver", &apimanagement.GraphQLApiResolverArgs{
 * 			ApiId:             pulumi.String("someAPI"),
 * 			Description:       pulumi.String("A GraphQL Resolver example"),
 * 			DisplayName:       pulumi.String("Query Users"),
 * 			Path:              pulumi.String("Query/users"),
 * 			ResolverId:        pulumi.String("newResolver"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GraphQLApiResolver;
 * import com.pulumi.azurenative.apimanagement.GraphQLApiResolverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var graphQLApiResolver = new GraphQLApiResolver("graphQLApiResolver", GraphQLApiResolverArgs.builder()
 *             .apiId("someAPI")
 *             .description("A GraphQL Resolver example")
 *             .displayName("Query Users")
 *             .path("Query/users")
 *             .resolverId("newResolver")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GraphQLApiResolver newResolver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}
 * ```
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property description Description of the resolver. May include HTML formatting tags.
 * @property displayName Resolver Name.
 * @property path Path is type/field being resolved.
 * @property resolverId Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GraphQLApiResolverArgs(
    public val apiId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val path: Output<String>? = null,
    public val resolverId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.GraphQLApiResolverArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.GraphQLApiResolverArgs =
        com.pulumi.azurenative.apimanagement.GraphQLApiResolverArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .resolverId(resolverId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiResolverArgs].
 */
@PulumiTagMarker
public class GraphQLApiResolverArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var path: Output<String>? = null

    private var resolverId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("rlhepygnhuvfevlx")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Description of the resolver. May include HTML formatting tags.
     */
    @JvmName("krviihsrfxmcxute")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Resolver Name.
     */
    @JvmName("btwmggvforexsyji")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Path is type/field being resolved.
     */
    @JvmName("fhgrcpfkkwexxycf")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
     */
    @JvmName("ilfotjiklagccwpb")
    public suspend fun resolverId(`value`: Output<String>) {
        this.resolverId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dbfdkymjpqhytspt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("rlnfqyixrwmnqegh")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("pxyxpihqdqlsxfde")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Description of the resolver. May include HTML formatting tags.
     */
    @JvmName("bgrgknibusbafnhe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Resolver Name.
     */
    @JvmName("oksxbhfyeqnlmxgo")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Path is type/field being resolved.
     */
    @JvmName("wvnloflpusbrknou")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
     */
    @JvmName("nuqsiammxsknlscm")
    public suspend fun resolverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolverId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("smymxqhvyacqbgmi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("yheqjpmsdtccyqjt")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): GraphQLApiResolverArgs = GraphQLApiResolverArgs(
        apiId = apiId,
        description = description,
        displayName = displayName,
        path = path,
        resolverId = resolverId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
