@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.KeyVaultContractPropertiesResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.KeyVaultContractPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [NamedValue].
 */
@PulumiTagMarker
public class NamedValueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamedValueArgs = NamedValueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamedValueArgsBuilder.() -> Unit) {
        val builder = NamedValueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NamedValue {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.NamedValue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NamedValue(builtJavaResource)
    }
}

/**
 * NamedValue details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateNamedValue
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namedValue = new AzureNative.ApiManagement.NamedValue("namedValue", new()
 *     {
 *         DisplayName = "prop3name",
 *         NamedValueId = "testprop2",
 *         ResourceGroupName = "rg1",
 *         Secret = false,
 *         ServiceName = "apimService1",
 *         Tags = new[]
 *         {
 *             "foo",
 *             "bar",
 *         },
 *         Value = "propValue",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewNamedValue(ctx, "namedValue", &apimanagement.NamedValueArgs{
 * 			DisplayName:       pulumi.String("prop3name"),
 * 			NamedValueId:      pulumi.String("testprop2"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Secret:            pulumi.Bool(false),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Tags: pulumi.StringArray{
 * 				pulumi.String("foo"),
 * 				pulumi.String("bar"),
 * 			},
 * 			Value: pulumi.String("propValue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.NamedValue;
 * import com.pulumi.azurenative.apimanagement.NamedValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namedValue = new NamedValue("namedValue", NamedValueArgs.builder()
 *             .displayName("prop3name")
 *             .namedValueId("testprop2")
 *             .resourceGroupName("rg1")
 *             .secret(false)
 *             .serviceName("apimService1")
 *             .tags(
 *                 "foo",
 *                 "bar")
 *             .value("propValue")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateNamedValueWithKeyVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namedValue = new AzureNative.ApiManagement.NamedValue("namedValue", new()
 *     {
 *         DisplayName = "prop6namekv",
 *         KeyVault = new AzureNative.ApiManagement.Inputs.KeyVaultContractCreatePropertiesArgs
 *         {
 *             IdentityClientId = "ceaa6b06-c00f-43ef-99ac-f53d1fe876a0",
 *             SecretIdentifier = "https://contoso.vault.azure.net/secrets/aadSecret",
 *         },
 *         NamedValueId = "testprop6",
 *         ResourceGroupName = "rg1",
 *         Secret = true,
 *         ServiceName = "apimService1",
 *         Tags = new[]
 *         {
 *             "foo",
 *             "bar",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewNamedValue(ctx, "namedValue", &apimanagement.NamedValueArgs{
 * 			DisplayName: pulumi.String("prop6namekv"),
 * 			KeyVault: &apimanagement.KeyVaultContractCreatePropertiesArgs{
 * 				IdentityClientId: pulumi.String("ceaa6b06-c00f-43ef-99ac-f53d1fe876a0"),
 * 				SecretIdentifier: pulumi.String("https://contoso.vault.azure.net/secrets/aadSecret"),
 * 			},
 * 			NamedValueId:      pulumi.String("testprop6"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Secret:            pulumi.Bool(true),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Tags: pulumi.StringArray{
 * 				pulumi.String("foo"),
 * 				pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.NamedValue;
 * import com.pulumi.azurenative.apimanagement.NamedValueArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.KeyVaultContractCreatePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namedValue = new NamedValue("namedValue", NamedValueArgs.builder()
 *             .displayName("prop6namekv")
 *             .keyVault(KeyVaultContractCreatePropertiesArgs.builder()
 *                 .identityClientId("ceaa6b06-c00f-43ef-99ac-f53d1fe876a0")
 *                 .secretIdentifier("https://contoso.vault.azure.net/secrets/aadSecret")
 *                 .build())
 *             .namedValueId("testprop6")
 *             .resourceGroupName("rg1")
 *             .secret(true)
 *             .serviceName("apimService1")
 *             .tags(
 *                 "foo",
 *                 "bar")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:NamedValue testprop6 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues/{namedValueId}
 * ```
 */
public class NamedValue internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.NamedValue,
) : KotlinCustomResource(javaResource, NamedValueMapper) {
    /**
     * Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * KeyVault location details of the namedValue.
     */
    public val keyVault: Output<KeyVaultContractPropertiesResponse>?
        get() = javaResource.keyVault().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines whether the value is a secret and should be encrypted or not. Default value is false.
     */
    public val secret: Output<Boolean>?
        get() = javaResource.secret().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Optional tags that when provided can be used to filter the NamedValue list.
     */
    public val tags: Output<List<String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object NamedValueMapper : ResourceMapper<NamedValue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.NamedValue::class == javaResource::class

    override fun map(javaResource: Resource): NamedValue = NamedValue(
        javaResource as
            com.pulumi.azurenative.apimanagement.NamedValue,
    )
}

/**
 * @see [NamedValue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamedValue].
 */
public suspend fun namedValue(name: String, block: suspend NamedValueResourceBuilder.() -> Unit):
    NamedValue {
    val builder = NamedValueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamedValue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namedValue(name: String): NamedValue {
    val builder = NamedValueResourceBuilder()
    builder.name(name)
    return builder.build()
}
