@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NotificationRecipientEmail].
 */
@PulumiTagMarker
public class NotificationRecipientEmailResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationRecipientEmailArgs = NotificationRecipientEmailArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationRecipientEmailArgsBuilder.() -> Unit) {
        val builder = NotificationRecipientEmailArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NotificationRecipientEmail {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.NotificationRecipientEmail(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotificationRecipientEmail(builtJavaResource)
    }
}

/**
 * Recipient Email details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateNotificationRecipientEmail
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationRecipientEmail = new AzureNative.ApiManagement.NotificationRecipientEmail("notificationRecipientEmail", new()
 *     {
 *         Email = "foobar@live.com",
 *         NotificationName = "RequestPublisherNotificationMessage",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewNotificationRecipientEmail(ctx, "notificationRecipientEmail", &apimanagement.NotificationRecipientEmailArgs{
 * 			Email:             pulumi.String("foobar@live.com"),
 * 			NotificationName:  pulumi.String("RequestPublisherNotificationMessage"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.NotificationRecipientEmail;
 * import com.pulumi.azurenative.apimanagement.NotificationRecipientEmailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationRecipientEmail = new NotificationRecipientEmail("notificationRecipientEmail", NotificationRecipientEmailArgs.builder()
 *             .email("foobar@live.com")
 *             .notificationName("RequestPublisherNotificationMessage")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:NotificationRecipientEmail foobar@live.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails/{email}
 * ```
 */
public class NotificationRecipientEmail internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.NotificationRecipientEmail,
) : KotlinCustomResource(javaResource, NotificationRecipientEmailMapper) {
    /**
     * User Email subscribed to notification.
     */
    public val email: Output<String>?
        get() = javaResource.email().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NotificationRecipientEmailMapper : ResourceMapper<NotificationRecipientEmail> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.NotificationRecipientEmail::class == javaResource::class

    override fun map(javaResource: Resource): NotificationRecipientEmail =
        NotificationRecipientEmail(
            javaResource as
                com.pulumi.azurenative.apimanagement.NotificationRecipientEmail,
        )
}

/**
 * @see [NotificationRecipientEmail].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotificationRecipientEmail].
 */
public suspend fun notificationRecipientEmail(
    name: String,
    block: suspend NotificationRecipientEmailResourceBuilder.() -> Unit,
):
    NotificationRecipientEmail {
    val builder = NotificationRecipientEmailResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotificationRecipientEmail].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notificationRecipientEmail(name: String): NotificationRecipientEmail {
    val builder = NotificationRecipientEmailResourceBuilder()
    builder.name(name)
    return builder.build()
}
