@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.OpenIdConnectProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * OpenId Connect Provider details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateOpenIdConnectProvider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var openIdConnectProvider = new AzureNative.ApiManagement.OpenIdConnectProvider("openIdConnectProvider", new()
 *     {
 *         ClientId = "oidprovidertemplate3",
 *         ClientSecret = "x",
 *         DisplayName = "templateoidprovider3",
 *         MetadataEndpoint = "https://oidprovider-template3.net",
 *         Opid = "templateOpenIdConnect3",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         UseInApiDocumentation = true,
 *         UseInTestConsole = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewOpenIdConnectProvider(ctx, "openIdConnectProvider", &apimanagement.OpenIdConnectProviderArgs{
 * 			ClientId:              pulumi.String("oidprovidertemplate3"),
 * 			ClientSecret:          pulumi.String("x"),
 * 			DisplayName:           pulumi.String("templateoidprovider3"),
 * 			MetadataEndpoint:      pulumi.String("https://oidprovider-template3.net"),
 * 			Opid:                  pulumi.String("templateOpenIdConnect3"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ServiceName:           pulumi.String("apimService1"),
 * 			UseInApiDocumentation: pulumi.Bool(true),
 * 			UseInTestConsole:      pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.OpenIdConnectProvider;
 * import com.pulumi.azurenative.apimanagement.OpenIdConnectProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var openIdConnectProvider = new OpenIdConnectProvider("openIdConnectProvider", OpenIdConnectProviderArgs.builder()
 *             .clientId("oidprovidertemplate3")
 *             .clientSecret("x")
 *             .displayName("templateoidprovider3")
 *             .metadataEndpoint("https://oidprovider-template3.net")
 *             .opid("templateOpenIdConnect3")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .useInApiDocumentation(true)
 *             .useInTestConsole(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:OpenIdConnectProvider templateOpenIdConnect3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/openidConnectProviders/{opid}
 * ```
 * @property clientId Client ID of developer console which is the client application.
 * @property clientSecret Client Secret of developer console which is the client application.
 * @property description User-friendly description of OpenID Connect Provider.
 * @property displayName User-friendly OpenID Connect Provider name.
 * @property metadataEndpoint Metadata endpoint URI.
 * @property opid Identifier of the OpenID Connect Provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property useInApiDocumentation If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by default if no value is provided.
 * @property useInTestConsole If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no value is provided.
 */
public data class OpenIdConnectProviderArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val metadataEndpoint: Output<String>? = null,
    public val opid: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val useInApiDocumentation: Output<Boolean>? = null,
    public val useInTestConsole: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.OpenIdConnectProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.OpenIdConnectProviderArgs =
        com.pulumi.azurenative.apimanagement.OpenIdConnectProviderArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .metadataEndpoint(metadataEndpoint?.applyValue({ args0 -> args0 }))
            .opid(opid?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .useInApiDocumentation(useInApiDocumentation?.applyValue({ args0 -> args0 }))
            .useInTestConsole(useInTestConsole?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenIdConnectProviderArgs].
 */
@PulumiTagMarker
public class OpenIdConnectProviderArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var metadataEndpoint: Output<String>? = null

    private var opid: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var useInApiDocumentation: Output<Boolean>? = null

    private var useInTestConsole: Output<Boolean>? = null

    /**
     * @param value Client ID of developer console which is the client application.
     */
    @JvmName("sslgftyjannwxdtn")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Client Secret of developer console which is the client application.
     */
    @JvmName("sgrcikbrimlbvvqw")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value User-friendly description of OpenID Connect Provider.
     */
    @JvmName("wdcyjueonikonmxu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value User-friendly OpenID Connect Provider name.
     */
    @JvmName("ybpljmbjhdnbsgvt")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Metadata endpoint URI.
     */
    @JvmName("dqrtdurudngpuiig")
    public suspend fun metadataEndpoint(`value`: Output<String>) {
        this.metadataEndpoint = value
    }

    /**
     * @param value Identifier of the OpenID Connect Provider.
     */
    @JvmName("pypmrnifqfaiwugk")
    public suspend fun opid(`value`: Output<String>) {
        this.opid = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("arnpqrynlwuhdgph")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("nvrcehbgoavqgxvu")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by default if no value is provided.
     */
    @JvmName("ghrpxqukthdcnjgo")
    public suspend fun useInApiDocumentation(`value`: Output<Boolean>) {
        this.useInApiDocumentation = value
    }

    /**
     * @param value If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no value is provided.
     */
    @JvmName("kaowyewsfufhthsd")
    public suspend fun useInTestConsole(`value`: Output<Boolean>) {
        this.useInTestConsole = value
    }

    /**
     * @param value Client ID of developer console which is the client application.
     */
    @JvmName("yaioedolnpecreef")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Client Secret of developer console which is the client application.
     */
    @JvmName("jaitpsnoducjdqgl")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value User-friendly description of OpenID Connect Provider.
     */
    @JvmName("fjbpmgdutwyjfryx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value User-friendly OpenID Connect Provider name.
     */
    @JvmName("naormaibfeatlrin")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Metadata endpoint URI.
     */
    @JvmName("tlxcyfnyxpojjxil")
    public suspend fun metadataEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataEndpoint = mapped
    }

    /**
     * @param value Identifier of the OpenID Connect Provider.
     */
    @JvmName("xqxyoggfgpmuoihk")
    public suspend fun opid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opid = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bdbvrmkdyhcghtwq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xgnulraqulcfejbl")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by default if no value is provided.
     */
    @JvmName("tyytiraursgclqjj")
    public suspend fun useInApiDocumentation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useInApiDocumentation = mapped
    }

    /**
     * @param value If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no value is provided.
     */
    @JvmName("vdseabuxkfnxqswy")
    public suspend fun useInTestConsole(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useInTestConsole = mapped
    }

    internal fun build(): OpenIdConnectProviderArgs = OpenIdConnectProviderArgs(
        clientId = clientId,
        clientSecret = clientSecret,
        description = description,
        displayName = displayName,
        metadataEndpoint = metadataEndpoint,
        opid = opid,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        useInApiDocumentation = useInApiDocumentation,
        useInTestConsole = useInTestConsole,
    )
}
