@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProductPolicy].
 */
@PulumiTagMarker
public class ProductPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductPolicyArgs = ProductPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductPolicyArgsBuilder.() -> Unit) {
        val builder = ProductPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProductPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ProductPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProductPolicy(builtJavaResource)
    }
}

/**
 * Policy Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-10-10, 2018-06-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProductPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var productPolicy = new AzureNative.ApiManagement.ProductPolicy("productPolicy", new()
 *     {
 *         Format = AzureNative.ApiManagement.PolicyContentFormat.Xml,
 *         PolicyId = "policy",
 *         ProductId = "5702e97e5157a50f48dce801",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = @"<policies>
 *   <inbound>
 *     <rate-limit calls=""{{call-count}}"" renewal-period=""15""></rate-limit>
 *     <log-to-eventhub logger-id=""16"">
 *                       @( string.Join("","", DateTime.UtcNow, context.Deployment.ServiceName, context.RequestId, context.Request.IpAddress, context.Operation.Name) )
 *                   </log-to-eventhub>
 *     <quota-by-key calls=""40"" counter-key=""cc"" renewal-period=""3600"" increment-count=""@(context.Request.Method == &quot;POST&quot; ? 1:2)"" />
 *     <base />
 *   </inbound>
 *   <backend>
 *     <base />
 *   </backend>
 *   <outbound>
 *     <base />
 *   </outbound>
 * </policies>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewProductPolicy(ctx, "productPolicy", &apimanagement.ProductPolicyArgs{
 * 			Format:            pulumi.String(apimanagement.PolicyContentFormatXml),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ProductId:         pulumi.String("5702e97e5157a50f48dce801"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<policies>
 *   <inbound>
 *     <rate-limit calls="{{call-count}}" renewal-period="15"></rate-limit>
 *     <log-to-eventhub logger-id="16">
 *                       @( string.Join(",", DateTime.UtcNow, context.Deployment.ServiceName, context.RequestId, context.Request.IpAddress, context.Operation.Name) )
 *                   </log-to-eventhub>
 *     <quota-by-key calls="40" counter-key="cc" renewal-period="3600" increment-count="@(context.Request.Method == &quot;POST&quot; ? 1:2)" />
 *     <base />
 *   </inbound>
 *   <backend>
 *     <base />
 *   </backend>
 *   <outbound>
 *     <base />
 *   </outbound>
 * </policies>`),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ProductPolicy;
 * import com.pulumi.azurenative.apimanagement.ProductPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var productPolicy = new ProductPolicy("productPolicy", ProductPolicyArgs.builder()
 *             .format("xml")
 *             .policyId("policy")
 *             .productId("5702e97e5157a50f48dce801")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("""
 * <policies>
 *   <inbound>
 *     <rate-limit calls="{{call-count}}" renewal-period="15"></rate-limit>
 *     <log-to-eventhub logger-id="16">
 *                       @( string.Join(",", DateTime.UtcNow, context.Deployment.ServiceName, context.RequestId, context.Request.IpAddress, context.Operation.Name) )
 *                   </log-to-eventhub>
 *     <quota-by-key calls="40" counter-key="cc" renewal-period="3600" increment-count="@(context.Request.Method == &quot;POST&quot; ? 1:2)" />
 *     <base />
 *   </inbound>
 *   <backend>
 *     <base />
 *   </backend>
 *   <outbound>
 *     <base />
 *   </outbound>
 * </policies>            """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ProductPolicy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policies/{policyId}
 * ```
 */
public class ProductPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ProductPolicy,
) : KotlinCustomResource(javaResource, ProductPolicyMapper) {
    /**
     * Format of the policyContent.
     */
    public val format: Output<String>?
        get() = javaResource.format().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Contents of the Policy as defined by the format.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object ProductPolicyMapper : ResourceMapper<ProductPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ProductPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ProductPolicy = ProductPolicy(
        javaResource as
            com.pulumi.azurenative.apimanagement.ProductPolicy,
    )
}

/**
 * @see [ProductPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProductPolicy].
 */
public suspend fun productPolicy(
    name: String,
    block: suspend ProductPolicyResourceBuilder.() -> Unit,
): ProductPolicy {
    val builder = ProductPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProductPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun productPolicy(name: String): ProductPolicy {
    val builder = ProductPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
