@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.SchemaArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.SchemaType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Schema Contract details.
 * Azure REST API version: 2021-04-01-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateSchema1
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schema = new AzureNative.ApiManagement.Schema("schema", new()
 *     {
 *         Description = "sample schema description",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "schema1",
 *         SchemaType = AzureNative.ApiManagement.SchemaType.Xml,
 *         ServiceName = "apimService1",
 *         Value = @"<xsd:schema xmlns:xsd=""http://www.w3.org/2001/XMLSchema""
 *            xmlns:tns=""http://tempuri.org/PurchaseOrderSchema.xsd""
 *            targetNamespace=""http://tempuri.org/PurchaseOrderSchema.xsd""
 *            elementFormDefault=""qualified"">
 *  <xsd:element name=""PurchaseOrder"" type=""tns:PurchaseOrderType""/>
 *  <xsd:complexType name=""PurchaseOrderType"">
 *   <xsd:sequence>
 *    <xsd:element name=""ShipTo"" type=""tns:USAddress"" maxOccurs=""2""/>
 *    <xsd:element name=""BillTo"" type=""tns:USAddress""/>
 *   </xsd:sequence>
 *   <xsd:attribute name=""OrderDate"" type=""xsd:date""/>
 *  </xsd:complexType>
 *  <xsd:complexType name=""USAddress"">
 *   <xsd:sequence>
 *    <xsd:element name=""name""   type=""xsd:string""/>
 *    <xsd:element name=""street"" type=""xsd:string""/>
 *    <xsd:element name=""city""   type=""xsd:string""/>
 *    <xsd:element name=""state""  type=""xsd:string""/>
 *    <xsd:element name=""zip""    type=""xsd:integer""/>
 *   </xsd:sequence>
 *   <xsd:attribute name=""country"" type=""xsd:NMTOKEN"" fixed=""US""/>
 *  </xsd:complexType>
 * </xsd:schema>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewSchema(ctx, "schema", &apimanagement.SchemaArgs{
 * 			Description:       pulumi.String("sample schema description"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("schema1"),
 * 			SchemaType:        pulumi.String(apimanagement.SchemaTypeXml),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
 *            xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            elementFormDefault="qualified">
 *  <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>
 *  <xsd:complexType name="PurchaseOrderType">
 *   <xsd:sequence>
 *    <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>
 *    <xsd:element name="BillTo" type="tns:USAddress"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="OrderDate" type="xsd:date"/>
 *  </xsd:complexType>
 *  <xsd:complexType name="USAddress">
 *   <xsd:sequence>
 *    <xsd:element name="name"   type="xsd:string"/>
 *    <xsd:element name="street" type="xsd:string"/>
 *    <xsd:element name="city"   type="xsd:string"/>
 *    <xsd:element name="state"  type="xsd:string"/>
 *    <xsd:element name="zip"    type="xsd:integer"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>
 *  </xsd:complexType>
 * </xsd:schema>`),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Schema;
 * import com.pulumi.azurenative.apimanagement.SchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schema = new Schema("schema", SchemaArgs.builder()
 *             .description("sample schema description")
 *             .resourceGroupName("rg1")
 *             .schemaId("schema1")
 *             .schemaType("xml")
 *             .serviceName("apimService1")
 *             .value("""
 * <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
 *            xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            elementFormDefault="qualified">
 *  <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>
 *  <xsd:complexType name="PurchaseOrderType">
 *   <xsd:sequence>
 *    <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>
 *    <xsd:element name="BillTo" type="tns:USAddress"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="OrderDate" type="xsd:date"/>
 *  </xsd:complexType>
 *  <xsd:complexType name="USAddress">
 *   <xsd:sequence>
 *    <xsd:element name="name"   type="xsd:string"/>
 *    <xsd:element name="street" type="xsd:string"/>
 *    <xsd:element name="city"   type="xsd:string"/>
 *    <xsd:element name="state"  type="xsd:string"/>
 *    <xsd:element name="zip"    type="xsd:integer"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>
 *  </xsd:complexType>
 * </xsd:schema>            """)
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateSchema2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schema = new AzureNative.ApiManagement.Schema("schema", new()
 *     {
 *         Description = "sample schema description",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "schema1",
 *         SchemaType = AzureNative.ApiManagement.SchemaType.Json,
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewSchema(ctx, "schema", &apimanagement.SchemaArgs{
 * 			Description:       pulumi.String("sample schema description"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("schema1"),
 * 			SchemaType:        pulumi.String(apimanagement.SchemaTypeJson),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Schema;
 * import com.pulumi.azurenative.apimanagement.SchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schema = new Schema("schema", SchemaArgs.builder()
 *             .description("sample schema description")
 *             .resourceGroupName("rg1")
 *             .schemaId("schema1")
 *             .schemaType("json")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Schema schema1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/schemas/{schemaId}
 * ```
 * @property description Free-form schema entity description.
 * @property resourceGroupName The name of the resource group.
 * @property schemaId Schema id identifier. Must be unique in the current API Management service instance.
 * @property schemaType Schema Type. Immutable.
 * @property serviceName The name of the API Management service.
 * @property value Json-encoded string for non json-based schema.
 */
public data class SchemaArgs(
    public val description: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaId: Output<String>? = null,
    public val schemaType: Output<Either<String, SchemaType>>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.SchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.SchemaArgs =
        com.pulumi.azurenative.apimanagement.SchemaArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaId(schemaId?.applyValue({ args0 -> args0 }))
            .schemaType(
                schemaType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SchemaArgs].
 */
@PulumiTagMarker
public class SchemaArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaId: Output<String>? = null

    private var schemaType: Output<Either<String, SchemaType>>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Free-form schema entity description.
     */
    @JvmName("xqgimgepvilqistx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hbwljatawykygffs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("wkdtwtqpdjsqjkfo")
    public suspend fun schemaId(`value`: Output<String>) {
        this.schemaId = value
    }

    /**
     * @param value Schema Type. Immutable.
     */
    @JvmName("tcxhgcvelreruhfp")
    public suspend fun schemaType(`value`: Output<Either<String, SchemaType>>) {
        this.schemaType = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("citlwawfcebuiomt")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Json-encoded string for non json-based schema.
     */
    @JvmName("ujijghdrjigecbia")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Free-form schema entity description.
     */
    @JvmName("ymdxelnvlaisbapc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qejfexdypryydhqa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("sxvjfjdrjkmpnodk")
    public suspend fun schemaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaId = mapped
    }

    /**
     * @param value Schema Type. Immutable.
     */
    @JvmName("vkdhrwhdgejwlych")
    public suspend fun schemaType(`value`: Either<String, SchemaType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value Schema Type. Immutable.
     */
    @JvmName("coolfuxffexwjcuv")
    public fun schemaType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value Schema Type. Immutable.
     */
    @JvmName("ebyuxswnnfmrsgvw")
    public fun schemaType(`value`: SchemaType) {
        val toBeMapped = Either.ofRight<String, SchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("neqmfkvxuihbsuwp")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Json-encoded string for non json-based schema.
     */
    @JvmName("ysieqgiwatgdqboa")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SchemaArgs = SchemaArgs(
        description = description,
        resourceGroupName = resourceGroupName,
        schemaId = schemaId,
        schemaType = schemaType,
        serviceName = serviceName,
        `value` = `value`,
    )
}
