@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.TagApiLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Tag-API link details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateTagApiLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagApiLink = new AzureNative.ApiManagement.TagApiLink("tagApiLink", new()
 *     {
 *         ApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api",
 *         ApiLinkId = "link1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagId = "tag1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewTagApiLink(ctx, "tagApiLink", &apimanagement.TagApiLinkArgs{
 * 			ApiId:             pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api"),
 * 			ApiLinkId:         pulumi.String("link1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			TagId:             pulumi.String("tag1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.TagApiLink;
 * import com.pulumi.azurenative.apimanagement.TagApiLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagApiLink = new TagApiLink("tagApiLink", TagApiLinkArgs.builder()
 *             .apiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api")
 *             .apiLinkId("link1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagId("tag1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:TagApiLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/apiLinks/{apiLinkId}
 * ```
 * @property apiId Full resource Id of an API.
 * @property apiLinkId Tag-API link identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagId Tag identifier. Must be unique in the current API Management service instance.
 */
public data class TagApiLinkArgs(
    public val apiId: Output<String>? = null,
    public val apiLinkId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tagId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.TagApiLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.TagApiLinkArgs =
        com.pulumi.azurenative.apimanagement.TagApiLinkArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .apiLinkId(apiLinkId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tagId(tagId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagApiLinkArgs].
 */
@PulumiTagMarker
public class TagApiLinkArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var apiLinkId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tagId: Output<String>? = null

    /**
     * @param value Full resource Id of an API.
     */
    @JvmName("kcauawgysloycgxo")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Tag-API link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("aeumsxbvlvfyqweb")
    public suspend fun apiLinkId(`value`: Output<String>) {
        this.apiLinkId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("snlwcwabxfptisxs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("eajujkphiplxjnyo")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("gsiuwqrepvhfiewt")
    public suspend fun tagId(`value`: Output<String>) {
        this.tagId = value
    }

    /**
     * @param value Full resource Id of an API.
     */
    @JvmName("gsocfkhopgmeulpy")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Tag-API link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("yocudflcehguycho")
    public suspend fun apiLinkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiLinkId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rfbtilsriyrdbtkv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("uefkcykvmiuskgpj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("noafvlnahyoktpcb")
    public suspend fun tagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagId = mapped
    }

    internal fun build(): TagApiLinkArgs = TagApiLinkArgs(
        apiId = apiId,
        apiLinkId = apiLinkId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tagId = tagId,
    )
}
