@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.TagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Tag Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateTag
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tag = new AzureNative.ApiManagement.Tag("tag", new()
 *     {
 *         DisplayName = "tag1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagId = "tagId1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewTag(ctx, "tag", &apimanagement.TagArgs{
 * 			DisplayName:       pulumi.String("tag1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			TagId:             pulumi.String("tagId1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Tag;
 * import com.pulumi.azurenative.apimanagement.TagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tag = new Tag("tag", TagArgs.builder()
 *             .displayName("tag1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagId("tagId1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Tag tagId1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}
 * ```
 * @property displayName Tag name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagId Tag identifier. Must be unique in the current API Management service instance.
 */
public data class TagArgs(
    public val displayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tagId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.TagArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.TagArgs =
        com.pulumi.azurenative.apimanagement.TagArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tagId(tagId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagArgs].
 */
@PulumiTagMarker
public class TagArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tagId: Output<String>? = null

    /**
     * @param value Tag name.
     */
    @JvmName("xvsruqptrgjrtiyh")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xvojhtrxhmuqhmjy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("lmpqprdxlkciovee")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("upmfvwkbyaegraql")
    public suspend fun tagId(`value`: Output<String>) {
        this.tagId = value
    }

    /**
     * @param value Tag name.
     */
    @JvmName("olvybqxhblicxdkx")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mkgukpaveomuiggk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vyywionhlaxurhau")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("wcokearqrglweusc")
    public suspend fun tagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagId = mapped
    }

    internal fun build(): TagArgs = TagArgs(
        displayName = displayName,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tagId = tagId,
    )
}
