@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TagProductLink].
 */
@PulumiTagMarker
public class TagProductLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagProductLinkArgs = TagProductLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagProductLinkArgsBuilder.() -> Unit) {
        val builder = TagProductLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TagProductLink {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.TagProductLink(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TagProductLink(builtJavaResource)
    }
}

/**
 * Tag-product link details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateTagProductLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagProductLink = new AzureNative.ApiManagement.TagProductLink("tagProductLink", new()
 *     {
 *         ProductId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/products/product1",
 *         ProductLinkId = "link1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagId = "tag1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewTagProductLink(ctx, "tagProductLink", &apimanagement.TagProductLinkArgs{
 * 			ProductId:         pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/products/product1"),
 * 			ProductLinkId:     pulumi.String("link1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			TagId:             pulumi.String("tag1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.TagProductLink;
 * import com.pulumi.azurenative.apimanagement.TagProductLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagProductLink = new TagProductLink("tagProductLink", TagProductLinkArgs.builder()
 *             .productId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/products/product1")
 *             .productLinkId("link1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagId("tag1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:TagProductLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}
 * ```
 */
public class TagProductLink internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.TagProductLink,
) : KotlinCustomResource(javaResource, TagProductLinkMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Full resource Id of a product.
     */
    public val productId: Output<String>
        get() = javaResource.productId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TagProductLinkMapper : ResourceMapper<TagProductLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.TagProductLink::class == javaResource::class

    override fun map(javaResource: Resource): TagProductLink = TagProductLink(
        javaResource as
            com.pulumi.azurenative.apimanagement.TagProductLink,
    )
}

/**
 * @see [TagProductLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagProductLink].
 */
public suspend fun tagProductLink(
    name: String,
    block: suspend TagProductLinkResourceBuilder.() -> Unit,
): TagProductLink {
    val builder = TagProductLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagProductLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagProductLink(name: String): TagProductLink {
    val builder = TagProductLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
