@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.UserArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.AppType
import com.pulumi.azurenative.apimanagement.kotlin.enums.Confirmation
import com.pulumi.azurenative.apimanagement.kotlin.enums.UserState
import com.pulumi.azurenative.apimanagement.kotlin.inputs.UserIdentityContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.UserIdentityContractArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * User details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AzureNative.ApiManagement.User("user", new()
 *     {
 *         Confirmation = AzureNative.ApiManagement.Confirmation.Signup,
 *         Email = "foobar@outlook.com",
 *         FirstName = "foo",
 *         LastName = "bar",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         UserId = "5931a75ae4bbd512288c680b",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewUser(ctx, "user", &apimanagement.UserArgs{
 * 			Confirmation:      pulumi.String(apimanagement.ConfirmationSignup),
 * 			Email:             pulumi.String("foobar@outlook.com"),
 * 			FirstName:         pulumi.String("foo"),
 * 			LastName:          pulumi.String("bar"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			UserId:            pulumi.String("5931a75ae4bbd512288c680b"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.User;
 * import com.pulumi.azurenative.apimanagement.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .confirmation("signup")
 *             .email("foobar@outlook.com")
 *             .firstName("foo")
 *             .lastName("bar")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .userId("5931a75ae4bbd512288c680b")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:User 5931a75ae4bbd512288c680b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{userId}
 * ```
 * @property appType Determines the type of application which send the create user request. Default is legacy portal.
 * @property confirmation Determines the type of confirmation e-mail that will be sent to the newly created user.
 * @property email Email address. Must not be empty and must be unique within the service instance.
 * @property firstName First name.
 * @property identities Collection of user identities.
 * @property lastName Last name.
 * @property note Optional note about a user set by the administrator.
 * @property notify Send an Email notification to the User.
 * @property password User Password. If no value is provided, a default password is generated.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property state Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active.
 * @property userId User identifier. Must be unique in the current API Management service instance.
 */
public data class UserArgs(
    public val appType: Output<Either<String, AppType>>? = null,
    public val confirmation: Output<Either<String, Confirmation>>? = null,
    public val email: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val identities: Output<List<UserIdentityContractArgs>>? = null,
    public val lastName: Output<String>? = null,
    public val note: Output<String>? = null,
    public val notify: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val state: Output<Either<String, UserState>>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.UserArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.UserArgs =
        com.pulumi.azurenative.apimanagement.UserArgs.builder()
            .appType(
                appType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .confirmation(
                confirmation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .email(email?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .identities(
                identities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .note(note?.applyValue({ args0 -> args0 }))
            .notify_(notify?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var appType: Output<Either<String, AppType>>? = null

    private var confirmation: Output<Either<String, Confirmation>>? = null

    private var email: Output<String>? = null

    private var firstName: Output<String>? = null

    private var identities: Output<List<UserIdentityContractArgs>>? = null

    private var lastName: Output<String>? = null

    private var note: Output<String>? = null

    private var notify: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var state: Output<Either<String, UserState>>? = null

    private var userId: Output<String>? = null

    /**
     * @param value Determines the type of application which send the create user request. Default is legacy portal.
     */
    @JvmName("mqoiyypbiuwkmlje")
    public suspend fun appType(`value`: Output<Either<String, AppType>>) {
        this.appType = value
    }

    /**
     * @param value Determines the type of confirmation e-mail that will be sent to the newly created user.
     */
    @JvmName("hpoglklsvawvmbof")
    public suspend fun confirmation(`value`: Output<Either<String, Confirmation>>) {
        this.confirmation = value
    }

    /**
     * @param value Email address. Must not be empty and must be unique within the service instance.
     */
    @JvmName("hdrgytqxywmvwwfk")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value First name.
     */
    @JvmName("jphuwtlfxxhrukkp")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value Collection of user identities.
     */
    @JvmName("nrmifwdejrhaqmxb")
    public suspend fun identities(`value`: Output<List<UserIdentityContractArgs>>) {
        this.identities = value
    }

    @JvmName("fdveowjjpvowytix")
    public suspend fun identities(vararg values: Output<UserIdentityContractArgs>) {
        this.identities = Output.all(values.asList())
    }

    /**
     * @param values Collection of user identities.
     */
    @JvmName("cjuxdahcillhkaeh")
    public suspend fun identities(values: List<Output<UserIdentityContractArgs>>) {
        this.identities = Output.all(values)
    }

    /**
     * @param value Last name.
     */
    @JvmName("dfiuknscbjohraxj")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value Optional note about a user set by the administrator.
     */
    @JvmName("gwsdceqexeisxtia")
    public suspend fun note(`value`: Output<String>) {
        this.note = value
    }

    /**
     * @param value Send an Email notification to the User.
     */
    @JvmName("cjndcwtepiyqassj")
    public suspend fun notify(`value`: Output<Boolean>) {
        this.notify = value
    }

    /**
     * @param value User Password. If no value is provided, a default password is generated.
     */
    @JvmName("ethbxrebnjtnhejw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kyouagbfbbmmhbdi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("pifasnuscasrxnmq")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     */
    @JvmName("cpborhtuidnrswqm")
    public suspend fun state(`value`: Output<Either<String, UserState>>) {
        this.state = value
    }

    /**
     * @param value User identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jpnqkvcntkuapwbt")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value Determines the type of application which send the create user request. Default is legacy portal.
     */
    @JvmName("bijhofqrlblfjcht")
    public suspend fun appType(`value`: Either<String, AppType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appType = mapped
    }

    /**
     * @param value Determines the type of application which send the create user request. Default is legacy portal.
     */
    @JvmName("meokrucivdrdifxc")
    public fun appType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AppType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appType = mapped
    }

    /**
     * @param value Determines the type of application which send the create user request. Default is legacy portal.
     */
    @JvmName("mijwoixjlqdpwusv")
    public fun appType(`value`: AppType) {
        val toBeMapped = Either.ofRight<String, AppType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appType = mapped
    }

    /**
     * @param value Determines the type of confirmation e-mail that will be sent to the newly created user.
     */
    @JvmName("lagkqbvskuwxrije")
    public suspend fun confirmation(`value`: Either<String, Confirmation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmation = mapped
    }

    /**
     * @param value Determines the type of confirmation e-mail that will be sent to the newly created user.
     */
    @JvmName("jvwwqhponicmqhai")
    public fun confirmation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Confirmation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.confirmation = mapped
    }

    /**
     * @param value Determines the type of confirmation e-mail that will be sent to the newly created user.
     */
    @JvmName("wdoevwwrmsnsrfrx")
    public fun confirmation(`value`: Confirmation) {
        val toBeMapped = Either.ofRight<String, Confirmation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.confirmation = mapped
    }

    /**
     * @param value Email address. Must not be empty and must be unique within the service instance.
     */
    @JvmName("jkkifrcderygopxn")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value First name.
     */
    @JvmName("anrmvuvriomoyncx")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value Collection of user identities.
     */
    @JvmName("qggfullpbpymikwm")
    public suspend fun identities(`value`: List<UserIdentityContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identities = mapped
    }

    /**
     * @param argument Collection of user identities.
     */
    @JvmName("wxmqjwgelmcofdny")
    public suspend
    fun identities(argument: List<suspend UserIdentityContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserIdentityContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identities = mapped
    }

    /**
     * @param argument Collection of user identities.
     */
    @JvmName("mjtbdsbpnjjhxixq")
    public suspend fun identities(
        vararg
        argument: suspend UserIdentityContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            UserIdentityContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identities = mapped
    }

    /**
     * @param argument Collection of user identities.
     */
    @JvmName("gfthnjchdwcvjgvd")
    public suspend fun identities(argument: suspend UserIdentityContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserIdentityContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.identities = mapped
    }

    /**
     * @param values Collection of user identities.
     */
    @JvmName("dhrnpvsmiorgsfjq")
    public suspend fun identities(vararg values: UserIdentityContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identities = mapped
    }

    /**
     * @param value Last name.
     */
    @JvmName("kmymuraglhlcjapl")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value Optional note about a user set by the administrator.
     */
    @JvmName("tsnmidnhemchecfi")
    public suspend fun note(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.note = mapped
    }

    /**
     * @param value Send an Email notification to the User.
     */
    @JvmName("afxjmcgodeobpeko")
    public suspend fun notify(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notify = mapped
    }

    /**
     * @param value User Password. If no value is provided, a default password is generated.
     */
    @JvmName("groejcdukpcejjol")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("upxnpaqpsykmlttx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("efvsnqqxfdfkxpco")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     */
    @JvmName("ieewlhrccwniyidc")
    public suspend fun state(`value`: Either<String, UserState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     */
    @JvmName("enxqvfxacxhycxve")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UserState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     */
    @JvmName("wsdnmbwycoadypmo")
    public fun state(`value`: UserState) {
        val toBeMapped = Either.ofRight<String, UserState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value User identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("oikhalcytdqbrimk")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        appType = appType,
        confirmation = confirmation,
        email = email,
        firstName = firstName,
        identities = identities,
        lastName = lastName,
        note = note,
        notify = notify,
        password = password,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        state = state,
        userId = userId,
    )
}
