@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceNamedValueArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.KeyVaultContractCreatePropertiesArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.KeyVaultContractCreatePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NamedValue details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceNamedValue
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceNamedValue = new AzureNative.ApiManagement.WorkspaceNamedValue("workspaceNamedValue", new()
 *     {
 *         DisplayName = "prop3name",
 *         NamedValueId = "testprop2",
 *         ResourceGroupName = "rg1",
 *         Secret = false,
 *         ServiceName = "apimService1",
 *         Tags = new[]
 *         {
 *             "foo",
 *             "bar",
 *         },
 *         Value = "propValue",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceNamedValue(ctx, "workspaceNamedValue", &apimanagement.WorkspaceNamedValueArgs{
 * 			DisplayName:       pulumi.String("prop3name"),
 * 			NamedValueId:      pulumi.String("testprop2"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Secret:            pulumi.Bool(false),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Tags: pulumi.StringArray{
 * 				pulumi.String("foo"),
 * 				pulumi.String("bar"),
 * 			},
 * 			Value:       pulumi.String("propValue"),
 * 			WorkspaceId: pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNamedValue;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNamedValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceNamedValue = new WorkspaceNamedValue("workspaceNamedValue", WorkspaceNamedValueArgs.builder()
 *             .displayName("prop3name")
 *             .namedValueId("testprop2")
 *             .resourceGroupName("rg1")
 *             .secret(false)
 *             .serviceName("apimService1")
 *             .tags(
 *                 "foo",
 *                 "bar")
 *             .value("propValue")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateWorkspaceNamedValueWithKeyVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceNamedValue = new AzureNative.ApiManagement.WorkspaceNamedValue("workspaceNamedValue", new()
 *     {
 *         DisplayName = "prop6namekv",
 *         KeyVault = new AzureNative.ApiManagement.Inputs.KeyVaultContractCreatePropertiesArgs
 *         {
 *             IdentityClientId = "ceaa6b06-c00f-43ef-99ac-f53d1fe876a0",
 *             SecretIdentifier = "https://contoso.vault.azure.net/secrets/aadSecret",
 *         },
 *         NamedValueId = "testprop6",
 *         ResourceGroupName = "rg1",
 *         Secret = true,
 *         ServiceName = "apimService1",
 *         Tags = new[]
 *         {
 *             "foo",
 *             "bar",
 *         },
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceNamedValue(ctx, "workspaceNamedValue", &apimanagement.WorkspaceNamedValueArgs{
 * 			DisplayName: pulumi.String("prop6namekv"),
 * 			KeyVault: &apimanagement.KeyVaultContractCreatePropertiesArgs{
 * 				IdentityClientId: pulumi.String("ceaa6b06-c00f-43ef-99ac-f53d1fe876a0"),
 * 				SecretIdentifier: pulumi.String("https://contoso.vault.azure.net/secrets/aadSecret"),
 * 			},
 * 			NamedValueId:      pulumi.String("testprop6"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Secret:            pulumi.Bool(true),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Tags: pulumi.StringArray{
 * 				pulumi.String("foo"),
 * 				pulumi.String("bar"),
 * 			},
 * 			WorkspaceId: pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNamedValue;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNamedValueArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.KeyVaultContractCreatePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceNamedValue = new WorkspaceNamedValue("workspaceNamedValue", WorkspaceNamedValueArgs.builder()
 *             .displayName("prop6namekv")
 *             .keyVault(KeyVaultContractCreatePropertiesArgs.builder()
 *                 .identityClientId("ceaa6b06-c00f-43ef-99ac-f53d1fe876a0")
 *                 .secretIdentifier("https://contoso.vault.azure.net/secrets/aadSecret")
 *                 .build())
 *             .namedValueId("testprop6")
 *             .resourceGroupName("rg1")
 *             .secret(true)
 *             .serviceName("apimService1")
 *             .tags(
 *                 "foo",
 *                 "bar")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceNamedValue testprop6 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}
 * ```
 * @property displayName Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
 * @property keyVault KeyVault location details of the namedValue.
 * @property namedValueId Identifier of the NamedValue.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property secret Determines whether the value is a secret and should be encrypted or not. Default value is false.
 * @property serviceName The name of the API Management service.
 * @property tags Optional tags that when provided can be used to filter the NamedValue list.
 * @property value Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceNamedValueArgs(
    public val displayName: Output<String>? = null,
    public val keyVault: Output<KeyVaultContractCreatePropertiesArgs>? = null,
    public val namedValueId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secret: Output<Boolean>? = null,
    public val serviceName: Output<String>? = null,
    public val tags: Output<List<String>>? = null,
    public val `value`: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceNamedValueArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceNamedValueArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceNamedValueArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .namedValueId(namedValueId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secret(secret?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceNamedValueArgs].
 */
@PulumiTagMarker
public class WorkspaceNamedValueArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var keyVault: Output<KeyVaultContractCreatePropertiesArgs>? = null

    private var namedValueId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secret: Output<Boolean>? = null

    private var serviceName: Output<String>? = null

    private var tags: Output<List<String>>? = null

    private var `value`: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
     */
    @JvmName("weiopracodviktdn")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value KeyVault location details of the namedValue.
     */
    @JvmName("thsomevvntcsbotc")
    public suspend fun keyVault(`value`: Output<KeyVaultContractCreatePropertiesArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Identifier of the NamedValue.
     */
    @JvmName("jlnnhnequrermeur")
    public suspend fun namedValueId(`value`: Output<String>) {
        this.namedValueId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jnguwimghckdggtt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Determines whether the value is a secret and should be encrypted or not. Default value is false.
     */
    @JvmName("juggrpmuwlqoxvtv")
    public suspend fun secret(`value`: Output<Boolean>) {
        this.secret = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("cfpbdknhtgbvyunj")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Optional tags that when provided can be used to filter the NamedValue list.
     */
    @JvmName("ociigooqnslsqjhl")
    public suspend fun tags(`value`: Output<List<String>>) {
        this.tags = value
    }

    @JvmName("ruteocwsxinmylcm")
    public suspend fun tags(vararg values: Output<String>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values Optional tags that when provided can be used to filter the NamedValue list.
     */
    @JvmName("dfcfeooxjlqcrrnw")
    public suspend fun tags(values: List<Output<String>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
     */
    @JvmName("jhjcxbotdyqxaxap")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("sanecnrlasaqxwlo")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
     */
    @JvmName("rrgsclaooimeeyob")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value KeyVault location details of the namedValue.
     */
    @JvmName("enebtwlabxrfdglq")
    public suspend fun keyVault(`value`: KeyVaultContractCreatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument KeyVault location details of the namedValue.
     */
    @JvmName("jqpicibwwrjkvbfu")
    public suspend
    fun keyVault(argument: suspend KeyVaultContractCreatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultContractCreatePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Identifier of the NamedValue.
     */
    @JvmName("konxmgcowxwpmwrt")
    public suspend fun namedValueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namedValueId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tsegfiilcvjkqlri")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Determines whether the value is a secret and should be encrypted or not. Default value is false.
     */
    @JvmName("uxqwyxxaruvustud")
    public suspend fun secret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jspokqihntkmgyrq")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Optional tags that when provided can be used to filter the NamedValue list.
     */
    @JvmName("xlrnanmfomemmcji")
    public suspend fun tags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Optional tags that when provided can be used to filter the NamedValue list.
     */
    @JvmName("rcvjvmokaijjjslx")
    public suspend fun tags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
     */
    @JvmName("kbcsljghtoefiyui")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("sembcnfnbkwiykoj")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceNamedValueArgs = WorkspaceNamedValueArgs(
        displayName = displayName,
        keyVault = keyVault,
        namedValueId = namedValueId,
        resourceGroupName = resourceGroupName,
        secret = secret,
        serviceName = serviceName,
        tags = tags,
        `value` = `value`,
        workspaceId = workspaceId,
    )
}
