@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspacePolicy].
 */
@PulumiTagMarker
public class WorkspacePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspacePolicyArgs = WorkspacePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspacePolicyArgsBuilder.() -> Unit) {
        val builder = WorkspacePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspacePolicy {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspacePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspacePolicy(builtJavaResource)
    }
}

/**
 * Policy Contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspacePolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspacePolicy = new AzureNative.ApiManagement.WorkspacePolicy("workspacePolicy", new()
 *     {
 *         Format = AzureNative.ApiManagement.PolicyContentFormat.Xml,
 *         PolicyId = "policy",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspacePolicy(ctx, "workspacePolicy", &apimanagement.WorkspacePolicyArgs{
 * 			Format:            pulumi.String(apimanagement.PolicyContentFormatXml),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicy;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspacePolicy = new WorkspacePolicy("workspacePolicy", WorkspacePolicyArgs.builder()
 *             .format("xml")
 *             .policyId("policy")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateWorkspacePolicyNonXmlEncoded
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspacePolicy = new AzureNative.ApiManagement.WorkspacePolicy("workspacePolicy", new()
 *     {
 *         Format = AzureNative.ApiManagement.PolicyContentFormat.Rawxml,
 *         PolicyId = "policy",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = @"<policies>
 *      <inbound>
 *      <base />
 *   <set-header name=""newvalue"" exists-action=""override"">
 *    <value>""@(context.Request.Headers.FirstOrDefault(h => h.Ke==""Via""))"" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspacePolicy(ctx, "workspacePolicy", &apimanagement.WorkspacePolicyArgs{
 * 			Format:            pulumi.String(apimanagement.PolicyContentFormatRawxml),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<policies>
 *      <inbound>
 *      <base />
 *   <set-header name="newvalue" exists-action="override">
 *    <value>"@(context.Request.Headers.FirstOrDefault(h => h.Ke=="Via"))" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>`),
 * 			WorkspaceId: pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicy;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspacePolicy = new WorkspacePolicy("workspacePolicy", WorkspacePolicyArgs.builder()
 *             .format("rawxml")
 *             .policyId("policy")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("""
 * <policies>
 *      <inbound>
 *      <base />
 *   <set-header name="newvalue" exists-action="override">
 *    <value>"@(context.Request.Headers.FirstOrDefault(h => h.Ke=="Via"))" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>            """)
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspacePolicy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/policies/{policyId}
 * ```
 */
public class WorkspacePolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.WorkspacePolicy,
) : KotlinCustomResource(javaResource, WorkspacePolicyMapper) {
    /**
     * Format of the policyContent.
     */
    public val format: Output<String>?
        get() = javaResource.format().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Contents of the Policy as defined by the format.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object WorkspacePolicyMapper : ResourceMapper<WorkspacePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspacePolicy::class == javaResource::class

    override fun map(javaResource: Resource): WorkspacePolicy = WorkspacePolicy(
        javaResource as
            com.pulumi.azurenative.apimanagement.WorkspacePolicy,
    )
}

/**
 * @see [WorkspacePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspacePolicy].
 */
public suspend fun workspacePolicy(
    name: String,
    block: suspend WorkspacePolicyResourceBuilder.() -> Unit,
): WorkspacePolicy {
    val builder = WorkspacePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspacePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspacePolicy(name: String): WorkspacePolicy {
    val builder = WorkspacePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
